/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class RepositoryCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new RepositoryCodeGenerate(element, generateCrud).generate();
    }

    public static void generate(Element element, String useCase, String nameSubPackage) {
        new RepositoryCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    RepositoryCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    RepositoryCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        super(element, generateCrud);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.REPOSITORY;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.crud.repository.CrudRepository;");
        ProcessorUtils.addCode(sbListCode, "import javax.enterprise.inject.spi.CDI;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "public interface " + this.getName() + " extends CrudRepository<" + this.getNameEntity() + "> {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tstatic " + this.getName() + " getInstance() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn CDI.current().select(" + this.getName() + ".class).get();");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

