/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.DataControllerCodeGenerate;
import br.com.jarch.apt.generate.DataDetailCodeGenerate;
import br.com.jarch.apt.generate.DataXhtmlCodeGenerate;
import br.com.jarch.apt.generate.EntityCodeGenerate;
import br.com.jarch.apt.generate.FilterSelectControllerCodeGenerate;
import br.com.jarch.apt.generate.JpaRepositoryCodeGenerate;
import br.com.jarch.apt.generate.JpqlBuilderCodeGenerate;
import br.com.jarch.apt.generate.ListControllerCodeGenerate;
import br.com.jarch.apt.generate.ListXhtmlCodeGenerate;
import br.com.jarch.apt.generate.ObserverCodeGenerate;
import br.com.jarch.apt.generate.PackageInfoCodeGenerate;
import br.com.jarch.apt.generate.RepositoryCodeGenerate;
import br.com.jarch.apt.generate.RestCodeGenerate;
import br.com.jarch.apt.generate.SearchCodeGenerate;
import br.com.jarch.apt.generate.ServiceCodeGenerate;
import br.com.jarch.apt.generate.SystemTestGenerate;
import br.com.jarch.apt.generate.UpdateBundle;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.util.DateUtils;
import java.time.LocalDateTime;
import java.util.Arrays;
import javax.lang.model.element.Element;

public class GenerateCrud {
    private final Element element;

    public GenerateCrud(Element element) {
        this.element = element;
    }

    public void generate() {
        JArchGenerateCrud[] generateCruds = (JArchGenerateCrud[])this.element.getAnnotationsByType(JArchGenerateCrud.class);
        if (generateCruds == null || generateCruds.length == 0) {
            return;
        }
        Arrays.stream(generateCruds).filter(generateCrud -> !generateCrud.created()).forEach(generateCrud -> {
            ProcessorUtils.messageWarning(DateUtils.formatyyyyMMddHHmmss(LocalDateTime.now()) + ": ### JARCH APT: Analyzing logic " + generateCrud.annotationType().getSimpleName() + " ===>>> " + generateCrud.master().name() + " ###", this.element);
            if (ProcessorUtils.validExistsFieldSearch(this.element, generateCrud)) {
                this.createEntityMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createSearchMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createJpqlBuilderMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createRepositoryMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createJpaRepositoryMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createServiceMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createObserverMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createRestMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.createPackageInfoMasterSubDetail((JArchGenerateCrud)generateCrud);
                this.updateBundleMasterSubDetail((JArchGenerateCrud)generateCrud);
                boolean createControllers = ProcessorUtils.isExistsEntity(this.element, generateCrud);
                if (createControllers) {
                    this.createControllersMasterSubDetail((JArchGenerateCrud)generateCrud);
                    this.createFilterSelectMasterSubDetail((JArchGenerateCrud)generateCrud);
                    this.createDataDetailMasterSubDetail((JArchGenerateCrud)generateCrud);
                    for (int i = 0; i < generateCrud.master().details().length; ++i) {
                        DataDetailCodeGenerate.generate(this.element, generateCrud.master().details()[i].name(), generateCrud.nameSubPackage());
                        FilterSelectControllerCodeGenerate.generate(this.element, generateCrud.master().details()[i].name(), generateCrud.nameSubPackage());
                        for (int j = 0; j < generateCrud.master().details()[i].subDetails().length; ++j) {
                            DataDetailCodeGenerate.generate(this.element, generateCrud.master().details()[i].subDetails()[j].name(), generateCrud.nameSubPackage());
                            FilterSelectControllerCodeGenerate.generate(this.element, generateCrud.master().details()[i].subDetails()[j].name(), generateCrud.nameSubPackage());
                        }
                    }
                    this.createXhtmlsMasterSubDetail((JArchGenerateCrud)generateCrud);
                    this.createSystemTest((JArchGenerateCrud)generateCrud);
                } else {
                    ProcessorUtils.messageNote("3. ATTENTION !!! CONTROLLER'S, XHTML'S AND TEST'S CODE WILL BE CREATED IN NEXT COMPILATION", this.element);
                }
            }
        });
    }

    private void createEntityMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.entity()) {
            EntityCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createSearchMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.entity()) {
            SearchCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createJpqlBuilderMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.entity()) {
            JpqlBuilderCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createRepositoryMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.repository()) {
            RepositoryCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createJpaRepositoryMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.jpaRepository()) {
            JpaRepositoryCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createServiceMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.service()) {
            ServiceCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createObserverMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.observer()) {
            ObserverCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createRestMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.rest()) {
            RestCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createPackageInfoMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.packageInfo()) {
            PackageInfoCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void updateBundleMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.updateBundle()) {
            UpdateBundle.update(this.element, generateCrud);
        }
    }

    private void createControllersMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.controller()) {
            ListControllerCodeGenerate.generate(this.element, generateCrud);
            DataControllerCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createFilterSelectMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.entity() && generateCrud.controller()) {
            FilterSelectControllerCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createDataDetailMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.entity() && generateCrud.controller()) {
            DataDetailCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createXhtmlsMasterSubDetail(JArchGenerateCrud generateCrud) {
        if (generateCrud.xhtml()) {
            ListXhtmlCodeGenerate.generate(this.element, generateCrud);
            DataXhtmlCodeGenerate.generate(this.element, generateCrud);
        }
    }

    private void createSystemTest(JArchGenerateCrud generateCrud) {
        if (generateCrud.systemTest()) {
            SystemTestGenerate.generate(this.element, generateCrud);
        }
    }
}

