/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.EmbeddableAddressCodeGenerate;
import br.com.jarch.apt.generate.JpaConverterCodeGenerate;
import br.com.jarch.apt.generate.JpaRepositoryCodeGenerate;
import br.com.jarch.apt.generate.JpqlBuilderCodeGenerate;
import br.com.jarch.apt.generate.RepositoryCodeGenerate;
import br.com.jarch.apt.generate.SearchCodeGenerate;
import br.com.jarch.apt.generate.ServiceCodeGenerate;
import br.com.jarch.apt.generate.TypeCodeGenerate;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public final class EntityCodeGenerate {
    private final Element element;
    private final JArchGenerateCrud generateCrud;
    private final String nameSubPackage;
    private final boolean secret;
    private final boolean exclusionLogic;
    private File folderScript;
    private String namePackage;
    private final Set<String> imports = new HashSet<String>();
    private final List<String> columnsDataTable = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> getSets = new ArrayList<String>();
    private final List<String> getSetEnums = new ArrayList<String>();

    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new EntityCodeGenerate(element, generateCrud).create();
    }

    EntityCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        this.element = element;
        this.generateCrud = generateCrud;
        this.nameSubPackage = generateCrud.nameSubPackage();
        this.secret = generateCrud.secret();
        this.exclusionLogic = generateCrud.exclusionLogic();
        this.configEnviroment();
    }

    public void create() {
        this.createLogicMasterSubDetail();
    }

    private void createLogicMasterSubDetail() {
        List<FieldForm> fieldForms = ProcessorUtils.getListFieldForm(this.generateCrud.master().fields());
        this.loadImportsFieldsGetsSetsEnums(fieldForms, this.imports, this.fields, this.columnsDataTable, this.getSets, this.getSetEnums);
        String nameMaster = this.generateCrud.master().name();
        String tableNameMaster = this.generateCrud.master().tableName();
        List<String> details = Arrays.stream(this.generateCrud.master().details()).map(JArchGenerateCrud.Detail::name).collect(Collectors.toList());
        String codeLookup = fieldForms.stream().filter(FieldForm::isCodeLookup).map(FieldForm::getAtributo).findAny().orElse(null);
        String descriptionLookup = fieldForms.stream().filter(FieldForm::isDescriptionLookup).map(FieldForm::getAtributo).findAny().orElse(null);
        this.saveEntity(nameMaster, tableNameMaster, this.imports, this.fields, this.getSets, this.getSetEnums, null, details, codeLookup, descriptionLookup, fieldForms);
        this.saveEnums(fieldForms);
        this.saveEnderecos(fieldForms);
        this.generateScriptDataBase(nameMaster, tableNameMaster, fieldForms, null);
        this.generateDetailFromMasterDetailSubDetail(nameMaster, tableNameMaster);
    }

    private void generateDetailFromMasterDetailSubDetail(String nameMaster, String tableNameMaster) {
        for (int i = 0; i < this.generateCrud.master().details().length; ++i) {
            List<FieldForm> fieldForms = ProcessorUtils.getListFieldForm(this.generateCrud.master().details()[i].fields());
            this.loadImportsFieldsGetsSetsEnums(fieldForms, this.imports, this.fields, this.columnsDataTable, this.getSets, this.getSetEnums);
            String nameDetail = this.generateCrud.master().details()[i].name();
            String tableNameDetail = this.generateCrud.master().details()[i].tableName();
            List<String> details = Arrays.stream(this.generateCrud.master().details()[i].subDetails()).map(JArchGenerateCrud.SubDetail::name).collect(Collectors.toList());
            String codeLookup = fieldForms.stream().filter(FieldForm::isCodeLookup).map(FieldForm::getAtributo).findAny().orElse(null);
            String descriptionLookup = fieldForms.stream().filter(FieldForm::isDescriptionLookup).map(FieldForm::getAtributo).findAny().orElse(null);
            this.saveEntity(nameDetail, tableNameDetail, this.imports, this.fields, this.getSets, this.getSetEnums, nameMaster, details, codeLookup, descriptionLookup, fieldForms);
            this.saveEnums(fieldForms);
            this.saveEnderecos(fieldForms);
            this.generateScriptDataBase(nameDetail, tableNameDetail, fieldForms, tableNameMaster);
            SearchCodeGenerate.generate(this.element, nameDetail, this.generateCrud.nameSubPackage());
            JpqlBuilderCodeGenerate.generate(this.element, nameDetail, this.generateCrud.nameSubPackage());
            ServiceCodeGenerate.generate(this.element, nameDetail, this.generateCrud.nameSubPackage());
            RepositoryCodeGenerate.generate(this.element, nameDetail, this.generateCrud.nameSubPackage());
            JpaRepositoryCodeGenerate.generate(this.element, nameDetail, this.generateCrud.nameSubPackage());
            this.generateSubDetailFromMasterDetailSubDetail(i, nameDetail, tableNameDetail);
        }
    }

    private void generateSubDetailFromMasterDetailSubDetail(int i, String nameDetail, String tableNameDetail) {
        for (int j = 0; j < this.generateCrud.master().details()[i].subDetails().length; ++j) {
            List<FieldForm> fieldForms = ProcessorUtils.getListFieldForm(this.generateCrud.master().details()[i].subDetails()[j].fields());
            this.loadImportsFieldsGetsSetsEnums(fieldForms, this.imports, this.fields, this.columnsDataTable, this.getSets, this.getSetEnums);
            String nameSubDetail = this.generateCrud.master().details()[i].subDetails()[j].name();
            String tableNameSubDetail = this.generateCrud.master().details()[i].subDetails()[j].tableName();
            this.saveEntity(nameSubDetail, tableNameSubDetail, this.imports, this.fields, this.getSets, this.getSetEnums, nameDetail, new ArrayList<String>(), fieldForms.stream().filter(FieldForm::isCodeLookup).map(FieldForm::getAtributo).findAny().orElse(null), fieldForms.stream().filter(FieldForm::isDescriptionLookup).map(FieldForm::getAtributo).findAny().orElse(null), fieldForms);
            this.saveEnums(fieldForms);
            this.saveEnderecos(fieldForms);
            this.generateScriptDataBase(nameSubDetail, tableNameSubDetail, fieldForms, tableNameDetail);
            SearchCodeGenerate.generate(this.element, nameSubDetail, this.generateCrud.nameSubPackage());
            JpqlBuilderCodeGenerate.generate(this.element, nameSubDetail, this.generateCrud.nameSubPackage());
            ServiceCodeGenerate.generate(this.element, nameSubDetail, this.generateCrud.nameSubPackage());
            RepositoryCodeGenerate.generate(this.element, nameSubDetail, this.generateCrud.nameSubPackage());
            JpaRepositoryCodeGenerate.generate(this.element, nameSubDetail, this.generateCrud.nameSubPackage());
        }
    }

    private void saveEntity(String name, String tableName, Set<String> imports, List<String> fields, List<String> getSets, List<String> getSetEnums, String nameMaster, List<String> details, String codeLookup, String descriptionLookup, List<FieldForm> fieldForms) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        String nomeSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(name);
        String nameMasterSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(nameMaster);
        String nameMasterSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(nameMaster);
        String nomeSequenceGenerator = nomeSemCaracterEspecial + "IdSequence";
        this.addImports(imports, nameMaster, details);
        if (codeLookup != null && descriptionLookup != null && !codeLookup.isEmpty() && !descriptionLookup.isEmpty()) {
            imports.add("import br.com.jarch.core.annotation.JArchLookup;");
        }
        StringBuilder sbEntity = new StringBuilder();
        this.configurePackage(sbEntity);
        this.configureImport(imports, sbEntity);
        this.configureClass(tableName, codeLookup, descriptionLookup, nomeSemCaracterEspecial, nomeSemCaracterEspecialMinusculo, nomeSequenceGenerator, sbEntity, fieldForms);
        this.configureFieldId(tableName, nomeSequenceGenerator, sbEntity);
        this.configureRelationMaster(nameMaster, nameMasterSemCaracterEspecial, nameMasterSemCaracterEspecialMinusculo, sbEntity);
        this.configureFields(fields, details, nomeSemCaracterEspecialMinusculo, sbEntity);
        this.configureConstructors(fieldForms, nomeSemCaracterEspecial, sbEntity);
        this.configureGetSet(getSets, getSetEnums, nameMaster, details, nameMasterSemCaracterEspecial, nameMasterSemCaracterEspecialMinusculo, sbEntity);
        ProcessorUtils.addCode(sbEntity, "}");
        File fileEntity = new File(ProcessorUtils.getPathSource(this.element, this.nameSubPackage) + nomeSemCaracterEspecial + "Entity.java");
        this.saveFile(fileEntity, sbEntity.toString());
    }

    private void configureConstructors(List<FieldForm> fieldForms, String nomeSemCaracterEspecial, StringBuilder sbEntity) {
        Optional<FieldForm> fieldFormAddress = fieldForms.stream().filter(f -> f.getTipo().isAddress()).findAny();
        ProcessorUtils.addCode(sbEntity, "\tpublic " + nomeSemCaracterEspecial + "Entity() {");
        if (fieldFormAddress.isPresent()) {
            fieldForms.stream().filter(f -> f.getTipo().isAddress()).forEach(f -> ProcessorUtils.addCode(sbEntity, "\t\tthis." + f.getAtributo() + " = new " + f.getAtributoPrimeiroLetraMaiusculo() + "Embeddable();"));
        }
        ProcessorUtils.addCode(sbEntity, "\t}");
        ProcessorUtils.addLineBlank(sbEntity);
        if (!this.columnsDataTable.isEmpty()) {
            ProcessorUtils.addCode(sbEntity, "\tpublic " + nomeSemCaracterEspecial + "Entity(Long id, " + this.columnsDataTable.stream().collect(Collectors.joining(", ")) + ") {");
            ProcessorUtils.addCode(sbEntity, "\t\tthis.id = id;");
            this.columnsDataTable.forEach(c -> ProcessorUtils.addCode(sbEntity, "\t\tthis." + c.substring(c.indexOf(" ") + 1).concat(" = ").concat(c.substring(c.indexOf(" ") + 1)).concat(";")));
            ProcessorUtils.addCode(sbEntity, "\t}");
            ProcessorUtils.addLineBlank(sbEntity);
        }
    }

    private void configureGetSet(List<String> getSets, List<String> getSetEnums, String nameMaster, List<String> details, String nameMasterSemCaracterEspecial, String nameMasterSemCaracterEspecialMinusculo, StringBuilder sbEntity) {
        this.getSetId(sbEntity);
        this.getSetMaster(nameMaster, nameMasterSemCaracterEspecial, nameMasterSemCaracterEspecialMinusculo, sbEntity);
        getSets.forEach(getSet -> {
            ProcessorUtils.addCode(sbEntity, getSet);
            ProcessorUtils.addLineBlank(sbEntity);
        });
        details.forEach(detail -> {
            String nameWithoutCharEspecialCapitalize = ProcessorUtils.getNameWithoutCharEspecialCapitalize(detail);
            ProcessorUtils.addCode(sbEntity, "\tpublic Set<" + nameWithoutCharEspecialCapitalize + "Entity> getLista" + nameWithoutCharEspecialCapitalize + "() {\n\t\treturn lista" + nameWithoutCharEspecialCapitalize + "; \n\t}\n\n\tpublic void setLista" + nameWithoutCharEspecialCapitalize + "(Set<" + nameWithoutCharEspecialCapitalize + "Entity> lista" + nameWithoutCharEspecialCapitalize + ") { \n\t\tthis.lista" + nameWithoutCharEspecialCapitalize + " = lista" + nameWithoutCharEspecialCapitalize + "; \n\t}\n\n\tpublic void addLista" + nameWithoutCharEspecialCapitalize + "(" + nameWithoutCharEspecialCapitalize + "Entity " + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail) + ") { \n\t\tif (lista" + nameWithoutCharEspecialCapitalize + " == null) {\n\t\t\tlista" + nameWithoutCharEspecialCapitalize + " = new HashSet<>();\n\t\t}\n\n\t\tlista" + nameWithoutCharEspecialCapitalize + ".add(" + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail) + ");\n\t}");
            ProcessorUtils.addLineBlank(sbEntity);
        });
        getSetEnums.forEach(getSetEnum -> {
            ProcessorUtils.addCode(sbEntity, getSetEnum);
            ProcessorUtils.addLineBlank(sbEntity);
        });
    }

    private void getSetId(StringBuilder sbEntity) {
        ProcessorUtils.addCode(sbEntity, "\t@Override");
        ProcessorUtils.addCode(sbEntity, "\tpublic Long getId() {");
        ProcessorUtils.addCode(sbEntity, "\t\treturn id;");
        ProcessorUtils.addCode(sbEntity, "\t}");
        ProcessorUtils.addLineBlank(sbEntity);
        ProcessorUtils.addCode(sbEntity, "\t@Override");
        ProcessorUtils.addCode(sbEntity, "\tpublic void setId(Long id) {");
        ProcessorUtils.addCode(sbEntity, "\t\tthis.id = id;");
        ProcessorUtils.addCode(sbEntity, "\t}");
        ProcessorUtils.addLineBlank(sbEntity);
    }

    private void configureFields(List<String> fields, List<String> details, String nomeSemCaracterEspecialMinusculo, StringBuilder sbEntity) {
        fields.forEach(f -> {
            ProcessorUtils.addCode(sbEntity, f);
            ProcessorUtils.addLineBlank(sbEntity);
        });
        details.forEach(d -> {
            ProcessorUtils.addCode(sbEntity, "\t@OneToMany(cascade = CascadeType.ALL, mappedBy = \"" + nomeSemCaracterEspecialMinusculo + "\", orphanRemoval = true)\n\t@JArchValidRequired(\"label." + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(d) + "\") \n\t@JArchNoCloneId\n\t@Filter(name = ConstantCore.TENANT)\n" + (this.exclusionLogic ? "\t@JArchExclusionLogic\n" : "") + "\tprivate Set<" + ProcessorUtils.getNameWithoutCharEspecialCapitalize(d) + "Entity> lista" + ProcessorUtils.getNameWithoutCharEspecialCapitalize(d) + ";");
            ProcessorUtils.addLineBlank(sbEntity);
        });
    }

    private void configureFieldId(String tableName, String nomeSequenceGenerator, StringBuilder sbEntity) {
        ProcessorUtils.addCode(sbEntity, "\t@Id");
        ProcessorUtils.addCode(sbEntity, "\t@GeneratedValue(strategy = GenerationType.AUTO, generator = \"" + nomeSequenceGenerator + "\")");
        ProcessorUtils.addCode(sbEntity, "\t@Column(name = \"" + ProcessorUtils.nameIdColumn(tableName) + "\")");
        ProcessorUtils.addCode(sbEntity, "\tprivate Long id;");
        ProcessorUtils.addLineBlank(sbEntity);
    }

    private void configureClass(String tableName, String codeLookup, String descriptionLookup, String nomeSemCaracterEspecial, String nomeSemCaracterEspecialMinusculo, String nomeSequenceGenerator, StringBuilder sbEntity, List<FieldForm> fieldForms) {
        if (codeLookup != null && descriptionLookup != null && !codeLookup.isEmpty() && !descriptionLookup.isEmpty()) {
            ProcessorUtils.addCode(sbEntity, "@JArchLookup(codeAttribute = \"" + codeLookup + "\", descriptionAttribute = \"" + descriptionLookup + "\")");
        }
        if (this.secret) {
            ProcessorUtils.addCode(sbEntity, "@JArchConfidential");
        }
        if (this.exclusionLogic) {
            ProcessorUtils.addCode(sbEntity, "@JArchExclusionLogic");
        }
        ProcessorUtils.addCode(sbEntity, "@Audited");
        ProcessorUtils.addCode(sbEntity, "@Table(name = \"" + tableName + "\", \n\t\tindexes = {\n\t\t\t\t" + fieldForms.stream().filter(f -> !f.getSearch().isEmpty()).filter(f -> !f.getTipo().isAddress()).map(f -> "@Index(columnList = \"" + f.getCampoTabela() + "\", name = \"" + "dx_".concat(tableName.substring(3).replace("_", "").concat(f.getCampoTabela().substring(0, 6).replace("_", ""))) + "\")").collect(Collectors.joining(",\n\t\t\t\t")) + "\n\t\t})");
        ProcessorUtils.addCode(sbEntity, "@Entity(name = \"" + nomeSemCaracterEspecialMinusculo + "\")");
        ProcessorUtils.addCode(sbEntity, "@SequenceGenerator(name = \"" + nomeSequenceGenerator + "\", sequenceName = \"" + ProcessorUtils.nameSequence(tableName) + "\", allocationSize = 1)");
        ProcessorUtils.addCode(sbEntity, "public class " + nomeSemCaracterEspecial + "Entity extends CrudMultiTenantEntity {");
        ProcessorUtils.addLineBlank(sbEntity);
    }

    private void configureImport(Set<String> imports, StringBuilder sbEntity) {
        imports.forEach(imp -> ProcessorUtils.addCode(sbEntity, imp));
        ProcessorUtils.addLineBlank(sbEntity);
    }

    private void configurePackage(StringBuilder sbEntity) {
        ProcessorUtils.addCode(sbEntity, "package " + this.namePackage + ";");
        ProcessorUtils.addLineBlank(sbEntity);
    }

    private void getSetMaster(String nameMaster, String nameMasterSemCaracterEspecial, String nameMasterSemCaracterEspecialMinusculo, StringBuilder sbEntity) {
        if (nameMaster != null && !nameMaster.isEmpty()) {
            ProcessorUtils.addCode(sbEntity, "\tpublic " + nameMasterSemCaracterEspecial + "Entity get" + nameMasterSemCaracterEspecial + "() {");
            ProcessorUtils.addCode(sbEntity, "\t\treturn " + nameMasterSemCaracterEspecialMinusculo + ";");
            ProcessorUtils.addCode(sbEntity, "\t}");
            ProcessorUtils.addLineBlank(sbEntity);
            ProcessorUtils.addCode(sbEntity, "\tpublic void set" + nameMasterSemCaracterEspecial + "(" + nameMasterSemCaracterEspecial + "Entity " + nameMasterSemCaracterEspecialMinusculo + ") {");
            ProcessorUtils.addCode(sbEntity, "\t\tthis." + nameMasterSemCaracterEspecialMinusculo + " = " + nameMasterSemCaracterEspecialMinusculo + ";");
            ProcessorUtils.addCode(sbEntity, "\t}");
            ProcessorUtils.addLineBlank(sbEntity);
        }
    }

    private void configureRelationMaster(String nameMaster, String nameMasterSemCaracterEspecial, String nameMasterSemCaracterEspecialMinusculo, StringBuilder sbEntity) {
        if (nameMaster != null && !nameMaster.isEmpty()) {
            ProcessorUtils.addCode(sbEntity, "\t@ManyToOne");
            ProcessorUtils.addCode(sbEntity, "\t@JoinColumn(name=\"id_" + nameMasterSemCaracterEspecialMinusculo + "\", nullable = false)");
            ProcessorUtils.addCode(sbEntity, "\t@Filter(name = ConstantCore.TENANT)");
            ProcessorUtils.addCode(sbEntity, "\tprivate " + nameMasterSemCaracterEspecial + "Entity " + nameMasterSemCaracterEspecialMinusculo + ";");
            ProcessorUtils.addLineBlank(sbEntity);
        }
    }

    private void addImports(Set<String> imports, String nameMaster, List<String> details) {
        imports.add("import javax.persistence.Column;");
        imports.add("import javax.persistence.Entity;");
        imports.add("import javax.persistence.GeneratedValue;");
        imports.add("import javax.persistence.GenerationType;");
        imports.add("import javax.persistence.Id;");
        imports.add("import javax.persistence.Index;");
        imports.add("import javax.persistence.SequenceGenerator;");
        imports.add("import javax.persistence.Table;");
        imports.add("import org.hibernate.envers.Audited;");
        imports.add("import br.com.jarch.core.annotation.JArchValidRequired;");
        imports.add("import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;");
        if (!details.isEmpty()) {
            imports.add("import javax.persistence.OneToMany;");
            imports.add("import br.com.jarch.core.annotation.JArchNoCloneId;");
            imports.add("import br.com.jarch.core.ConstantCore;");
            imports.add("import org.hibernate.annotations.Filter;");
            imports.add("import javax.persistence.CascadeType;");
            imports.add("import java.util.Set;");
            imports.add("import java.util.HashSet;");
        }
        if (!StringUtils.isNullOrEmpty(nameMaster)) {
            imports.add("import javax.persistence.JoinColumn;");
            imports.add("import javax.persistence.ManyToOne;");
            imports.add("import br.com.jarch.core.ConstantCore;");
            imports.add("import org.hibernate.annotations.Filter;");
        }
        if (this.exclusionLogic) {
            imports.add("import br.com.jarch.core.ConstantCore;");
            imports.add("import br.com.jarch.core.annotation.JArchExclusionLogic;");
        }
        if (this.secret) {
            imports.add("import br.com.jarch.core.annotation.JArchConfidential;");
        }
    }

    private void loadImportsFieldsGetsSetsEnums(List<FieldForm> fieldForms, Set<String> imports, List<String> fields, List<String> columnsDataTable, List<String> getSets, List<String> getSetEnums) {
        imports.clear();
        fields.clear();
        columnsDataTable.clear();
        getSets.clear();
        getSetEnums.clear();
        for (FieldForm campoForm : fieldForms) {
            Object tipo;
            String atributoPrimeiroMaisculo = campoForm.getAtributoPrimeiroLetraMaiusculo();
            Object definicaoAtributo = "";
            if (!campoForm.getTipo().equals((Object)FieldType.ENTITY) && !campoForm.getTipo().isAddress()) {
                definicaoAtributo = (String)definicaoAtributo + "\t@Column(name = \"" + campoForm.getCampoTabela() + "\"";
                if (campoForm.isObrigatorio()) {
                    definicaoAtributo = (String)definicaoAtributo + ", nullable = false";
                }
                if (campoForm.getTipo().getSizeColumnDatabase() > 0) {
                    definicaoAtributo = (String)definicaoAtributo + ", length = " + campoForm.getTipo().getSizeColumnDatabase();
                }
                if (campoForm.getTipo().isInteger()) {
                    definicaoAtributo = (String)definicaoAtributo + ", precision = 6";
                } else if (campoForm.getTipo().isLong()) {
                    definicaoAtributo = (String)definicaoAtributo + ", precision = 8";
                } else if (campoForm.getTipo().isDecimal()) {
                    definicaoAtributo = (String)definicaoAtributo + ", scale = 2, precision = 12";
                }
                definicaoAtributo = (String)definicaoAtributo + ")\n";
            }
            if (campoForm.getTipo().isEnum()) {
                imports.add("import java.util.Collection;");
                tipo = campoForm.getAtributo().substring(0, 1).toUpperCase() + campoForm.getAtributo().substring(1) + "Type";
            } else if (campoForm.getTipo().isAddress()) {
                imports.add("import javax.persistence.Embedded;");
                tipo = campoForm.getAtributo().substring(0, 1).toUpperCase() + campoForm.getAtributo().substring(1) + "Embeddable";
                definicaoAtributo = (String)definicaoAtributo + "\t@Embedded\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.BINARY)) {
                tipo = "byte[]";
                definicaoAtributo = (String)definicaoAtributo + "\t@Lob\n";
                definicaoAtributo = (String)definicaoAtributo + "\t@Basic(fetch = FetchType.LAZY)\n";
                imports.add("import javax.persistence.Lob;");
                imports.add("import javax.persistence.Basic;");
                imports.add("import javax.persistence.FetchType;");
            } else if (campoForm.getTipo().equals((Object)FieldType.MONTH_YEAR)) {
                tipo = "YearMonth";
                imports.add("import br.com.jarch.core.jpa.converter.YearMonthJpaConverter;");
                imports.add("import javax.persistence.Convert;");
                imports.add("import java.time.YearMonth;");
                definicaoAtributo = (String)definicaoAtributo + "\t@Convert(converter = YearMonthJpaConverter.class)\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.HOUR)) {
                tipo = "LocalTime";
                imports.add("import br.com.jarch.core.jpa.converter.LocalTimeJpaConverter;");
                imports.add("import javax.persistence.Convert;");
                imports.add("import java.time.LocalTime;");
                definicaoAtributo = (String)definicaoAtributo + "\t@Convert(converter = LocalTimeJpaConverter.class)\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.DATE)) {
                tipo = "LocalDate";
                imports.add("import br.com.jarch.core.jpa.converter.LocalDateJpaConverter;");
                imports.add("import javax.persistence.Convert;");
                imports.add("import java.time.LocalDate;");
                definicaoAtributo = (String)definicaoAtributo + "\t@Convert(converter = LocalDateJpaConverter.class)\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.DATE_TIME)) {
                tipo = "LocalDateTime";
                imports.add("import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;");
                imports.add("import javax.persistence.Convert;");
                imports.add("import java.time.LocalDateTime;");
                definicaoAtributo = (String)definicaoAtributo + "\t@Convert(converter = LocalDateTimeJpaConverter.class)\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.MONEY) || campoForm.getTipo().equals((Object)FieldType.RATE) || campoForm.getTipo().equals((Object)FieldType.PERCENTAGE)) {
                tipo = "BigDecimal";
                imports.add("import java.math.BigDecimal;");
            } else if (campoForm.getTipo().equals((Object)FieldType.QUANTITY)) {
                tipo = "Integer";
            } else if (campoForm.getTipo().equals((Object)FieldType.SEQUENCE) || campoForm.getTipo().equals((Object)FieldType.NUMBER)) {
                tipo = "Long";
            } else if (campoForm.getTipo().equals((Object)FieldType.CNPJ)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidCnpj;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidCnpj\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.CNPJ_BASE)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidCnpjBase;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidCnpjBase\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.CPF)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidCpf;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidCpf\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.CEP)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidCep;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidCep\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.CPFCNPJ)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidCpfCnpj;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidCpfCnpj\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.TELEPHONE) || campoForm.getTipo().equals((Object)FieldType.CELLPHONE)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidPhone;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidPhone\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.BOOLEAN)) {
                imports.add("import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;");
                imports.add("import javax.persistence.Convert;");
                tipo = "Boolean";
                definicaoAtributo = (String)definicaoAtributo + "\t@Convert(converter = BooleanSNJpaConverter.class)\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.EMAIL)) {
                imports.add("import br.com.jarch.core.annotation.JArchValidEmail;");
                tipo = "String";
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidEmail\n";
            } else if (campoForm.getTipo().equals((Object)FieldType.PASSWORD)) {
                tipo = "String";
            } else if (campoForm.getTipo().equals((Object)FieldType.ENTITY)) {
                imports.add("import javax.persistence.OneToOne;");
                tipo = campoForm.getAtributo().substring(0, 1).toUpperCase() + campoForm.getAtributo().substring(1) + "Entity";
            } else {
                tipo = "String";
            }
            if (campoForm.isObrigatorio()) {
                imports.add("import br.com.jarch.core.annotation.JArchValidRequired;");
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidRequired(\"" + campoForm.getBundleCodigoJava() + "\")\n";
            }
            if (campoForm.getTipo().getSizeColumnDatabase() > 0 && ((String)tipo).equals("String") && !campoForm.getTipo().isCpfCnpj()) {
                imports.add("import javax.validation.constraints.Size;");
                definicaoAtributo = (String)definicaoAtributo + "\t@Size(max = " + campoForm.getTipo().getSizeColumnDatabase() + ", message = \"{message.maxSizeExceeded}\")\n";
            }
            if (campoForm.getTipo().equals((Object)FieldType.ENTITY)) {
                imports.add("import javax.persistence.JoinColumn;");
                imports.add("import br.com.jarch.core.ConstantCore;");
                imports.add("import org.hibernate.annotations.Filter;");
                if (ProcessorUtils.isExistsEntity(this.element, campoForm.getDescricao(), campoForm.getAtributo().toLowerCase())) {
                    String packageEntityField = ProcessorUtils.getPackage(this.element, campoForm.getAtributo().toLowerCase());
                    String nameEntityField = ProcessorUtils.getNomeEntity(campoForm.getDescricao());
                    imports.add("import " + packageEntityField.concat(".").concat(nameEntityField) + ";");
                }
                definicaoAtributo = (String)definicaoAtributo + "\t@OneToOne\n";
                definicaoAtributo = (String)definicaoAtributo + "\t@JoinColumn(name = \"" + campoForm.getCampoTabela() + "\"" + (campoForm.isObrigatorio() ? ", nullable = false" : "") + ")\n";
                definicaoAtributo = (String)definicaoAtributo + "\t@Filter(name = ConstantCore.TENANT)\n";
                definicaoAtributo = (String)definicaoAtributo + (this.exclusionLogic ? "\t@JArchExclusionLogic\n" : "");
            }
            if (campoForm.isExclusive()) {
                imports.add("import br.com.jarch.core.annotation.JArchValidExclusive;");
                definicaoAtributo = (String)definicaoAtributo + "\t@JArchValidExclusive\n";
            }
            definicaoAtributo = (String)definicaoAtributo + "\tprivate " + (String)tipo + " " + campoForm.getAtributo() + ";";
            fields.add((String)definicaoAtributo);
            if (!campoForm.getXhtml().isEmpty()) {
                columnsDataTable.add((String)tipo + " " + campoForm.getAtributo());
            }
            String getIs = "get";
            String getSet = "\tpublic " + (String)tipo + " " + getIs + atributoPrimeiroMaisculo + "() {\n\t\treturn " + campoForm.getAtributo() + ";\n\t}\n\n\tpublic void set" + atributoPrimeiroMaisculo + "(" + (String)tipo + " " + campoForm.getAtributo() + ") {\n\t\tthis." + campoForm.getAtributo() + " = " + campoForm.getAtributo() + ";\n\t}";
            getSets.add(getSet);
            this.addGetSetEnum(getSetEnums, campoForm);
        }
    }

    private void addGetSetEnum(List<String> getSetEnums, FieldForm campoForm) {
        if (!campoForm.getTipo().isEnum()) {
            return;
        }
        String nomeEnum = campoForm.getAtributo().substring(0, 1).toUpperCase() + campoForm.getAtributo().substring(1) + "Type";
        getSetEnums.add("\tpublic Collection<" + nomeEnum + "> get" + campoForm.getAtributoPrimeiroLetraMaiusculo() + "s() {\n\t   return " + nomeEnum + ".getCollection();\n\t}\n\n\tpublic String get" + campoForm.getAtributoPrimeiroLetraMaiusculo() + "Description() {\n\t   return " + campoForm.getAtributo() + " == null ? \"\" : " + campoForm.getAtributo() + ".getDescription();\n\t}");
    }

    private void saveEnums(List<FieldForm> fieldForms) {
        fieldForms.stream().filter(f -> f.getTipo().isEnum()).filter(f -> !FieldType.ENUMERATED.equals((Object)f.getTipo())).forEach(fieldForm -> {
            TypeCodeGenerate.generate(this.element, fieldForm.getAtributo(), this.nameSubPackage);
            JpaConverterCodeGenerate.generate(this.element, fieldForm.getAtributo(), this.nameSubPackage);
        });
    }

    private void saveEnderecos(List<FieldForm> fieldForms) {
        fieldForms.stream().filter(f -> f.getTipo().isAddress()).forEach(fieldForm -> EmbeddableAddressCodeGenerate.generate(this.element, fieldForm.getAtributo(), this.nameSubPackage, fieldForm.isObrigatorio()));
    }

    private void configEnviroment() {
        this.namePackage = ProcessorUtils.getPackage(this.element, this.nameSubPackage);
        File folder = new File(ProcessorUtils.getPathSource(this.element, this.nameSubPackage));
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private void generateScriptDataBase(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        this.folderScript = new File(ProcessorUtils.getPathSource(this.element, this.nameSubPackage) + File.separator + "sql");
        if (!this.folderScript.exists()) {
            this.folderScript.mkdir();
        }
        this.scriptOracle(name, tableName, fieldForms, tableNameOwner);
        this.scriptPostgreSql(name, tableName, fieldForms, tableNameOwner);
        this.scriptMySql(name, tableName, fieldForms, tableNameOwner);
        this.scriptSqlServer(name, tableName, fieldForms, tableNameOwner);
        this.scriptDb2(name, tableName, fieldForms, tableNameOwner);
        this.scriptSybase(name, tableName, fieldForms, tableNameOwner);
    }

    private void scriptOracle(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "Oracle.sql");
        StringBuilder sbScript = new StringBuilder();
        this.addTableOracleSybase(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeysOracle(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addSequenceDb2OracleSybase(sbScript, tableName);
        this.addTableAudityOraclePostgreSql(sbScript, tableName, fieldForms, tableNameOwner);
        this.saveFile(fileScript, sbScript.toString());
    }

    private void scriptPostgreSql(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        StringBuilder sbScript = new StringBuilder();
        this.addTablePostgreSql(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeyPostgreSqlMySqlSqlServer(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addSequencePostgreSql(sbScript, tableName);
        this.addTableAudityOraclePostgreSql(sbScript, tableName, fieldForms, tableNameOwner);
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "PostgreSQL.sql");
        String sbScriptFinal = sbScript.toString().replace("NUMBER", "NUMERIC").replace("VARCHAR2", "VARCHAR");
        this.saveFile(fileScript, sbScriptFinal);
    }

    private void addTableAudityOraclePostgreSql(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        this.addComentTableAuditScript(sbScript, tableName);
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA_AUDITORIA>." + tableName.toUpperCase() + "_AUD (");
        ProcessorUtils.addCode(sbScript, "\tID_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tTP_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnsNullable(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        ProcessorUtils.addCode(sbScript, ");");
    }

    private void addColumnDateExclusion(StringBuilder sbScript) {
        ProcessorUtils.addCode(sbScript, "\tDH_EXCLUSAO TIMESTAMP,");
    }

    private void addSequencePostgreSql(StringBuilder sbScript, String tableName) {
        ProcessorUtils.addCode(sbScript, "-- CREATE SEQUENCE FROM <SCHEMA>." + tableName.toUpperCase() + " TO ID");
        ProcessorUtils.addCode(sbScript, "CREATE SEQUENCE <SCHEMA>." + ProcessorUtils.nameSequence(tableName).toUpperCase() + " START WITH 1 MINVALUE 1 MAXVALUE 999999999999;");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void addForeignKeyPostgreSqlMySqlSqlServer(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        List fieldFormEntitys = fieldForms.stream().filter(f -> f.getTipo().isEntity()).collect(Collectors.toList());
        if (!fieldFormEntitys.isEmpty() || this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "-- CREATE FOREIGN KEY'S FROM <SCHEMA>." + tableName.toUpperCase());
            if (this.isHasTableOwner(tableNameOwner)) {
                String nameColumn = ProcessorUtils.nameIdColumn(tableNameOwner);
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                ProcessorUtils.addCode(sbScript, "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ")");
            }
            String foreignKeys = fieldFormEntitys.stream().map(f -> {
                String nameColumn = f.getCampoTabela().toUpperCase();
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                return "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ")";
            }).collect(Collectors.joining(";\n"));
            ProcessorUtils.addCode(sbScript, foreignKeys);
            ProcessorUtils.addLineBlank(sbScript);
        }
    }

    private void addTablePostgreSql(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        ProcessorUtils.addCode(sbScript, "-- >>>>>>>>>>> SCRIPT DATABASE <<<<<<<<<<<<<");
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE <SCHEMA>." + tableName.toUpperCase());
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA>." + tableName.toUpperCase() + " (");
        String namePrimaryKey = "PK_".concat(ProcessorUtils.nameIdColumn(tableName).toUpperCase().substring(3));
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMERIC CONSTRAINT " + namePrimaryKey + " PRIMARY KEY NOT NULL,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER NOT NULL,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnFromFieldForms(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER);");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void scriptMySql(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "MySql.sql");
        StringBuilder sbScript = new StringBuilder();
        this.addTableMySql(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeyPostgreSqlMySqlSqlServer(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addTableAuditMySql(sbScript, tableName, fieldForms, tableNameOwner);
        this.saveFile(fileScript, sbScript.toString().replace("NUMBER", "BIGINT").replace("VARCHAR2", "VARCHAR"));
    }

    private void addTableAuditMySql(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        this.addComentTableAuditScript(sbScript, tableName);
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA_AUDITORIA>." + tableName.toUpperCase() + "_AUD (");
        ProcessorUtils.addCode(sbScript, "\tID_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tTP_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnsNullable(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        String namePrimaryKey = "PK_".concat(ProcessorUtils.nameIdColumn(tableName).toUpperCase().substring(3));
        ProcessorUtils.addCode(sbScript, "\tCONSTRAINT " + namePrimaryKey + "AUD PRIMARY KEY (ID_AUDITORIA));");
    }

    private void addComentTableAuditScript(StringBuilder sbScript, String tableName) {
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE AUDIT FROM <SCHEMA>." + tableName.toUpperCase());
    }

    private void addTableMySql(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        ProcessorUtils.addCode(sbScript, "-- >>>>>>>>>>> SCRIPT DATABASE <<<<<<<<<<<<<");
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE <SCHEMA>." + tableName.toUpperCase());
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA>." + tableName.toUpperCase() + " (");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER AUTO_INCREMENT NOT NULL,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER NOT NULL,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnFromFieldForms(fieldForms).concat(","));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        String namePrimaryKey = "PK_".concat(ProcessorUtils.nameIdColumn(tableName).toUpperCase().substring(3));
        ProcessorUtils.addCode(sbScript, "\tCONSTRAINT " + namePrimaryKey + " PRIMARY KEY (" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + "));");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void scriptSqlServer(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "SqlServer.sql");
        StringBuilder sbScript = new StringBuilder();
        this.addTableSqlServer(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeyPostgreSqlMySqlSqlServer(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addTableAuditSqlServer(sbScript, tableName, fieldForms, tableNameOwner);
        this.saveFile(fileScript, sbScript.toString().replace("NUMBER", "BIGINT").replace("VARCHAR2", "VARCHAR"));
    }

    private void addTableAuditSqlServer(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        this.addComentTableAuditScript(sbScript, tableName);
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA_AUDITORIA>." + tableName.toUpperCase() + "_AUD (");
        ProcessorUtils.addCode(sbScript, "\tID_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tTP_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnsNullable(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        String namePrimaryKey = "PK_".concat(ProcessorUtils.nameIdColumn(tableName).toUpperCase().substring(3));
        ProcessorUtils.addCode(sbScript, "\tCONSTRAINT " + namePrimaryKey + "AUD PRIMARY KEY (ID_AUDITORIA));");
    }

    private void addTableSqlServer(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        ProcessorUtils.addCode(sbScript, "-- >>>>>>>>>>> SCRIPT DATABASE <<<<<<<<<<<<<");
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE <SCHEMA>." + tableName.toUpperCase());
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA>." + tableName.toUpperCase() + " (");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER IDENTITY(1,1) NOT NULL,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER NOT NULL,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnFromFieldForms(fieldForms).concat(","));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        String namePrimaryKey = "PK_".concat(ProcessorUtils.nameIdColumn(tableName).toUpperCase().substring(3));
        ProcessorUtils.addCode(sbScript, "\tCONSTRAINT " + namePrimaryKey + " PRIMARY KEY (" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + "));");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void scriptDb2(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "Db2.sql");
        StringBuilder sbScript = new StringBuilder();
        this.addTableDb2(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeys(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addSequenceDb2OracleSybase(sbScript, tableName);
        this.addTableAuditSybase(sbScript, tableName, fieldForms, tableNameOwner);
        this.saveFile(fileScript, sbScript.toString());
    }

    private void addTableDb2(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        ProcessorUtils.addCode(sbScript, "-- >>>>>>>>>>> SCRIPT DATABASE <<<<<<<<<<<<<");
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE <SCHEMA>." + tableName.toUpperCase());
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA>." + tableName.toUpperCase() + " (");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER NOT NULL CONSTRAINT " + ProcessorUtils.namePrimaryKey(tableName).toUpperCase() + " PRIMARY KEY,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER NOT NULL,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnFromFieldForms(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        ProcessorUtils.addCode(sbScript, ");");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void scriptSybase(String name, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        String nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File fileScript = new File(this.folderScript.getAbsolutePath() + File.separator + nomeSemCaracterEspecial + "Sybase.sql");
        StringBuilder sbScript = new StringBuilder();
        this.addTableOracleSybase(sbScript, tableName, fieldForms, tableNameOwner);
        this.addForeignKeys(sbScript, tableName, fieldForms, tableNameOwner);
        this.addIndexes(sbScript, tableName, fieldForms);
        this.addSequenceDb2OracleSybase(sbScript, tableName);
        this.addTableAuditSybase(sbScript, tableName, fieldForms, tableNameOwner);
        this.saveFile(fileScript, sbScript.toString());
    }

    private void addTableAuditSybase(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        this.addComentTableAuditScript(sbScript, tableName);
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA_AUDITORIA>." + tableName.toUpperCase() + "_AUD (");
        ProcessorUtils.addCode(sbScript, "\tID_AUDITORIA NUMBER NOT NULL CONSTRAINT " + ProcessorUtils.namePrimaryKey(tableName).toUpperCase() + " PRIMARY KEY,");
        ProcessorUtils.addCode(sbScript, "\tTP_AUDITORIA NUMBER NOT NULL,");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnsNullable(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        ProcessorUtils.addCode(sbScript, ");");
    }

    private void addForeignKeys(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        List fieldFormEntitys = fieldForms.stream().filter(f -> f.getTipo().isEntity()).collect(Collectors.toList());
        if (!fieldFormEntitys.isEmpty() || this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "-- CREATE FOREIGN KEYS FROM <SCHEMA>." + tableName.toUpperCase());
            if (this.isHasTableOwner(tableNameOwner)) {
                String nameColumn = ProcessorUtils.nameIdColumn(tableNameOwner);
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                ProcessorUtils.addCode(sbScript, "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ")");
            }
            for (FieldForm fieldForm : fieldFormEntitys) {
                String nameColumn = fieldForm.getCampoTabela().toUpperCase();
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                ProcessorUtils.addCode(sbScript, "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ");");
            }
            ProcessorUtils.addLineBlank(sbScript);
        }
    }

    private void addTableOracleSybase(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        ProcessorUtils.addCode(sbScript, "-- >>>>>>>>>>> SCRIPT DATABASE <<<<<<<<<<<<<");
        ProcessorUtils.addCode(sbScript, "-- CREATE TABLE <SCHEMA>." + tableName.toUpperCase());
        ProcessorUtils.addCode(sbScript, "CREATE TABLE <SCHEMA>." + tableName.toUpperCase() + " (");
        ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableName).toUpperCase() + " NUMBER(19) NOT NULL CONSTRAINT " + ProcessorUtils.namePrimaryKey(tableName).toUpperCase() + " PRIMARY KEY,");
        if (this.isHasTableOwner(tableNameOwner)) {
            ProcessorUtils.addCode(sbScript, "\t" + ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase() + " NUMBER(19) NOT NULL,");
        }
        this.addColumnDateExclusion(sbScript);
        ProcessorUtils.addCode(sbScript, "\tSQ_VERSAOREGISTRO NUMBER,");
        ProcessorUtils.addCode(sbScript, "\tID_MULTITENANT NUMBER(5) NOT NULL,");
        ProcessorUtils.addCode(sbScript, this.getScriptColumnFromFieldForms(fieldForms));
        ProcessorUtils.addCode(sbScript, "\tDH_ALTERACAO TIMESTAMP,");
        ProcessorUtils.addCode(sbScript, "\tID_USUARIOALTERACAO NUMBER");
        ProcessorUtils.addCode(sbScript, ");");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private boolean isHasTableOwner(String tableNameOwner) {
        return tableNameOwner != null && !tableNameOwner.isBlank();
    }

    private void addSequenceDb2OracleSybase(StringBuilder sbScript, String tableName) {
        ProcessorUtils.addCode(sbScript, "-- CREATE SEQUENCE FROM <SCHEMA>." + tableName.toUpperCase() + " TO ID");
        ProcessorUtils.addCode(sbScript, "CREATE SEQUENCE <SCHEMA>." + ProcessorUtils.nameSequence(tableName).toUpperCase() + " NOCACHE START WITH 1 MINVALUE 1 MAXVALUE 999999999999;");
        ProcessorUtils.addLineBlank(sbScript);
    }

    private void addIndexes(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms) {
        List fieldFormIndexes = fieldForms.stream().filter(f -> !f.getSearch().isEmpty()).collect(Collectors.toList());
        if (!fieldFormIndexes.isEmpty()) {
            ProcessorUtils.addCode(sbScript, "-- CREATE INDEXES FROM <SCHEMA>." + tableName.toUpperCase());
            for (FieldForm fieldForm : fieldFormIndexes) {
                String nameIndex = "DX_".concat(tableName.substring(3).concat(fieldForm.getCampoTabela().substring(0, 6)).replace("_", "")).toUpperCase();
                ProcessorUtils.addCode(sbScript, "CREATE INDEX " + nameIndex + " ON <SCHEMA>." + tableName.toUpperCase() + "(" + fieldForm.getCampoTabela().toUpperCase() + ");");
            }
            ProcessorUtils.addLineBlank(sbScript);
        }
    }

    private void addForeignKeysOracle(StringBuilder sbScript, String tableName, List<FieldForm> fieldForms, String tableNameOwner) {
        boolean hasTableOnwer = this.isHasTableOwner(tableNameOwner);
        List fieldFormEntitys = fieldForms.stream().filter(f -> f.getTipo().isEntity()).collect(Collectors.toList());
        if (!fieldFormEntitys.isEmpty() || hasTableOnwer) {
            ProcessorUtils.addCode(sbScript, "-- CREATE FOREIGN KEYS FROM <SCHEMA>." + tableName.toUpperCase());
            if (hasTableOnwer) {
                String nameColumn = ProcessorUtils.nameIdColumn(tableNameOwner).toUpperCase();
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                ProcessorUtils.addCode(sbScript, "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ");");
            }
            for (FieldForm fieldForm : fieldFormEntitys) {
                String nameColumn = fieldForm.getCampoTabela().toUpperCase();
                String nameForeignKey = "FK_".concat(tableName.substring(3).concat(nameColumn.substring(0, 6)).replace("_", "")).toUpperCase();
                String nameTableReference = nameColumn.replace("ID_", "TB_");
                ProcessorUtils.addCode(sbScript, "ALTER TABLE <SCHEMA>." + tableName.toUpperCase() + " ADD CONSTRAINT " + nameForeignKey + " FOREIGN KEY (" + nameColumn + ") REFERENCES <SCHEMA>." + nameTableReference + "(" + nameColumn + ");");
            }
            ProcessorUtils.addLineBlank(sbScript);
        }
    }

    private String getScriptColumnFromFieldForms(List<FieldForm> fieldForms) {
        return fieldForms.stream().map(f -> "\t" + f.getTipo().getColumnSqlType(f.getCampoTabela(), f.isObrigatorio())).collect(Collectors.joining(",\n")).concat(",");
    }

    private String getScriptColumnsNullable(List<FieldForm> fieldForms) {
        return fieldForms.stream().map(f -> "\t" + f.getTipo().getColumnSqlType(f.getCampoTabela(), false)).collect(Collectors.joining(",\n")).concat(",");
    }

    private void saveFile(File file, String content) {
        try {
            if (ProcessorUtils.isFileExistsClientOrWebOrWs(file)) {
                return;
            }
            FileUtils.save(file, content);
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(file.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }
}

