/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.ICodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import javax.lang.model.element.Element;

public abstract class BaseCodeGenerate
implements ICodeGenerate {
    private final Element element;
    private final String useCase;
    private final String nameSubPackage;

    BaseCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        this.element = element;
        this.useCase = generateCrud.master().name();
        this.nameSubPackage = generateCrud.nameSubPackage();
    }

    BaseCodeGenerate(Element element, String useCase, String nameSubPackage) {
        this.element = element;
        this.useCase = useCase;
        this.nameSubPackage = nameSubPackage;
    }

    @Override
    public void generate() {
        if (ProcessorUtils.isFileExistsClientOrWebOrWs(this.getFile())) {
            return;
        }
        try {
            if (!this.getFile().getParentFile().exists()) {
                this.getFile().getParentFile().mkdir();
            }
            FileUtils.save(this.getFile(), this.getContent());
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.getFile().getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public String getVarName() {
        return this.getType().getVarName(this.useCase);
    }

    @Override
    public String getNamePackage() {
        String namePackage = this.getModule().getNamePackage(this.element, this.nameSubPackage);
        if (this.isRenameWsToWeb()) {
            namePackage = namePackage.replace(".ws.", ".web.");
        }
        return namePackage;
    }

    @Override
    public String getName() {
        return this.getType().getName(this.useCase);
    }

    @Override
    public String getFullName() {
        return this.getType().getFullName(this.getNamePackage(), this.useCase);
    }

    @Override
    public String getNameEntity() {
        return CodeType.ENTITY.getName(this.useCase);
    }

    @Override
    public String getFullNameEntity() {
        return CodeType.ENTITY.getFullName(ModuleType.CLIENT.getNamePackage(this.element, this.nameSubPackage), this.useCase);
    }

    @Override
    public String getNameService() {
        return CodeType.SERVICE.getName(this.useCase);
    }

    @Override
    public String getFullNameService() {
        return CodeType.SERVICE.getFullName(ModuleType.CLIENT.getNamePackage(this.element, this.nameSubPackage), this.useCase);
    }

    @Override
    public String getNameSearch() {
        return CodeType.SEARCH.getName(this.useCase);
    }

    @Override
    public String getFullNameSearch() {
        return CodeType.SEARCH.getFullName(ModuleType.CLIENT.getNamePackage(this.element, this.nameSubPackage), this.useCase);
    }

    @Override
    public String getNameRepository() {
        return CodeType.REPOSITORY.getName(this.useCase);
    }

    @Override
    public String getFullNameRepository() {
        return CodeType.REPOSITORY.getFullName(ModuleType.CLIENT.getNamePackage(this.element, this.nameSubPackage), this.useCase);
    }

    @Override
    public String getNameJpaRepository() {
        return CodeType.JPA_REPOSITORY.getName(this.useCase);
    }

    @Override
    public String getFullNameJpaRepository() {
        return CodeType.JPA_REPOSITORY.getFullName(ModuleType.CLIENT.getNamePackage(this.element, this.nameSubPackage), this.useCase);
    }

    private boolean isRenameWsToWeb() {
        return !this.getModule().getFolder(this.element, "").exists();
    }

    private File getFile() {
        File folder = this.getModule().getFolder(this.element, this.nameSubPackage);
        if (this.isRenameWsToWeb()) {
            folder = this.getModule().getFolder(this.element, this.nameSubPackage);
            folder = new File(folder.getAbsolutePath().replace("-ws", "-web").replace(File.separator + "ws" + File.separator, File.separator + "web" + File.separator));
        }
        return new File(folder.getAbsolutePath() + File.separator + this.getName() + this.getType().getPathExtension());
    }
}

