/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Monitored;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.probe.ProbeLogger;

@Vetoed
@Priority(value=1000)
@Monitored
@Interceptor
@Dependent
public class InvocationMonitor
implements Serializable {
    private static final long serialVersionUID = -5245789370968148511L;
    private static final ThreadLocal<Invocation.Builder> INVOCATIONS = new ThreadLocal();
    private static final AtomicInteger INVOCATION_ID_GENERATOR = new AtomicInteger(0);
    private static final InterceptorAction INTERCEPTOR_ACTION = new InterceptorAction();
    @Intercepted
    @Inject
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="According to specification, injected bean has to be serializable.")
    private Bean<?> interceptedBean;
    @Inject
    private BeanManagerImpl beanManager;
    private volatile transient Probe probe = null;
    private volatile transient Boolean skipJavaBeanProperties;

    static Invocation.Builder initBuilder() {
        return InvocationMonitor.initBuilder(true);
    }

    static Invocation.Builder initBuilder(boolean initChild) {
        Invocation.Builder builder = INVOCATIONS.get();
        if (builder == null) {
            builder = Invocation.Builder.newBuilder(INVOCATION_ID_GENERATOR.incrementAndGet());
            INVOCATIONS.set(builder);
        } else if (initChild) {
            builder = builder.newChild();
            INVOCATIONS.set(builder);
        }
        return builder;
    }

    @AroundConstruct
    public void monitorCreation(InvocationContext ctx) {
        this.init();
        Invocation.Builder builder = InvocationMonitor.initBuilder();
        if (this.interceptedBean != null) {
            builder.setInterceptedBean(this.interceptedBean);
        } else {
            builder.setDeclaringClassName(ctx.getConstructor().getDeclaringClass().getName());
        }
        builder.setType(Invocation.Type.CONSTRUCTOR);
        builder.setStart(System.currentTimeMillis());
        builder.setMethodName(ctx.getConstructor().toString());
        try {
            INTERCEPTOR_ACTION.perform(builder, this.probe, ctx);
        }
        catch (Exception e) {
            ProbeLogger.LOG.aroundConstructMonitoringProblem(this.interceptedBean, e);
        }
    }

    @AroundInvoke
    public Object monitor(InvocationContext ctx) throws Exception {
        if (this.skipJavaBeanProperties.booleanValue() && this.isJavaBeanPropertyAccessor(ctx.getMethod())) {
            return ctx.proceed();
        }
        this.init();
        Invocation.Builder builder = InvocationMonitor.initBuilder();
        if (this.interceptedBean != null) {
            builder.setInterceptedBean(this.interceptedBean);
        } else {
            builder.setDeclaringClassName(ctx.getMethod().getDeclaringClass().getName());
        }
        builder.guessType(ctx);
        builder.setStart(System.currentTimeMillis());
        builder.setMethodName(ctx.getMethod().getName());
        return INTERCEPTOR_ACTION.perform(builder, this.probe, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.probe == null) {
            InvocationMonitor invocationMonitor = this;
            synchronized (invocationMonitor) {
                if (this.probe == null) {
                    this.probe = this.beanManager.getExtension(ProbeExtension.class).getProbe();
                    if (!this.probe.isInitialized()) {
                        throw ProbeLogger.LOG.probeNotInitialized();
                    }
                    this.skipJavaBeanProperties = this.beanManager.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.PROBE_INVOCATION_MONITOR_SKIP_JAVABEAN_PROPERTIES);
                }
            }
        }
    }

    private boolean isJavaBeanPropertyAccessor(Method method) {
        if (method.getParameterTypes().length == 0) {
            return method.getName().startsWith("get") || method.getName().startsWith("is");
        }
        if (method.getParameterTypes().length == 1) {
            return method.getName().startsWith("set");
        }
        return false;
    }

    private static class InterceptorAction
    extends Action<InvocationContext> {
        private InterceptorAction() {
        }

        @Override
        protected Object proceed(InvocationContext ctx) throws Exception {
            return ctx.proceed();
        }
    }

    static abstract class Action<T> {
        Action() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object perform(Invocation.Builder builder, Probe probe, T context) throws Exception {
            try {
                long start = System.nanoTime();
                Object result = this.proceed(context);
                builder.setDuration(System.nanoTime() - start);
                if (builder.isEntryPoint()) {
                    if (!builder.isIgnored()) {
                        probe.addInvocation(builder.build());
                    }
                } else {
                    INVOCATIONS.set(builder.getParent());
                }
                Object object = result;
                return object;
            }
            finally {
                if (builder.isEntryPoint()) {
                    INVOCATIONS.remove();
                }
            }
        }

        protected abstract Object proceed(T var1) throws Exception;
    }
}

