/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.enablement.Item;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.util.collections.ListView;

abstract class EnablementListView
extends ListView<Item, Class<?>> {
    private static final String ADD_OPERATION = "adds";
    private static final String REMOVE_OPERATION = "removes";
    private static final String SET_OPERATION = "sets";
    private static final String RETAIN_OPERATION = "retains";

    EnablementListView() {
    }

    protected abstract ViewType getViewType();

    protected abstract Extension getExtension();

    @Override
    public boolean add(Class<?> clazz) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), clazz, ADD_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().add(this.createSource(clazz));
    }

    @Override
    public Class<?> set(int index, Class<?> clazz) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), clazz, SET_OPERATION, (Object)this.getViewType());
        }
        return this.toView(this.getDelegate().set(index, this.createSource(clazz)));
    }

    @Override
    public void add(int index, Class<?> clazz) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), clazz, ADD_OPERATION, (Object)this.getViewType());
        }
        this.getDelegate().add(index, this.createSource(clazz));
    }

    @Override
    public Class<?> remove(int index) {
        Item removedItem = (Item)this.getDelegate().remove(index);
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), removedItem.getClass(), REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.toView(removedItem);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), c, REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), o, REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().remove(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), c, RETAIN_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().retainAll(c);
    }

    @Override
    public void clear() {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), "", "removes all classes", (Object)this.getViewType());
        }
        this.getDelegate().clear();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Class<?>> listIterator() {
        return new EnablementListViewIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<Class<?>> listIterator(int index) {
        return new EnablementListViewIterator(this.getDelegate().listIterator(index));
    }

    @Override
    protected Class<?> toView(Item source) {
        return source.getJavaClass();
    }

    @Override
    protected Item createSource(Class<?> view) {
        return new Item(view);
    }

    static enum ViewType {
        ALTERNATIVES("getAlternatives()"),
        INTERCEPTORS("getInterceptors()"),
        DECORATORS("getDecorators()");

        private final String name;

        private ViewType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    class EnablementListViewIterator
    extends ListView.ListViewIterator {
        private ListIterator<Item> delegate;

        public EnablementListViewIterator(ListIterator<Item> delegate) {
            super(EnablementListView.this, delegate);
            this.delegate = delegate;
        }

        @Override
        public void remove() {
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), ((Item)EnablementListView.this.getDelegate().get(this.delegate.nextIndex())).getJavaClass(), EnablementListView.REMOVE_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.remove();
        }

        @Override
        public void set(Class<?> clazz) {
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), clazz, EnablementListView.SET_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.set(EnablementListView.this.createSource(clazz));
        }

        @Override
        public void add(Class<?> clazz) {
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), clazz, EnablementListView.ADD_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.add(EnablementListView.this.createSource(clazz));
        }
    }
}

