/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.BitSet;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    boolean isFirstCol;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_18:54:37_PDT_2005";

    T4CTTIrxd(T4CMAREngine t4CMAREngine) {
        super((byte)7);
        this.setMarshalingEngine(t4CMAREngine);
        this.isFirstCol = true;
    }

    void init() {
        this.isFirstCol = true;
    }

    void setNumberOfColumns(int n) {
        this.nbOfColumns = n;
        this.bvcFound = false;
        this.bvcColSent = new BitSet(this.nbOfColumns);
    }

    void unmarshalBVC(int n) throws SQLException, IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.bvcColSent.length(); ++n2) {
            this.bvcColSent.clear(n2);
        }
        n2 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i = 0; i < n2; ++i) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int j = 0; j < 8; ++j) {
                if ((by & 1 << j) == 0) continue;
                this.bvcColSent.set(i * 8 + j);
                ++n3;
            }
        }
        if (n3 != n) {
            DatabaseError.throwSqlException(-1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] byArray) throws SQLException, IOException {
        int n;
        for (n = 0; n < this.bvcColSent.length(); ++n) {
            this.bvcColSent.clear(n);
        }
        if (byArray == null || byArray.length == 0) {
            this.bvcFound = false;
        } else {
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                for (int i = 0; i < 8; ++i) {
                    if ((by & 1 << i) == 0) continue;
                    this.bvcColSent.set(n * 8 + i);
                }
            }
            this.bvcFound = true;
        }
    }

    void marshal(byte[] byArray, char[] cArray, short[] sArray, int n, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n2, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4) throws IOException, SQLException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        this.marshalTTCcode();
        int n19 = sArray[n + 0] & 0xFFFF;
        int n20 = 0;
        int n21 = nArray3[0];
        int[] nArray5 = nArray4[0];
        int n22 = 0;
        for (n18 = 0; n18 < n19; ++n18) {
            short s;
            int n23;
            int n24;
            if (n21 > 0 && nArray5[n20] == n18) {
                ++n20;
                continue;
            }
            n17 = 0;
            n16 = n + 3 + 10 * n18;
            n15 = sArray[n16 + 0] & 0xFFFF;
            if (byArray5 != null && (byArray5[n18] & 0x20) == 0) {
                if (n15 != 998) continue;
                ++n22;
                continue;
            }
            n14 = ((sArray[n16 + 7] & 0xFFFF) << 16) + (sArray[n16 + 8] & 0xFFFF) + n2;
            n13 = ((sArray[n16 + 5] & 0xFFFF) << 16) + (sArray[n16 + 6] & 0xFFFF) + n2;
            n12 = sArray[n14] & 0xFFFF;
            n11 = sArray[n13];
            if (n15 == 116) {
                this.meg.marshalUB1((short)1);
                this.meg.marshalUB1((short)0);
                continue;
            }
            if (n15 == 994) {
                n11 = -1;
                n24 = nArray2[3 + n18 * 3 + 0];
                if (n24 == 109) {
                    n17 = 1;
                }
            }
            if (n11 == -1) {
                if (n15 == 109 || n17 != 0) {
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalDALC(NO_BYTES);
                    this.meg.marshalUB2(0);
                    this.meg.marshalUB4(0L);
                    this.meg.marshalUB2(1);
                    continue;
                }
                if (n15 == 998) {
                    ++n22;
                    this.meg.marshalUB4(0L);
                    continue;
                }
                if (n15 == 112 || n15 == 113 || n15 == 114) {
                    this.meg.marshalUB4(0L);
                    continue;
                }
                if (n15 != 8 && n15 != 24) {
                    if (nArray[n18] == 0) continue;
                    this.meg.marshalUB1((short)0);
                    continue;
                }
            }
            if (n15 == 8 || n15 == 24) {
                if (n21 >= nArray5.length) {
                    int[] nArray6 = new int[nArray5.length << 1];
                    System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                    nArray5 = nArray6;
                }
                nArray5[n21++] = n18;
                continue;
            }
            if (n15 == 998) {
                n24 = (sArray2[6 + n22 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n22 * 8 + 5] & 0xFFFF;
                n23 = (sArray2[6 + n22 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n22 * 8 + 7] & 0xFFFF;
                n10 = sArray2[6 + n22 * 8] & 0xFFFF;
                n9 = sArray2[6 + n22 * 8 + 1] & 0xFFFF;
                this.meg.marshalUB4(n24);
                for (n8 = 0; n8 < n24; ++n8) {
                    s = n23 + n8 * n9;
                    if (n10 == 9) {
                        n7 = cArray2[s] / 2;
                        n6 = 0;
                        n6 = dBConversion.javaCharsToCHARBytes(cArray2, s + 1, byArray2, 0, n7);
                        this.meg.marshalCLR(byArray2, n6);
                        continue;
                    }
                    n12 = byArray4[s];
                    if (n12 < 1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    this.meg.marshalCLR(byArray4, s + 1, n12);
                }
                ++n22;
                continue;
            }
            int n25 = sArray[n16 + 1] & 0xFFFF;
            if (n25 != 0) {
                int n26 = ((sArray[n16 + 3] & 0xFFFF) << 16) + (sArray[n16 + 4] & 0xFFFF) + n25 * n2;
                if (n15 == 6) {
                    ++n26;
                    --n12;
                } else if (n15 == 9) {
                    n26 += 2;
                    n12 -= 2;
                } else if (n15 == 114 || n15 == 113 || n15 == 112) {
                    this.meg.marshalUB4(n12);
                }
                if (n15 == 109 || n15 == 111) {
                    byte[] byArray6;
                    if (byArray3 == null) {
                        DatabaseError.throwSqlException(-1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                    }
                    int n27 = n12 = (byArray6 = byArray3[n18]) == null ? 0 : byArray6.length;
                    if (n15 == 109) {
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalDALC(NO_BYTES);
                        this.meg.marshalUB2(0);
                        this.meg.marshalUB4(n12);
                        this.meg.marshalUB2(1);
                    }
                    if (n12 <= 0) continue;
                    this.meg.marshalCLR(byArray6, 0, n12);
                    continue;
                }
                if (n15 == 104) {
                    long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n26 += 2, 18);
                    n23 = 14;
                    long l = lArray[0];
                    n8 = (int)lArray[1];
                    s = 0;
                    long l2 = lArray[2];
                    int n28 = (int)lArray[3];
                    if (l == 0L && n8 == 0 && l2 == 0L && n28 == 0) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    this.meg.marshalUB1((short)n23);
                    this.meg.marshalUB4(l);
                    this.meg.marshalUB2(n8);
                    this.meg.marshalUB1(s);
                    this.meg.marshalUB4(l2);
                    this.meg.marshalUB2(n28);
                    continue;
                }
                if (n12 < 1) {
                    this.meg.marshalUB1((short)0);
                    continue;
                }
                this.meg.marshalCLR(byArray, n26, n12);
                continue;
            }
            n5 = sArray[n16 + 9] & 0xFFFF;
            if (!bl && nArray != null && nArray.length > n18 && nArray[n18] > 4000) {
                if (n21 >= nArray5.length) {
                    int[] nArray7 = new int[nArray5.length << 1];
                    System.arraycopy(nArray5, 0, nArray7, 0, nArray5.length);
                    nArray5 = nArray7;
                }
                nArray5[n21++] = n18;
                continue;
            }
            n4 = sArray[n16 + 2] & 0xFFFF;
            n3 = ((sArray[n16 + 3] & 0xFFFF) << 16) + (sArray[n16 + 4] & 0xFFFF) + n4 * n2 + 1;
            if (n15 == 996) {
                n24 = cArray[n3 - 1];
                if (this.bufferCHAR == null || this.bufferCHAR.length < n24) {
                    this.bufferCHAR = new byte[n24];
                }
                for (n23 = 0; n23 < n24; ++n23) {
                    this.bufferCHAR[n23] = (byte)((cArray[n3 + n23 / 2] & 0xFF00) >> 8 & 0xFF);
                    if (n23 >= n24 - 1) continue;
                    this.bufferCHAR[n23 + 1] = (byte)(cArray[n3 + n23 / 2] & 0xFF & 0xFF);
                    ++n23;
                }
                this.meg.marshalCLR(this.bufferCHAR, n24);
                if (this.bufferCHAR.length <= 4000) continue;
                this.bufferCHAR = null;
                continue;
            }
            if (n15 == 96) {
                n7 = n12 / 2;
                --n3;
            } else {
                n7 = (n12 - 2) / 2;
            }
            n6 = 0;
            n6 = n5 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n3, byArray2, 0, n7) : dBConversion.javaCharsToCHARBytes(cArray, n3, byArray2, 0, n7);
            this.meg.marshalCLR(byArray2, n6);
        }
        if (n21 > 0) {
            for (n18 = 0; n18 < n21; ++n18) {
                InputStream inputStream;
                int n29;
                n17 = nArray5[n18];
                n16 = n + 3 + 10 * n17;
                n15 = sArray[n16 + 0] & 0xFFFF;
                n14 = ((sArray[n16 + 7] & 0xFFFF) << 16) + (sArray[n16 + 8] & 0xFFFF) + n2;
                n13 = ((sArray[n16 + 5] & 0xFFFF) << 16) + (sArray[n16 + 6] & 0xFFFF) + n2;
                n11 = sArray[n13];
                n12 = sArray[n14] & 0xFFFF;
                n4 = sArray[n16 + 2] & 0xFFFF;
                n3 = ((sArray[n16 + 3] & 0xFFFF) << 16) + (sArray[n16 + 4] & 0xFFFF) + n4 * n2 + 1;
                if (n11 == -1) {
                    this.meg.marshalUB1((short)0);
                    continue;
                }
                if (n15 == 996) {
                    n29 = cArray[n3 - 1];
                    if (this.bufferCHAR == null || this.bufferCHAR.length < n29) {
                        this.bufferCHAR = new byte[n29];
                    }
                    for (int i = 0; i < n29; ++i) {
                        this.bufferCHAR[i] = (byte)((cArray[n3 + i / 2] & 0xFF00) >> 8 & 0xFF);
                        if (i >= n29 - 1) continue;
                        this.bufferCHAR[i + 1] = (byte)(cArray[n3 + i / 2] & 0xFF & 0xFF);
                        ++i;
                    }
                    this.meg.marshalCLR(this.bufferCHAR, n29);
                    if (this.bufferCHAR.length <= 4000) continue;
                    this.bufferCHAR = null;
                    continue;
                }
                if (n15 != 8 && n15 != 24) {
                    if (n15 == 96) {
                        n7 = n12 / 2;
                        --n3;
                    } else {
                        n7 = (n12 - 2) / 2;
                    }
                    n5 = sArray[n16 + 9] & 0xFFFF;
                    n6 = 0;
                    n6 = n5 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n3, byArray2, 0, n7) : dBConversion.javaCharsToCHARBytes(cArray, n3, byArray2, 0, n7);
                    this.meg.marshalCLR(byArray2, n6);
                    continue;
                }
                n29 = n17;
                if (inputStreamArray == null || (inputStream = inputStreamArray[n29]) == null) continue;
                n10 = 64;
                if (this.buffer == null) {
                    this.buffer = new byte[n10];
                }
                n9 = 0;
                this.meg.marshalUB1((short)254);
                n8 = 0;
                while (n8 == 0) {
                    n9 = inputStream.read(this.buffer, 0, n10);
                    if (n9 < n10) {
                        n8 = 1;
                    }
                    if (n9 <= 0) continue;
                    this.meg.marshalUB1((short)(n9 & 0xFF));
                    this.meg.marshalB1Array(this.buffer, 0, n9);
                }
                this.meg.marshalSB1((byte)0);
            }
        }
        nArray3[0] = n21;
        nArray4[0] = nArray5;
    }

    boolean unmarshal(Accessor[] accessorArray, int n) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n);
    }

    boolean unmarshal(Accessor[] accessorArray, int n, int n2) throws SQLException, IOException {
        if (n == 0) {
            this.isFirstCol = true;
        }
        for (int i = n; i < n2 && i < accessorArray.length; ++i) {
            if (accessorArray[i] == null) continue;
            if (accessorArray[i].physicalColumnIndex < 0) {
                int n3 = 0;
                for (int j = 0; j < n2 && j < accessorArray.length; ++j) {
                    if (accessorArray[j] == null) continue;
                    accessorArray[j].physicalColumnIndex = n3++;
                    if (accessorArray[j].isUseLess) continue;
                }
            }
            if (this.bvcFound && !accessorArray[i].isUseLess) {
                if (this.bvcColSent.get(accessorArray[i].physicalColumnIndex)) {
                    if (accessorArray[i].unmarshalOneRow()) {
                        return true;
                    }
                    this.isFirstCol = false;
                    continue;
                }
                accessorArray[i].copyRow();
                continue;
            }
            if (accessorArray[i].unmarshalOneRow()) {
                return true;
            }
            this.isFirstCol = false;
        }
        this.bvcFound = false;
        return false;
    }

    boolean unmarshal(Accessor[] accessorArray, int n, int n2, int n3) throws SQLException, IOException {
        return false;
    }
}

