/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;

public class PulseLogger {
    public static final boolean PULSE_LOGGING_ENABLED;
    private static final String[] DEFAULT_LOGGERS;
    private static final Logger[] loggers;

    public static void pulseStart() {
        for (Logger logger2 : loggers) {
            logger2.pulseStart();
        }
    }

    public static void pulseEnd() {
        for (Logger logger2 : loggers) {
            logger2.pulseEnd();
        }
    }

    public static void renderStart() {
        for (Logger logger2 : loggers) {
            logger2.renderStart();
        }
    }

    public static void renderEnd() {
        for (Logger logger2 : loggers) {
            logger2.renderEnd();
        }
    }

    public static void addMessage(String string) {
        for (Logger logger2 : loggers) {
            logger2.addMessage(string);
        }
    }

    public static void incrementCounter(String string) {
        for (Logger logger2 : loggers) {
            logger2.incrementCounter(string);
        }
    }

    public static void newPhase(String string) {
        for (Logger logger2 : loggers) {
            logger2.newPhase(string);
        }
    }

    public static void newInput(String string) {
        for (Logger logger2 : loggers) {
            logger2.newInput(string);
        }
    }

    public static boolean isPulseLoggingRequested() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.pulseLogger"));
    }

    private static Logger loadLogger(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("createInstance", new Class[0]);
                return (Logger)method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        DEFAULT_LOGGERS = new String[]{"com.sun.javafx.logging.PrintLogger", "com.sun.javafx.logging.jfr.JFRPulseLogger"};
        ArrayList<Logger> arrayList = new ArrayList<Logger>();
        for (String string : DEFAULT_LOGGERS) {
            Logger logger2 = PulseLogger.loadLogger(string);
            if (logger2 == null) continue;
            arrayList.add(logger2);
        }
        loggers = arrayList.toArray(new Logger[arrayList.size()]);
        PULSE_LOGGING_ENABLED = loggers.length > 0;
    }
}

