/*
 * Decompiled with CFR 0.152.
 */
package br.com.wesa.listener;

import br.com.jarch.core.annotation.JArchJsfEventAfter;
import br.com.jarch.core.annotation.JArchJsfEventRestoreView;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.exception.InsertException;
import br.com.jarch.core.exception.LoginException;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.faces.util.JsfUtils;
import br.com.jarch.util.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.enterprise.event.Observes;
import javax.faces.event.PhaseEvent;

public abstract class ValidacaoAcessoUsuarioBase {
    private static final String JSF = ".jsf";
    private static final String XHTML = ".xhtml";

    private void escutaFaseRenderizacao(@Observes @JArchJsfEventAfter @JArchJsfEventRestoreView PhaseEvent event, UserInformation userInformation) throws InsertException {
        JsfUtils.updateTimerSession();
        String url = event.getFacesContext().getViewRoot().getViewId();
        if (url.contains("/index.") || url.contains("/reg/") || url.contains("paginas/login/login.") || url.contains("paginas/login/logout.")) {
            return;
        }
        try {
            if (this.abortaValidacao(url) || this.verificaUltimaUrlAcessada(url) || !url.toLowerCase(ValidacaoAcessoUsuarioBase.getLocale()).contains(JSF) && !url.toLowerCase(ValidacaoAcessoUsuarioBase.getLocale()).contains(XHTML)) {
                return;
            }
            if (userInformation.isNotExists()) {
                throw new LoginException();
            }
        }
        catch (LoginException ex) {
            LogUtils.generate(ex);
            JsfUtils.redirect((String)"../login/usuarioNaoLogado.jsf");
        }
    }

    private static Locale getLocale() {
        return GlobalInformation.getInstance().getLocale();
    }

    private boolean verificaUltimaUrlAcessada(String url) {
        String ultimaUrlAcessada = (String)((Object)JsfUtils.getAttributeSession((String)"ultimaUrlAcessada"));
        if (ultimaUrlAcessada != null && ultimaUrlAcessada.equals(url)) {
            return true;
        }
        JsfUtils.setAttributeSession((String)"ultimaUrlAcessada", (Object)url);
        return false;
    }

    private boolean abortaValidacao(String url) {
        return this.getPaginasLiberadas().stream().anyMatch(url::contains);
    }

    public List<String> getPaginasLiberadas() {
        return new ArrayList<String>();
    }
}

