/*
 * Decompiled with CFR 0.152.
 */
package br.com.wesa.crud.usuario;

import br.com.jarch.core.model.IUser;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.faces.controller.BaseJsfController;
import br.com.jarch.faces.util.JavaScriptUtils;
import br.com.jarch.faces.util.JsfUtils;
import br.com.jarch.faces.util.TemplateUtils;
import br.com.wesa.crud.usuario.UsuarioMultiTenantBaseEntity;
import br.com.wesa.crud.usuario.UsuarioMultiTenantBaseService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.security.auth.login.LoginException;

public abstract class MultiTenantAlteraSenhaController<S extends UsuarioMultiTenantBaseService<?, ?>>
extends BaseJsfController {
    @Inject
    private transient S service;
    private IUser usuario;
    private String login = "";
    private String senhaAtual = "";
    private String novaSenha = "";
    private String confirmaSenha = "";
    private boolean validaSenhaAtual = true;

    @PostConstruct
    private void init() {
        this.usuario = UserInformation.getInstance().get();
        if (this.usuario != null) {
            this.login = this.usuario.getLogin();
            this.senhaAtual = this.usuario.getSenha();
        }
    }

    public void redirecionaAposGrava() {
        JavaScriptUtils.showMessageBodySuccessRedirect((String)"../login/bemVindo.jsf");
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenhaAtual() {
        return this.senhaAtual;
    }

    public void setSenhaAtual(String senhaAtual) {
        this.senhaAtual = senhaAtual;
    }

    public String getNovaSenha() {
        return this.novaSenha;
    }

    public void setNovaSenha(String novaSenha) {
        this.novaSenha = novaSenha;
    }

    public String getConfirmaSenha() {
        return this.confirmaSenha;
    }

    public void setConfirmaSenha(String confirmaSenha) {
        this.confirmaSenha = confirmaSenha;
    }

    public void voltar() {
        this.redireciona("../login/login.jsf");
    }

    public void gravar() {
        try {
            if (this.login.isEmpty()) {
                throw new LoginException(BundleUtils.messageBundle("required.loginObrigatorio"));
            }
            if (this.novaSenha == null || this.novaSenha.isEmpty()) {
                throw new LoginException(BundleUtils.messageBundle("required.novaSenhaObrigatorio"));
            }
            if (this.confirmaSenha == null || this.confirmaSenha.isEmpty()) {
                throw new LoginException(BundleUtils.messageBundle("required.confirmaSenhaObrigatorio"));
            }
            if (!this.novaSenha.equals(this.confirmaSenha)) {
                throw new LoginException(BundleUtils.messageBundle("message.confirmaSenhaDiferenteNovaSenha"));
            }
            Object UsuarioBaseEntity2 = ((UsuarioMultiTenantBaseService)this.service).buscaUmPorLogin(this.login);
            if (!((UsuarioMultiTenantBaseEntity)UsuarioBaseEntity2).senhaValida(this.senhaAtual)) {
                throw new LoginException(BundleUtils.messageBundle("message.senhaAtualIncorreta"));
            }
            if (this.senhaAtual == null) {
                this.senhaAtual = "";
            }
            UserInformation.getInstance().set(UsuarioBaseEntity2);
            ((UsuarioMultiTenantBaseService)this.service).atualizaSenha(this.login, this.novaSenha);
            this.redireciona("../login/login.jsf");
        }
        catch (Exception ex) {
            JsfUtils.addMessageError((Exception)ex);
        }
    }

    public void grava() {
        try {
            ((UsuarioMultiTenantBaseService)this.service).atualizaSenha(this.login, this.novaSenha);
            TemplateUtils.showHeader();
            TemplateUtils.showNav();
            this.redirecionaAposGrava();
        }
        catch (Exception ex) {
            JsfUtils.addMessageError((Exception)ex);
        }
    }

    public boolean isValidaSenhaAtual() {
        return this.validaSenhaAtual;
    }

    public void setValidaSenhaAtual(boolean validaSenhaAtual) {
        this.validaSenhaAtual = validaSenhaAtual;
    }

    public void cancela() {
        JsfUtils.redirect((String)"../login/login.jsf");
    }
}

