/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public final class SqlUtils {
    public static boolean SHOWLOG = true;

    private SqlUtils() {
    }

    public static Dados selecionar(Connection connection, String cmdSQL, Object ... listaParametro) throws SQLException, IOException {
        if (SHOWLOG) {
            LogUtils.generate(cmdSQL);
        }
        Statement stmt = connection.createStatement();
        Dados dados = new Dados();
        dados.setStatement(stmt);
        if (listaParametro != null) {
            PreparedStatement ps = connection.prepareStatement(cmdSQL);
            dados.setPreparedStatement(ps);
            SqlUtils.setarParametro(ps, listaParametro);
            dados.setResultSet(ps.executeQuery());
        } else {
            dados.setResultSet(stmt.executeQuery(cmdSQL));
        }
        return dados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executar(Connection connection, String cmdSQL, Object ... listaParametro) throws SQLException, IOException {
        if (SHOWLOG) {
            LogUtils.generate(cmdSQL);
        }
        Statement stmt = null;
        Statement ps = null;
        try {
            stmt = connection.createStatement();
            if (listaParametro != null) {
                ps = connection.prepareStatement(cmdSQL);
                SqlUtils.setarParametro((PreparedStatement)ps, listaParametro);
                int n = ps.executeUpdate();
                return n;
            }
            int n = stmt.executeUpdate(cmdSQL);
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static void setarParametro(PreparedStatement ps, Object[] listaParametro) throws SQLException, IOException {
        for (int i = 0; i < listaParametro.length; ++i) {
            String valorParametro = "null";
            String classeParametro = "null";
            if (listaParametro[i] != null) {
                valorParametro = listaParametro[i].toString();
                classeParametro = listaParametro[i].getClass().getName();
            }
            if (SHOWLOG) {
                LogUtils.generate("Parametro " + i + " = " + valorParametro + " Tipo = " + classeParametro);
            }
            if (listaParametro[i] == null) {
                ps.setNull(i + 1, 0);
                continue;
            }
            if (listaParametro[i] instanceof String) {
                ps.setString(i + 1, (String)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Integer) {
                ps.setInt(i + 1, (Integer)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Long) {
                ps.setLong(i + 1, (Long)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Timestamp) {
                ps.setTimestamp(i + 1, (Timestamp)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Date) {
                Date data = (Date)listaParametro[i];
                ps.setTimestamp(i + 1, new Timestamp(data.getTime()));
                continue;
            }
            if (listaParametro[i] instanceof java.sql.Date) {
                ps.setDate(i + 1, (java.sql.Date)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Time) {
                ps.setTime(i + 1, (Time)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof Float) {
                ps.setFloat(i + 1, ((Float)listaParametro[i]).floatValue());
                continue;
            }
            if (listaParametro[i] instanceof Boolean) {
                ps.setBoolean(i + 1, (Boolean)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof byte[]) {
                ps.setBytes(i + 1, (byte[])listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof InputStream) {
                ps.setBinaryStream(i + 1, (InputStream)listaParametro[i], ((InputStream)listaParametro[i]).available());
                continue;
            }
            if (listaParametro[i] instanceof BigDecimal) {
                ps.setBigDecimal(i + 1, (BigDecimal)listaParametro[i]);
                continue;
            }
            if (listaParametro[i] instanceof BigInteger) {
                ps.setLong(i + 1, ((BigInteger)listaParametro[i]).longValue());
                continue;
            }
            throw new SQLException("Nao preparado para esse tipo ainda... " + String.valueOf(listaParametro[i].getClass()));
        }
    }

    public static class Dados {
        private PreparedStatement preparedStatement;
        private Statement statement;
        private ResultSet resultSet;

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public void setPreparedStatement(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public void setStatement(Statement statement) {
            this.statement = statement;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public void setResultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        public void fechar() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.preparedStatement != null) {
                    this.preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

