/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class LogUtils {
    private static final boolean SHOWTIME = false;
    private static final String SEPARATOR = "#".repeat(70).concat("\n");
    private static final int STACKTRACE_INITIAL = 2;
    private static final int STACKTRACE_FINAL = 3;
    private static int positionStackTrace = 2;

    private LogUtils() {
    }

    public static void start() {
        positionStackTrace = 3;
        LogUtils.generate("##### * * * I N I C I O * * * #####");
    }

    public static void end() {
        positionStackTrace = 3;
        LogUtils.generate("##### * * * F I M * * * #####");
    }

    public static void generate(boolean ifCondition, String message) {
        if (!ifCondition) {
            return;
        }
        LogUtils.generate(message);
    }

    public static void generate(String message) {
        String classCall = LogUtils.classCall();
        String methodCall = LogUtils.methodCall();
        int rowCall = LogUtils.rowCall();
        LogUtils.generate(classCall, methodCall, rowCall, message, true);
    }

    public static void generate() {
        String classCall = LogUtils.classCall();
        String methodCall = LogUtils.methodCall();
        int rowCall = LogUtils.rowCall();
        LogUtils.generate(classCall, methodCall, rowCall, "", true);
    }

    public static void warning(boolean ifCondition, String message) {
        if (!ifCondition) {
            return;
        }
        LogUtils.warning(message);
    }

    public static void warning(String message) {
        String classCall = LogUtils.classCall();
        String methodCall = LogUtils.methodCall();
        int rowCall = LogUtils.rowCall();
        LogUtils.generate(classCall, methodCall, rowCall, "\n" + SEPARATOR + SEPARATOR + "####### ---> " + message + "\n" + SEPARATOR + SEPARATOR, true);
    }

    public static void warning() {
        String classCall = LogUtils.classCall();
        String methodCall = LogUtils.methodCall();
        int rowCall = LogUtils.rowCall();
        LogUtils.generate(classCall, methodCall, rowCall, "\n" + SEPARATOR + SEPARATOR + "#######\n" + SEPARATOR + SEPARATOR, true);
    }

    public static void generate(Throwable ex) {
        ex.printStackTrace();
    }

    public static void generateSilent(Throwable ex) {
    }

    private static String methodCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return ste[positionStackTrace].getMethodName();
    }

    private static String classCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        String result = ste[positionStackTrace].getClassName();
        if (result.contains(".")) {
            result = result.substring(result.lastIndexOf(46) + 1);
        }
        return result;
    }

    private static int rowCall() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return ste[positionStackTrace].getLineNumber();
    }

    private static void generate(String clazz, String method, int row, String message, boolean showMessage) {
        if (showMessage) {
            System.out.println(clazz + ":" + row + " - " + method + " - " + message);
        }
        positionStackTrace = 2;
    }

    private static String timeLocal() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }
}

