/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.ui;

import br.com.jarch.gca.fx.ui.FieldFormTableView;
import java.util.regex.Pattern;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;

public class IntegerColunaCell
extends TableCell<FieldFormTableView, Integer> {
    private final TextField textField = new TextField();
    private final Pattern intPattern = Pattern.compile("-?\\d+");

    public IntegerColunaCell() {
        this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                this.processEdit();
            }
        });
        this.textField.setOnAction(event -> this.processEdit());
    }

    private void processEdit() {
        String text = this.textField.getText();
        if (this.intPattern.matcher(text).matches()) {
            this.commitEdit(Integer.parseInt(text));
        } else {
            this.cancelEdit();
        }
    }

    @Override
    public void updateItem(Integer value, boolean empty) {
        super.updateItem(value, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.textField.setText(value.toString());
            this.setGraphic(this.textField);
        } else {
            this.setText(value == null ? "" : value.toString());
            this.setGraphic(null);
        }
    }

    @Override
    public void startEdit() {
        super.startEdit();
        Integer value = (Integer)this.getItem();
        if (value != null) {
            this.textField.setText(value.toString());
            this.setGraphic(this.textField);
            this.setText(null);
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(((Integer)this.getItem()).toString());
        this.setGraphic(null);
    }

    @Override
    public void commitEdit(Integer value) {
        super.commitEdit(value);
        ((FieldFormTableView)this.getTableRow().getItem()).setColuna((int)value);
    }
}

