/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.ui;

import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.gca.fx.ui.CheckBoxTableCell;
import br.com.jarch.gca.fx.ui.FieldFormTableView;
import br.com.jarch.gca.fx.ui.IntegerColunaCell;
import br.com.jarch.gca.fx.ui.IntegerLinhaCell;
import br.com.jarch.util.LogUtils;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;

public class ColunaTableView {
    public static void criaColunasTableView(TableView<FieldFormTableView> tableView) {
        ObservableList<FieldType> observableCampoType = FXCollections.observableList(Arrays.asList(FieldType.values()));
        tableView.getColumns().clear();
        TableColumn<FieldFormTableView, String> atributo = new TableColumn<FieldFormTableView, String>();
        atributo.setText(BundleUtils.messageBundle("label.attribute"));
        atributo.setCellValueFactory(new PropertyValueFactory("atributo"));
        atributo.setMinWidth(120.0);
        atributo.setCellFactory(TextFieldTableCell.forTableColumn());
        TableColumn<FieldFormTableView, String> colunaTabela = new TableColumn<FieldFormTableView, String>();
        colunaTabela.setText(BundleUtils.messageBundle("label.columnTable"));
        colunaTabela.setCellValueFactory(new PropertyValueFactory("campoTabela"));
        colunaTabela.setMinWidth(120.0);
        colunaTabela.setCellFactory(TextFieldTableCell.forTableColumn());
        TableColumn<FieldFormTableView, String> descricao = new TableColumn<FieldFormTableView, String>();
        descricao.setText(BundleUtils.messageBundle("label.description"));
        descricao.setCellValueFactory(new PropertyValueFactory("descricao"));
        descricao.setMinWidth(180.0);
        descricao.setCellFactory(TextFieldTableCell.forTableColumn());
        TableColumn<FieldFormTableView, FieldType> tipo = new TableColumn<FieldFormTableView, FieldType>();
        tipo.setText(BundleUtils.messageBundle("label.fieldType"));
        tipo.setCellValueFactory(new PropertyValueFactory("tipo"));
        tipo.setMinWidth(100.0);
        tipo.setCellFactory(ComboBoxTableCell.forTableColumn(observableCampoType));
        TableColumn linha = new TableColumn();
        linha.setText(BundleUtils.messageBundle("label.row"));
        linha.setMinWidth(40.0);
        linha.setCellValueFactory(new PropertyValueFactory("linha"));
        linha.setCellFactory(col -> new IntegerLinhaCell());
        TableColumn coluna = new TableColumn();
        coluna.setText(BundleUtils.messageBundle("label.column"));
        coluna.setMinWidth(40.0);
        coluna.setCellValueFactory(new PropertyValueFactory("coluna"));
        coluna.setCellFactory(col -> new IntegerColunaCell());
        TableColumn obrigatorio = new TableColumn();
        obrigatorio.setText(BundleUtils.messageBundle("label.requiredAbreviation"));
        obrigatorio.setCellValueFactory(new PropertyValueFactory("obrigatorio"));
        obrigatorio.setMinWidth(40.0);
        obrigatorio.setCellFactory(p -> new CheckBoxTableCell());
        TableColumn grid = new TableColumn();
        grid.setText(BundleUtils.messageBundle("label.grid"));
        grid.setCellValueFactory(new PropertyValueFactory("grid"));
        grid.setMinWidth(40.0);
        grid.setCellFactory(p -> new CheckBoxTableCell());
        TableColumn pesquisa = new TableColumn();
        pesquisa.setText(BundleUtils.messageBundle("label.search"));
        pesquisa.setCellValueFactory(new PropertyValueFactory("pesquisa"));
        pesquisa.setMinWidth(40.0);
        pesquisa.setCellFactory(p -> new CheckBoxTableCell());
        TableColumn addView = new TableColumn();
        addView.setText(BundleUtils.messageBundle("label.xhtml"));
        addView.setCellValueFactory(new PropertyValueFactory("addView"));
        addView.setMinWidth(40.0);
        addView.setCellFactory(p -> new CheckBoxTableCell());
        ColunaTableView.updateObservableListProperties(atributo, colunaTabela, descricao, tipo);
        tableView.getColumns().addAll(tipo, atributo, colunaTabela, descricao, addView, linha, coluna, obrigatorio, grid, pesquisa);
    }

    private static void updateObservableListProperties(TableColumn<FieldFormTableView, String> atributo, TableColumn<FieldFormTableView, String> colunaTabela, TableColumn<FieldFormTableView, String> descricao, TableColumn<FieldFormTableView, FieldType> tipo) {
        atributo.setOnEditCommit(new EventHandler<TableColumn.CellEditEvent<FieldFormTableView, String>>(){

            @Override
            public void handle(TableColumn.CellEditEvent<FieldFormTableView, String> t) {
                LogUtils.generate(t.getNewValue());
                ((FieldFormTableView)t.getTableView().getItems().get(t.getTablePosition().getRow())).setAtributo(t.getNewValue());
            }
        });
        descricao.setOnEditCommit(new EventHandler<TableColumn.CellEditEvent<FieldFormTableView, String>>(){

            @Override
            public void handle(TableColumn.CellEditEvent<FieldFormTableView, String> t) {
                LogUtils.generate(t.getNewValue());
                ((FieldFormTableView)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDescricao(t.getNewValue());
            }
        });
        tipo.setOnEditCommit(new EventHandler<TableColumn.CellEditEvent<FieldFormTableView, FieldType>>(){

            @Override
            public void handle(TableColumn.CellEditEvent<FieldFormTableView, FieldType> t) {
                FieldType campoType = FieldType.valueOf(t.getNewValue().toString());
                LogUtils.generate(campoType.toString());
                FieldFormTableView campoForm = (FieldFormTableView)t.getTableView().getItems().get(t.getTablePosition().getRow());
                campoForm.setTipo(campoType.toString());
                campoForm.setAtributo(campoType.getAttribute());
                campoForm.setDescricao(campoType.getDescription());
                campoForm.setCampoTabela(campoType.getNameColumnDatabase().toLowerCase());
                campoForm.setTamanho(campoType.getWidthXhtml());
            }
        });
    }
}

