/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.logica;

import br.com.jarch.core.model.type.DataBaseType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.gca.fx.logica.ColumnDataBase;
import br.com.jarch.gca.fx.main.MensagemView;
import br.com.jarch.gca.fx.util.LogicaUtils;
import br.com.jarch.gca.fx.util.TableViewUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.SqlUtils;
import br.com.wesa.utils.ConexaoBancoDadosUtils;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.swing.JOptionPane;

public class ImportaTabelaController
implements Initializable {
    private static final String[] CAMPOS_ARCH = "SQ_VERSAOREGISTRO;DH_EXCLUSAO;DH_ALTERACAO;ID_USUARIOALTERACAO;ID_MULTITENANT".split(";");
    public static Stage stage;
    public static List<ColumnDataBase> listaCamposRetorno;
    public static String nomeTabela;
    private static boolean ignorePatterns;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private ComboBox cmbOrigem;
    @FXML
    private TextArea txtareaStringConexaoOrigem;
    @FXML
    private TextField txtfldUsuarioOrigem;
    @FXML
    private PasswordField pwdfldSenhaOrigem;
    @FXML
    private TextField txtfldIP;
    @FXML
    private TextField txtfldPorta;
    @FXML
    private TextField txtfldBancoDados;
    @FXML
    private Button btnConectarOrigem;
    @FXML
    private ListView lstviewSelecionar;
    @FXML
    private ListView lstviewSelecionado;
    @FXML
    private Button btnProcessar;
    @FXML
    private TextField txtfldSchemaOrigem;
    @FXML
    private CheckBox checkBoxTabelaForaPadrao;
    @FXML
    private Label labelBancoSID;
    private DataBaseType bancoDadosOrigem;
    private ConexaoBancoDadosUtils conexaoBancoDadosOrigem;
    private DataBaseType tipoBancoDadosOrigem;
    private Connection conexaoOrigem;
    private ObservableList<String> observableListSelecionar = FXCollections.observableArrayList();
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public static void preencherAtributos(AnchorPane anchorpane, TableView tableView, TextField textFieldNome, TextField textFieldTabela, ComboBox tipo, TextField atributo, TextField descricao, TextField tamanho, TextField colunaTabela, TextField linha, TextField coluna, boolean obrigatorio, boolean colunaGrid, boolean pesquisa, boolean addView) throws IOException {
        if (stage == null) {
            stage = new Stage();
            Parent root = (Parent)FXMLLoader.load(ImportaTabelaController.class.getResource("/fxml/ImportaTabelaController.fxml"));
            stage.setScene(new Scene(root));
            stage.setTitle("Conex\u00e3o Banco de Dados");
            stage.initModality(Modality.APPLICATION_MODAL);
        }
        stage.showAndWait();
        String idColunaMestre = "ID_" + CharacterUtils.removeCharEspecial(nomeTabela).replace("TB_", "").toUpperCase();
        StringBuilder erro = new StringBuilder();
        listaCamposRetorno.stream().sorted(Comparator.comparing(ColumnDataBase::getPosition)).forEach(columnDataBase -> {
            if (columnDataBase.getName().toUpperCase().equals(idColunaMestre)) {
                return;
            }
            tipo.setValue(columnDataBase.getType());
            if (columnDataBase.getType() == FieldType.ENTITY) {
                atributo.setText(columnDataBase.getName().substring(3));
                descricao.setText(columnDataBase.getName().substring(3));
                tamanho.setText("" + columnDataBase.getType().getWidthXhtml());
            } else {
                String nome = columnDataBase.getName().length() > 2 && columnDataBase.getName().substring(2, 3).equals("_") ? columnDataBase.getName().substring(3, 4).toUpperCase() + columnDataBase.getName().substring(4) : columnDataBase.getName().substring(0, 1).toUpperCase() + columnDataBase.getName().substring(1);
                atributo.setText(columnDataBase.getType().getAttribute() + nome);
                descricao.setText(columnDataBase.getType().getDescription() + " " + nome);
                tamanho.setText("" + columnDataBase.getType().getWidthXhtml());
            }
            colunaTabela.setText(columnDataBase.getName());
            LogicaUtils.ajustaPropriedadesConformeNomeAtributo(tipo, colunaTabela, descricao, atributo.getText());
            try {
                TableViewUtils.adicionaGrid(anchorpane, tableView, tipo, atributo.getText(), colunaTabela.getText(), descricao.getText(), tamanho.getText(), linha, coluna, obrigatorio, colunaGrid, pesquisa, addView, ignorePatterns);
            }
            catch (Exception ex) {
                erro.append("\n");
                erro.append("\t");
                erro.append(ex.getMessage());
            }
        });
        if (!erro.toString().isEmpty()) {
            MensagemView.getInstancia().showMessageError(anchorpane, "Atributo(s) j\u00e1 adicionado: " + erro.toString());
        }
        if (nomeTabela != null && nomeTabela.length() > 4) {
            textFieldNome.setText(nomeTabela.substring(3, 4).toUpperCase() + nomeTabela.substring(4).toLowerCase());
            textFieldTabela.setText(nomeTabela.toLowerCase());
        }
        listaCamposRetorno.clear();
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.conexaoBancoDadosOrigem = new ConexaoBancoDadosUtils();
        ArrayList<String> list = new ArrayList<String>();
        list.add(DataBaseType.ORACLE.name());
        list.add(DataBaseType.POSTGRESQL.name());
        ObservableList observableList = FXCollections.observableList(list);
        this.cmbOrigem.setItems(observableList);
        this.cmbOrigem.getSelectionModel().select(1);
        ChangeListener<String> changeListener = (arg0, oldPropertyValue, newPropertyValue) -> this.ajustaStringConexao();
        this.cmbOrigem.valueProperty().addListener(changeListener);
        this.txtfldBancoDados.textProperty().addListener(changeListener);
        this.txtfldIP.textProperty().addListener(changeListener);
        this.txtfldPorta.textProperty().addListener(changeListener);
        this.txtfldSchemaOrigem.textProperty().addListener(changeListener);
        this.lstviewSelecionar.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public void btnConectarOrigemAction(ActionEvent actionEvent) {
        try {
            this.conectarOrigem();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Erro Conex\u00e3o", 0);
        }
    }

    public void ajustaStringConexao() {
        this.bancoDadosOrigem = DataBaseType.valueOf(this.cmbOrigem.getSelectionModel().getSelectedItem().toString());
        this.labelBancoSID.setText(this.bancoDadosOrigem.name().equals("ORACLE") ? "SID/Service Name" : "Banco de Dados");
        if (this.bancoDadosOrigem == null) {
            return;
        }
        if (this.bancoDadosOrigem.equals((Object)DataBaseType.POSTGRESQL)) {
            if (this.txtfldPorta.getText().equals("1521")) {
                this.txtfldPorta.setText("5432");
            }
        } else if (this.bancoDadosOrigem.equals((Object)DataBaseType.ORACLE) && this.txtfldPorta.getText().equals("5432")) {
            this.txtfldPorta.setText("1521");
        }
        Object stringConexao = "jdbc:";
        stringConexao = (String)stringConexao + this.bancoDadosOrigem.name().toLowerCase() + ":";
        stringConexao = this.bancoDadosOrigem == DataBaseType.ORACLE ? (String)stringConexao + "thin:@" : (String)stringConexao + "//";
        stringConexao = (String)stringConexao + this.txtfldIP.getText() + ":";
        stringConexao = (String)stringConexao + this.txtfldPorta.getText();
        stringConexao = this.bancoDadosOrigem == DataBaseType.ORACLE ? (String)stringConexao + ":" : (String)stringConexao + "/";
        stringConexao = (String)stringConexao + this.txtfldBancoDados.getText();
        this.txtareaStringConexaoOrigem.setText((String)stringConexao);
    }

    public void btnProcessarAction(ActionEvent actionEvent) {
        ignorePatterns = this.checkBoxTabelaForaPadrao.isSelected();
        if (this.conexaoOrigem == null) {
            JOptionPane.showMessageDialog(null, "Favor verificar a Conex\u00e3o");
        } else if (this.observableListSelecionar.size() == 0) {
            JOptionPane.showMessageDialog(null, "N\u00e3o existe tabela para o processamento");
        } else if (this.lstviewSelecionar.getSelectionModel().getSelectedIndices().size() == 0) {
            JOptionPane.showMessageDialog(null, "Favor selecionar uma tabela");
        } else if (this.lstviewSelecionar.getSelectionModel().getSelectedIndices().size() > 1) {
            JOptionPane.showMessageDialog(null, "Selecionar somente uma tabela");
        } else {
            nomeTabela = this.lstviewSelecionar.getSelectionModel().getSelectedItem().toString().toUpperCase();
            SqlUtils.Dados dados = null;
            try {
                dados = this.bancoDadosOrigem == DataBaseType.ORACLE ? SqlUtils.selecionar(this.conexaoOrigem, "SELECT LOWER(A.COLUMN_NAME) AS COLUNA FROM DBA_TAB_COLUMNS A INNER JOIN DBA_TABLES B ON A.OWNER = B.OWNER AND A.TABLE_NAME = B.TABLE_NAME WHERE UPPER(A.OWNER) = '" + this.txtfldSchemaOrigem.getText().toUpperCase() + "' AND       UPPER(A.TABLE_NAME) = '" + nomeTabela.toUpperCase() + "'", new Object[0]) : SqlUtils.selecionar(this.conexaoOrigem, "SELECT LOWER(A.ATTNAME) AS COLUNA FROM PG_ATTRIBUTE AS A JOIN PG_CLASS AS C ON C.OID = A.ATTRELID AND C.RELNAME !~ '^pg_' WHERE A.ATTNUM > 0 AND       UPPER(C.RELNAME) = UPPER('" + nomeTabela + "') ", new Object[0]);
                int posicao = 0;
                listaCamposRetorno.clear();
                while (dados.getResultSet().next()) {
                    String nomeColuna = dados.getResultSet().getString("COLUNA");
                    if (Arrays.stream(CAMPOS_ARCH).anyMatch(c -> c.equals(nomeColuna.toUpperCase()))) continue;
                    ColumnDataBase columnDataBase = new ColumnDataBase();
                    columnDataBase.setPosition(posicao++);
                    columnDataBase.setName(nomeColuna);
                    if (nomeColuna.contains("cpfcnpj")) {
                        columnDataBase.setType(FieldType.CPFCNPJ);
                    } else if (nomeColuna.contains("cnpj")) {
                        columnDataBase.setType(FieldType.CNPJ);
                    } else if (nomeColuna.contains("cpf")) {
                        columnDataBase.setType(FieldType.CPF);
                    } else if (nomeColuna.contains("_rg")) {
                        columnDataBase.setType(FieldType.RG);
                    } else if (nomeColuna.contains("telefone")) {
                        columnDataBase.setType(FieldType.TELEPHONE);
                    } else if (nomeColuna.startsWith("nr_")) {
                        columnDataBase.setType(FieldType.NUMBER);
                    } else {
                        Optional<FieldType> fieldTypeOptional = Arrays.stream(FieldType.values()).filter(c -> c.getNameColumnDatabase().length() > 2 && nomeColuna.length() > 2 && c.getNameColumnDatabase().substring(0, 3).toLowerCase().equals(nomeColuna.substring(0, 3).toLowerCase())).findFirst();
                        if (fieldTypeOptional.isPresent()) {
                            columnDataBase.setType(fieldTypeOptional.get());
                        } else if (nomeColuna.toLowerCase().contains("data")) {
                            columnDataBase.setType(FieldType.DATE);
                        } else if (nomeColuna.toLowerCase().contains("valor")) {
                            columnDataBase.setType(FieldType.MONEY);
                        } else {
                            columnDataBase.setType(FieldType.GENERIC);
                        }
                    }
                    listaCamposRetorno.add(columnDataBase);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dados.fechar();
            this.observableListSelecionar.clear();
            stage.close();
        }
    }

    private void conectarOrigem() throws Exception {
        this.bancoDadosOrigem = DataBaseType.valueOf(this.cmbOrigem.getSelectionModel().getSelectedItem().toString());
        if (this.txtareaStringConexaoOrigem.getText().equals("")) {
            throw new Exception("Digite a String de Conex\u00e3o");
        }
        if (this.txtfldUsuarioOrigem.getText().equals("")) {
            throw new Exception("Digite o Usu\u00e1rio");
        }
        if (this.pwdfldSenhaOrigem.getText().equals("")) {
            throw new Exception("Digite a Senha");
        }
        ConexaoBancoDadosUtils conexao = new ConexaoBancoDadosUtils();
        conexao.setTipo(this.bancoDadosOrigem);
        conexao.setStringConexao(this.txtareaStringConexaoOrigem.getText());
        conexao.setUsuario(this.txtfldUsuarioOrigem.getText());
        conexao.setSenha(this.pwdfldSenhaOrigem.getText());
        this.conexaoOrigem = conexao.conectar();
        this.carregarTabelas();
    }

    public void carregarTabelas() {
        this.observableListSelecionar.clear();
        this.lstviewSelecionar.setItems(this.observableListSelecionar);
        SqlUtils.Dados dados = null;
        try {
            dados = this.bancoDadosOrigem == DataBaseType.POSTGRESQL ? SqlUtils.selecionar(this.conexaoOrigem, "SELECT TABLENAME AS TABLE_NAME FROM PG_TABLES WHERE SCHEMANAME = '" + this.txtfldSchemaOrigem.getText() + "' " + (this.checkBoxTabelaForaPadrao.isSelected() ? "" : "      AND UPPER(TABLENAME) LIKE 'TB_%' ") + "ORDER BY TABLENAME", new Object[0]) : SqlUtils.selecionar(this.conexaoOrigem, "SELECT B.TABLE_NAME AS TABLE_NAME FROM DBA_TABLES B WHERE UPPER(B.OWNER) = '" + this.txtfldSchemaOrigem.getText().toUpperCase() + "' " + (this.checkBoxTabelaForaPadrao.isSelected() ? "" : "      AND UPPER(B.TABLE_NAME) LIKE 'TB_%' ") + "ORDER BY B.TABLE_NAME", new Object[0]);
            while (dados.getResultSet().next()) {
                this.observableListSelecionar.add(dados.getResultSet().getString("table_name"));
            }
            if (this.observableListSelecionar.size() == 0) {
                JOptionPane.showMessageDialog(null, "N\u00e3o existe tabelas no banco de dados selecionado", "BANCO DADOS VAZIO", 0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Erro Conex\u00e3o", 0);
        }
        finally {
            if (dados != null) {
                dados.fechar();
            }
        }
    }

    public void cursorWait(MouseEvent mouseEvent) {
    }

    public String getSchemaNomeTabelaOrigem(String nomeTabela) {
        return this.txtfldSchemaOrigem.getText() + "." + nomeTabela;
    }

    static {
        listaCamposRetorno = new ArrayList<ColumnDataBase>();
    }
}

