/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.jpa.api.JoinFetch;
import br.com.jarch.core.jpa.param.ParamFieldValue;
import br.com.jarch.core.jpa.param.ParamFieldValues;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.model.type.OrderType;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.util.JpaUtils;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;

public class JpqlUtils {
    private JpqlUtils() {
    }

    public static String from(Class<?> clazz, Collection<JoinFetch<?>> joinFetches) {
        if (joinFetches == null) {
            joinFetches = Collections.emptyList();
        }
        return "FROM " + JpaUtils.nameEntity(clazz) + " " + JpqlUtils.aliasEntity(clazz) + " " + joinFetches.stream().map(joinFetch -> (joinFetch.isLeft() ? "LEFT " : "") + "JOIN FETCH " + joinFetch.getFromAlias().orElse(JpqlUtils.aliasEntity(clazz)) + "." + joinFetch.getField() + " " + joinFetch.getNewAlias().orElse(joinFetch.getField().replaceAll("\\.", ""))).collect(Collectors.joining(" "));
    }

    public static String from(Class<?> clazz) {
        return "FROM " + JpaUtils.nameEntity(clazz) + " " + JpqlUtils.aliasEntity(clazz) + " ";
    }

    public static String groupBy(Collection<String> fields) {
        if (fields == null) {
            return "";
        }
        String listFields = fields.stream().filter(f -> f != null && !f.isEmpty()).collect(Collectors.joining(", "));
        if (listFields.isEmpty()) {
            return "";
        }
        return "GROUP BY " + listFields;
    }

    public static String having(Class<?> clazzEntity, ParamFieldValues paramFieldValues, Collection<JoinFetch<?>> joinsFetchs) {
        Collection<String> aliases = JpqlUtils.aliases(joinsFetchs);
        StringBuilder commandJpqlResult = new StringBuilder();
        for (ParamFieldValue paramFieldValue : paramFieldValues.get()) {
            if (commandJpqlResult.length() > 0) {
                commandJpqlResult.append(" ").append((Object)paramFieldValue.getOperator());
            }
            if (commandJpqlResult.length() > 0 && !commandJpqlResult.toString().endsWith(" ")) {
                commandJpqlResult.append(" ");
            }
            commandJpqlResult.append(paramFieldValue.getStartOperatorLogic());
            commandJpqlResult.append(paramFieldValue.getConditionSearch().generateConditionWhereJpql(clazzEntity, paramFieldValue, aliases));
            commandJpqlResult.append(paramFieldValue.getEndOperatorLogic());
        }
        if (commandJpqlResult.length() > 0) {
            commandJpqlResult.insert(0, "HAVING ");
        }
        return commandJpqlResult.toString();
    }

    public static String selectCount(Class<?> clazzEntity) {
        return JpqlUtils.selectCount(JpqlUtils.aliasEntity(clazzEntity));
    }

    public static String selectCount(String alias) {
        return "SELECT COUNT(DISTINCT " + alias + ")";
    }

    public static String selectCount() {
        return "SELECT COUNT(*)";
    }

    public static String orderBy(Class<?> clazzEntity, FieldOrder fieldOrder) {
        return JpqlUtils.orderBy(clazzEntity, Collections.singletonList(fieldOrder));
    }

    public static String orderBy(Class<?> clazzEntity, Collection<FieldOrder> fieldOrders) {
        if (fieldOrders.isEmpty()) {
            return "";
        }
        String prefixEntityMain = JpqlUtils.aliasEntity(clazzEntity) + ".";
        return "ORDER BY " + fieldOrders.stream().map(f -> (f.isAddPrefix() && !f.getField().contains(prefixEntityMain) ? prefixEntityMain : "") + f.getField() + " " + (OrderType.ASC.equals((Object)f.getOrder()) ? "" : "DESC")).collect(Collectors.joining(", "));
    }

    public static String where(Class<?> clazzEntity, ParamFieldValues paramFieldValues) {
        return JpqlUtils.where(clazzEntity, paramFieldValues, Collections.emptyList());
    }

    public static String where(Class<?> clazzEntity, ParamFieldValues paramFieldValues, Collection<JoinFetch<?>> joinsFetchs) {
        Collection<String> aliases = JpqlUtils.aliases(joinsFetchs);
        StringBuilder commandJpaReturn = new StringBuilder();
        for (ParamFieldValue paramFieldValue : paramFieldValues.get()) {
            if (commandJpaReturn.length() > 0) {
                commandJpaReturn.append(" ").append((Object)paramFieldValue.getOperator());
            }
            if (commandJpaReturn.length() > 0 && !commandJpaReturn.toString().endsWith(" ")) {
                commandJpaReturn.append(" ");
            }
            commandJpaReturn.append(paramFieldValue.getStartOperatorLogic());
            String clause = paramFieldValue.getConditionSearch().generateConditionWhereJpql(clazzEntity, paramFieldValue, aliases);
            commandJpaReturn.append(clause);
            commandJpaReturn.append(paramFieldValue.getEndOperatorLogic());
        }
        if (commandJpaReturn.length() > 0) {
            commandJpaReturn.insert(0, "WHERE ");
        }
        return commandJpaReturn.toString();
    }

    public static boolean isOracle() {
        return JpqlUtils.isDataBase("oracle");
    }

    public static boolean isPostgreSql() {
        return JpqlUtils.isDataBase("postgresql");
    }

    private static boolean isDataBase(String dataBase) {
        EntityManagerFactory entityManagerFactory = ((EntityManager)CDI.current().select(EntityManager.class, new Annotation[0]).get()).getEntityManagerFactory();
        return entityManagerFactory.getProperties().entrySet().stream().filter(es -> ((String)es.getKey()).equals("javax.persistence.jdbc.driver") || ((String)es.getKey()).equals("hibernate.connection.driver_class") || ((String)es.getKey()).equals("eclipselink.target-database")).filter(es -> es.getValue().toString().contains(dataBase.toLowerCase())).map(Map.Entry::getValue).findAny().isPresent();
    }

    public static Connection getConnection(EntityManager entityManager) {
        Session hibernateSession = (Session)entityManager.unwrap(Session.class);
        try {
            return ((SessionImpl)hibernateSession).connection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<String> aliases(Collection<JoinFetch<?>> joinFetchs) {
        Set<String> result = joinFetchs.stream().filter(jf -> jf.getFromAlias().isPresent()).map(jf -> jf.getFromAlias().get()).collect(Collectors.toSet());
        result.addAll(joinFetchs.stream().filter(jf -> jf.getNewAlias().isPresent()).map(jf -> jf.getNewAlias().get()).collect(Collectors.toSet()));
        return result;
    }

    public static String aliasEntity(Class<?> clazzEntity) {
        Entity anotacao = clazzEntity.getAnnotation(Entity.class);
        return anotacao == null || anotacao.name() == null || anotacao.name().isEmpty() ? clazzEntity.getSimpleName() : anotacao.name();
    }

    public static String attributeId(Class<?> clazzEntity) {
        return Arrays.stream(clazzEntity.getDeclaredFields()).filter(f -> f.isAnnotationPresent(EmbeddedId.class)).map(f -> JpqlUtils.aliasEntity(clazzEntity) + "." + f.getName()).findAny().orElse(JpqlUtils.aliasEntity(clazzEntity));
    }

    public static String chainFields(Attribute<?, ?> ... fields) {
        return Arrays.stream(fields).map(Attribute::getName).collect(Collectors.joining("."));
    }

    public static void addValueParam(Query query, ParamFieldValues paramFieldValues) {
        JpqlUtils.setParamValue(query, paramFieldValues);
    }

    public static void addValueParam(Query query, Map<String, Object> paramValues) {
        paramValues.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }

    private static void setParamValue(Query query, ParamFieldValues paramFieldValues) {
        paramFieldValues.get().stream().filter(p -> !ConditionSearchType.JPQL.equals((Object)p.getConditionSearch())).filter(p -> !ConditionSearchType.CONTAINS.equals((Object)p.getConditionSearch())).filter(ParamFieldValue::isHasParam).forEach(p -> JpaUtils.setParameter(query, p.getNameParameterJpql(), p.getValue()));
        paramFieldValues.get().stream().filter(p -> ConditionSearchType.JPQL.equals((Object)p.getConditionSearch())).forEach(p -> {
            if (p.getValue() != null) {
                JpaUtils.setParameter(query, p.getNameParameterJpql(), p.getValue());
            }
            p.getParamValue().forEach((key, value) -> JpaUtils.setParameter(query, key, value));
        });
        paramFieldValues.get().stream().filter(p -> ConditionSearchType.CONTAINS.equals((Object)p.getConditionSearch())).forEach(p -> {
            if (p.getValue() != null) {
                JpaUtils.setParameterLike(query, p.getNameParameterJpql(), p.getValue());
            }
            p.getParamValue().forEach((key, value) -> JpaUtils.setParameterLike(query, key, value));
        });
    }
}

