/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.model.IBaseMultiTenantEntity;
import br.com.jarch.core.model.ICrudMultiTenantEntity;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.model.MultiTenant;
import javax.persistence.EntityManager;
import org.hibernate.Session;

public class EntityManagerFilterUtils {
    public static void addFilters(EntityManager entityManager, Class<? extends IIdentity> classEntity) {
        EntityManagerFilterUtils.applyFilterMultiTenant(entityManager, classEntity);
        EntityManagerFilterUtils.applyFilterExclusionLogic(entityManager, classEntity);
    }

    private static void applyFilterExclusionLogic(EntityManager entityManager, Class<? extends IIdentity> classEntity) {
        if (EntityManagerFilterUtils.isEntityExclusionLogic(classEntity) && EntityManagerFilterUtils.isFilterExclusionLogic(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("exclusionLogic");
        }
    }

    private static void applyFilterMultiTenant(EntityManager entityManager, Class<? extends IIdentity> classEntity) {
        if (MultiTenant.getInstance().notExists()) {
            return;
        }
        if (EntityManagerFilterUtils.isEntityMultiTenant(classEntity) && EntityManagerFilterUtils.isFilterEntityMultiTenant(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("tenant").setParameter("tenantId", (Object)MultiTenant.getInstance().get());
        }
    }

    private static boolean isFilterExclusionLogic(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().contains("exclusionLogic");
    }

    private static boolean isEntityExclusionLogic(Class<? extends IIdentity> classEntity) {
        return classEntity.isAnnotationPresent(JArchExclusionLogic.class);
    }

    private static boolean isFilterEntityMultiTenant(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().stream().anyMatch(f -> f.toString().contains("tenant"));
    }

    private static boolean isEntityMultiTenant(Class<? extends IIdentity> classEntity) {
        return IBaseMultiTenantEntity.class.isAssignableFrom(classEntity) || ICrudMultiTenantEntity.class.isAssignableFrom(classEntity);
    }
}

