/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.type;

import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.br.CepUtils;
import br.com.jarch.util.br.CpfCnpjUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum FieldType {
    ADDRESS("endereco", "nm_naoserausado", 1024, 0, 0){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "07191350";
        }

        @Override
        public String getValueCloneTest() {
            return "03928130";
        }

        @Override
        public String getValueChangeTest() {
            return "08215540";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<e:inputAddress id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" style=\"width: 100%\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return "NM_LOGRADOURO VARCHAR(100)" + (required ? " NOT NULL" : "") + ",\n\tNR_LOGRADOURO VARCHAR(20) NULL,\n\tDS_COMPLEMENTO VARCHAR(50) NULL,\n\tNM_BAIRRO VARCHAR(100)" + (required ? " NOT NULL" : "") + ",\n\tNM_MUNICIPIO VARCHAR(100)" + (required ? " NOT NULL" : "") + ",\n\tSG_UF CHAR(2)" + (required ? " NOT NULL" : "") + ",\n\tNR_CEP CHAR(8)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    BINARY("binario", "bi_", 500, 0, 0){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return byte[].class;
        }

        @Override
        public String getValueInsertTest() {
            return null;
        }

        @Override
        public String getValueCloneTest() {
            return null;
        }

        @Override
        public String getValueChangeTest() {
            return null;
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:fileUpload id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 2.getBundleJsf(attribute) + "\" skinSimple=\"true\" listener=\"#{" + nameController + ".fileUploadListener" + (dataDetail == null || dataDetail.isEmpty() ? nameMaster : dataDetail.replace("dataDetail", "")) + attribute.substring(0, 1).toUpperCase() + attribute.substring(1) + "}\" mode=\"advanced\" allowTypes=\"/(\\.|\\/)(doc|docx|xls|xlsx|pdf|png|jpg|bpm)$/\" auto=\"true\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " BLOB" + (required ? " NOT NULL" : "");
        }
    }
    ,
    BOOLEAN("simNao", "sn_", 80, 1, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return Boolean.class;
        }

        @Override
        public String getValueInsertTest() {
            return "S";
        }

        @Override
        public String getValueCloneTest() {
            return "N";
        }

        @Override
        public String getValueChangeTest() {
            return "N";
        }

        @Override
        public String format(Object value) {
            if (value == null) {
                return "";
            }
            return Boolean.TRUE.equals(value) ? BundleUtils.messageBundle("label.sim") : BundleUtils.messageBundle("label.nao");
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:toggleSwitch id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 3.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CEP("cep", "nr_cep", 100, 8, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "07191350";
        }

        @Override
        public String getValueCloneTest() {
            return "08215540";
        }

        @Override
        public String getValueChangeTest() {
            return "03928130";
        }

        @Override
        public String format(Object value) {
            return CepUtils.formataCep(value == null ? "" : value.toString());
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-cep\" mask=\"99999-999\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 4.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CHIPS("chaves", "gn_", 500, 500, 6){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.contains();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "INS";
        }

        @Override
        public String getValueCloneTest() {
            return "CLN";
        }

        @Override
        public String getValueChangeTest() {
            return "CHN";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:chips id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"chips-key\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 5.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CODE("codigo", "cd_", 100, 20, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "INS";
        }

        @Override
        public String getValueCloneTest() {
            return "CLN";
        }

        @Override
        public String getValueChangeTest() {
            return "CHN";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-code\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 6.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CNPJ("cnpj", "nr_cnpj", 125, 14, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "00000000000272";
        }

        @Override
        public String getValueCloneTest() {
            return "00000000000353";
        }

        @Override
        public String getValueChangeTest() {
            return "00000000000434";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : CpfCnpjUtils.formataCnpj(value.toString());
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-cnpj\" mask=\"99.999.999/9999-99\" maxlength=\"18\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 7.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CPF("cpf", "nr_cpf", 100, 11, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "00000000191";
        }

        @Override
        public String getValueCloneTest() {
            return "00000000272";
        }

        @Override
        public String getValueChangeTest() {
            return "00000000353";
        }

        @Override
        public String format(Object value) {
            return CpfCnpjUtils.formataCpf(value == null ? "" : value.toString());
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-cpf\" mask=\"999.999.999-99\" maxlength=\"14\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 8.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CNPJ_BASE("cnpjBase", "nr_cnpjbase", 80, 10, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "00000191";
        }

        @Override
        public String getValueCloneTest() {
            return "00000272";
        }

        @Override
        public String getValueChangeTest() {
            return "00000353";
        }

        @Override
        public String format(Object value) {
            return CpfCnpjUtils.formataCnpjBase(value == null ? "" : value.toString());
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-cnpj-base\" mask=\"99.999.999\" maxlength=\"10\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 9.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CPFCNPJ("cpfCnpj", "nr_cpfcnpj", 125, 14, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "00000000000191";
        }

        @Override
        public String getValueCloneTest() {
            return "00000000000272";
        }

        @Override
        public String getValueChangeTest() {
            return "00000000000353";
        }

        @Override
        public String format(Object value) {
            return CpfCnpjUtils.formataCpfCnpj(value == null ? "" : value.toString());
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-cpf-cnpj\" maxlength=\"18\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 10.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\" onkeypress=\"formatCpfCnpj(this, cpfCnpj)\" onblur=\"formatCpfCnpj(this, cpfCnpj)\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    MONTH_YEAR("competencia", "am_competencia", 100, 7, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return YearMonth.class;
        }

        @Override
        public String getValueInsertTest() {
            return YearMonth.now().format(DateTimeFormatter.ofPattern(FieldType.MM_YYYY));
        }

        @Override
        public String getValueCloneTest() {
            return YearMonth.now().minusMonths(1L).format(DateTimeFormatter.ofPattern(FieldType.MM_YYYY));
        }

        @Override
        public String getValueChangeTest() {
            return YearMonth.now().minusMonths(2L).format(DateTimeFormatter.ofPattern(FieldType.MM_YYYY));
        }

        @Override
        public String format(Object value) {
            if (value == null) {
                return "";
            }
            if (Date.class.isAssignableFrom(value.getClass())) {
                return new SimpleDateFormat(FieldType.MM_YYYY).format(value);
            }
            if (YearMonth.class.isAssignableFrom(value.getClass())) {
                return ((YearMonth)value).format(DateTimeFormatter.ofPattern(FieldType.MM_YYYY));
            }
            if (LocalDate.class.isAssignableFrom(value.getClass())) {
                return ((LocalDate)value).format(DateTimeFormatter.ofPattern(FieldType.MM_YYYY));
            }
            return value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:calendar id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" pattern=\"MM/yyyy\" locale=\"pt_BR\" mask=\"true\" size=\"8\" showOn=\"buttom\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" converter=\"br.com.jarch.faces.converter.yearMonthConverter\" label=\"" + 11.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " DATE" + (required ? " NOT NULL" : "");
        }
    }
    ,
    DATE("data", "dt_", 95, 0, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return LocalDate.class;
        }

        @Override
        public String getValueInsertTest() {
            return LocalDate.now().format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY));
        }

        @Override
        public String getValueCloneTest() {
            return LocalDate.now().minusMonths(1L).format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY));
        }

        @Override
        public String getValueChangeTest() {
            return LocalDate.now().minusMonths(2L).format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY));
        }

        @Override
        public String format(Object value) {
            if (value == null) {
                return "";
            }
            if (LocalTime.class.isAssignableFrom(value.getClass())) {
                return DateUtils.formatHHmm((LocalTime)value);
            }
            if (YearMonth.class.isAssignableFrom(value.getClass())) {
                return DateUtils.formatMMyyyy((YearMonth)value);
            }
            if (LocalDate.class.isAssignableFrom(value.getClass()) && this.equals((Object)MONTH_YEAR)) {
                return DateUtils.formatMMyyyy((LocalDate)value);
            }
            if (Date.class.isAssignableFrom(value.getClass()) && this.equals((Object)MONTH_YEAR)) {
                return DateUtils.formatMMyyyy((Date)value);
            }
            if (Date.class.isAssignableFrom(value.getClass()) && this.equals((Object)DATE_TIME)) {
                return DateUtils.formatddMMyyyyHHmm((Date)value);
            }
            if (Date.class.isAssignableFrom(value.getClass())) {
                return DateUtils.formatddMMyyyy((Date)value);
            }
            if (LocalDate.class.isAssignableFrom(value.getClass())) {
                return DateUtils.formatddMMyyyy((LocalDate)value);
            }
            if (LocalDateTime.class.isAssignableFrom(value.getClass())) {
                return DateUtils.formatddMMyyyyHHmm((LocalDateTime)value);
            }
            return value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:calendar id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 12.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" pattern=\"dd/MM/yyyy\" locale=\"pt_BR\" mask=\"true\" size=\"10\" converter=\"br.com.jarch.faces.converter.localDateConverter\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " DATE" + (required ? " NOT NULL" : "");
        }
    }
    ,
    DATE_TIME("dataHora", "dh_", 150, 0, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return LocalDateTime.class;
        }

        @Override
        public String getValueInsertTest() {
            return LocalDateTime.now().format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY_HH_MM_SS));
        }

        @Override
        public String getValueCloneTest() {
            return LocalDateTime.now().minusMonths(1L).format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY_HH_MM_SS));
        }

        @Override
        public String getValueChangeTest() {
            return LocalDateTime.now().minusMonths(2L).format(DateTimeFormatter.ofPattern(FieldType.DD_MM_YYYY_HH_MM_SS));
        }

        @Override
        public String format(Object value) {
            if (value == null) {
                return "";
            }
            LocalDateTime localDateTime = null;
            if (Date.class.isAssignableFrom(value.getClass())) {
                localDateTime = DateUtils.toLocalDateTime((Date)value);
            } else if (LocalDateTime.class.isAssignableFrom(value.getClass())) {
                localDateTime = (LocalDateTime)value;
            }
            if (localDateTime != null) {
                return DateUtils.formatddMMyyyyHHmmss(localDateTime);
            }
            return String.valueOf(value).replace("to_date('", "").replace("', 'DD/MM/YYYY HH24:MI')", "");
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:calendar id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 13.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" converter=\"br.com.jarch.faces.converter.localDateTimeConverter\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\" pattern=\"dd/MM/yyyy HH:mm:ss\" locale=\"pt_BR\" mask=\"true\" size=\"21\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " TIMESTAMP(6)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    DESCRIPTION("descricaoCompleto", "ds_completa", 500, 500, 6){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.containsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "DESCRIPTION INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "DESCRIPTION CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "DESCRIPTION CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-description-large\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 14.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    SHORT_DESCRIPTION("descricaoResumida", "ds_resumida", 200, 50, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.containsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "DESCRIPTION INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "DESCRIPTION CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "DESCRIPTION CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-description-small\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 15.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    EMAIL("email", "ee_email", 500, 200, 6){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "insert@jarch.com.br";
        }

        @Override
        public String getValueCloneTest() {
            return "clone@jarch.com.br";
        }

        @Override
        public String getValueChangeTest() {
            return "change@jarch.com.br";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-email\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 16.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\" />\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    ENTITY("entidade", "id_", 500, 0, 0){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return Object.class;
        }

        @Override
        public String getValueInsertTest() {
            return "INS";
        }

        @Override
        public String getValueCloneTest() {
            return "CLN";
        }

        @Override
        public String getValueChangeTest() {
            return "CHN";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<e:lookup id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" labelUnique=\"" + 17.getBundleJsf(attribute) + "\" header=\"" + 17.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" actionFilterSelect=\"#{" + attribute + "FilterSelectController}\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\" createExtensionInternal=\"true\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMBER" + (required ? " NOT NULL" : "");
        }
    }
    ,
    ENUMERATED("enumerado", "tp_", 200, 3, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return Void.TYPE;
        }

        @Override
        public String getValueInsertTest() {
            return "TP1";
        }

        @Override
        public String getValueCloneTest() {
            return "TP2";
        }

        @Override
        public String getValueChangeTest() {
            return "TP3";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:selectOneMenu id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" style=\"min-width: 200px\" label=\"" + 18.getBundleJsf(attribute) + "\" value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute, entity) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\">\n" + tabs + "\t\t<f:selectItem itemLabel=\"\"/>\n" + tabs + "\t\t<f:selectItems value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute + "s", entity) + "\" var=\"item\" itemLabel=\"#{item.description}\" itemValue=\"#{item}\"/>\n" + tabs + "\t</a:selectOneMenu>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    GENERIC("generico", "gn_", 500, 100, 0){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.all();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "GENERIC INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "GENERIC CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "GENERIC CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 19.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    HOUR("hora", "hr_", 100, 6, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "10:00:00";
        }

        @Override
        public String getValueCloneTest() {
            return "13:00:00";
        }

        @Override
        public String getValueChangeTest() {
            return "17:00:00";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:calendar id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 20.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" converter=\"br.com.jarch.faces.converter.localTimeConverter\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\" pattern=\"HH:mm:ss\" mask=\"true\" size=\"8\" timerOnly=\"true\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " TIMESTAMP(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    IM("im", "im_", 100, 20, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "111222333";
        }

        @Override
        public String getValueCloneTest() {
            return "444555666";
        }

        @Override
        public String getValueChangeTest() {
            return "777888999";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-im\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 21.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    M2("area", "m2_area", 100, 12, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return BigDecimal.class;
        }

        @Override
        public String getValueInsertTest() {
            return "10";
        }

        @Override
        public String getValueCloneTest() {
            return "25";
        }

        @Override
        public String getValueChangeTest() {
            return "70";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatRate(new BigDecimal(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-m2\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" decimalSeparator=\",\" decimalPlaces=\"6\" label=\"" + 22.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMERIC(" + this.getSizeColumnDatabase() + ", 4)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    MEMO_RICH("memoRich", "mm_", 1024, 4000, 12){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "MEMO INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "MEMO CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "MEMO CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:textEditor id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" readonly=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 23.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" height=\"100\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CLOB" + (required ? " NOT NULL" : "");
        }
    }
    ,
    MEMO_SIMPLE("memo", "mm_", 1024, 4000, 12){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "MEMO INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "MEMO CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "MEMO CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:textEditor id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" readonly=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 24.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" height=\"100\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CLOB" + (required ? " NOT NULL" : "");
        }
    }
    ,
    NAME("nomeCompleto", "nm_completo", 500, 500, 6){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.containsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "NAME INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "NAME CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "NAME CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-description-large\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 25.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    SHORT_NAME("nomeResumido", "nm_resumido", 200, 50, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.containsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "NAME INSERT";
        }

        @Override
        public String getValueCloneTest() {
            return "NAME CLONE";
        }

        @Override
        public String getValueChangeTest() {
            return "NAME CHANGE";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-description-small\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 26.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    NUMBER("numero", "nr_", 50, 0, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return Long.class;
        }

        @Override
        public String getValueInsertTest() {
            return "123";
        }

        @Override
        public String getValueCloneTest() {
            return "456";
        }

        @Override
        public String getValueChangeTest() {
            return "789";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-number\" decimalPlaces=\"0\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 27.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMBER" + (required ? " NOT NULL" : "");
        }
    }
    ,
    PERCENTAGE("percentual", "pc_", 100, 5, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return BigDecimal.class;
        }

        @Override
        public String getValueInsertTest() {
            return "20";
        }

        @Override
        public String getValueCloneTest() {
            return "40";
        }

        @Override
        public String getValueChangeTest() {
            return "80";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatPercent(new BigDecimal(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-percentage\" decimalSeparator=\",\" decimalPlaces=\"6\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 28.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMERIC(" + this.getSizeColumnDatabase() + ", 4)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    QUANTITY("quantidade", "qt_", 50, 0, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return Long.class;
        }

        @Override
        public String getValueInsertTest() {
            return "20";
        }

        @Override
        public String getValueCloneTest() {
            return "40";
        }

        @Override
        public String getValueChangeTest() {
            return "80";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatInteger(Long.valueOf(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-quantity\" decimalPlaces=\"0\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 29.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMBER" + (required ? " NOT NULL" : "");
        }
    }
    ,
    INTEGER("numero", "nr_", 50, 0, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return Integer.class;
        }

        @Override
        public String getValueInsertTest() {
            return "20";
        }

        @Override
        public String getValueCloneTest() {
            return "40";
        }

        @Override
        public String getValueChangeTest() {
            return "80";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatInteger(Long.valueOf(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-quantity\" decimalPlaces=\"0\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 30.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMBER" + (required ? " NOT NULL" : "");
        }
    }
    ,
    MONEY("moeda", "vl_", 120, 19, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return BigDecimal.class;
        }

        @Override
        public String getValueInsertTest() {
            return "1250";
        }

        @Override
        public String getValueCloneTest() {
            return "2500";
        }

        @Override
        public String getValueChangeTest() {
            return "3750";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatMoney(new BigDecimal(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<e:inputTextMoney id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-decimal\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 31.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMERIC(" + this.getSizeColumnDatabase() + ", 2)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    RG("rg", "nr_rg", 100, 20, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "224441112";
        }

        @Override
        public String getValueCloneTest() {
            return "324441112";
        }

        @Override
        public String getValueChangeTest() {
            return "124441112";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputText id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-rg\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 32.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    SEQUENCE("sequencial", "sq_", 50, 0, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return Long.class;
        }

        @Override
        public String getValueInsertTest() {
            return "123";
        }

        @Override
        public String getValueCloneTest() {
            return "456";
        }

        @Override
        public String getValueChangeTest() {
            return "789";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatInteger(Long.valueOf(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-sequence\" decimalPlaces=\"0\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 33.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMBER" + (required ? " NOT NULL" : "");
        }
    }
    ,
    PASSWORD("senha", "cn_senha", 100, 500, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "SENHA1";
        }

        @Override
        public String getValueCloneTest() {
            return "SENHA2";
        }

        @Override
        public String getValueChangeTest() {
            return "SENHA3";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:password id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 34.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    INITIALS("sigla", "sg_", 100, 3, 2){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "SG1";
        }

        @Override
        public String getValueCloneTest() {
            return "SG2";
        }

        @Override
        public String getValueChangeTest() {
            return "SG3";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:selectOneMenu id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" style=\"min-width: 200px\" label=\"" + 35.getBundleJsf(attribute) + "\" value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute, entity) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\">\n" + tabs + "\t\t<f:selectItem itemLabel=\"\"/>\n" + tabs + "\t\t<f:selectItems value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute + "s", entity) + "\" var=\"item\" itemLabel=\"#{item.description}\" itemValue=\"#{item}\"/>\n" + tabs + "\t</a:selectOneMenu>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    STATUS("status", "st_", 200, 3, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "ST1";
        }

        @Override
        public String getValueCloneTest() {
            return "ST2";
        }

        @Override
        public String getValueChangeTest() {
            return "ST3";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:selectOneMenu id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" style=\"min-width: 200px\" label=\"" + 36.getBundleJsf(attribute) + "\" value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute, entity) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\">\n" + tabs + "\t\t<f:selectItem itemLabel=\"\"/>\n" + tabs + "\t\t<f:selectItems value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute + "s", entity) + "\" var=\"item\" itemLabel=\"#{item.description}\" itemValue=\"#{item}\"/>\n" + tabs + "\t</a:selectOneMenu>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    RATE("taxa", "tx_", 100, 12, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.allMinusContainsExistsStartsEnds();
        }

        @Override
        public Class<?> getClassType() {
            return BigDecimal.class;
        }

        @Override
        public String getValueInsertTest() {
            return "10";
        }

        @Override
        public String getValueCloneTest() {
            return "20";
        }

        @Override
        public String getValueChangeTest() {
            return "30";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : NumberUtils.formatRate(new BigDecimal(value.toString()));
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputNumber id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" inputStyleClass=\"input-rate\" decimalSeparator=\",\" decimalPlaces=\"4\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 37.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " NUMERIC(" + this.getSizeColumnDatabase() + ", 4)" + (required ? " NOT NULL" : "");
        }
    }
    ,
    TYPE("tipo", "tp_", 200, 3, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferent();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "TP1";
        }

        @Override
        public String getValueCloneTest() {
            return "TP2";
        }

        @Override
        public String getValueChangeTest() {
            return "TP3";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:selectOneMenu id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" style=\"min-width: 200px\" label=\"" + 38.getBundleJsf(attribute) + "\" value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute, entity) + "\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\">\n" + tabs + "\t\t<f:selectItem itemLabel=\"\"/>\n" + tabs + "\t\t<f:selectItems value=\"" + FieldType.expressionLanguageDataFromAttribute(nameController, attribute + "s", entity) + "\" var=\"item\" itemLabel=\"#{item.description}\" itemValue=\"#{item}\"/>\n" + tabs + "\t</a:selectOneMenu>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " CHAR(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    TELEPHONE("telefone", "nr_telefone", 120, 20, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "1133334444";
        }

        @Override
        public String getValueCloneTest() {
            return "1155556666";
        }

        @Override
        public String getValueChangeTest() {
            return "1177778888";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-phone\" mask=\"(99) 9999-9999\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 39.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    }
    ,
    CELLPHONE("celular", "nr_celular", 120, 20, 3){

        @Override
        public Collection<ConditionSearchType> getConditionals() {
            return ConditionSearchType.equalAndDifferentAndContainsAndStartsAndEnds();
        }

        @Override
        public Class<?> getClassType() {
            return String.class;
        }

        @Override
        public String getValueInsertTest() {
            return "11999991111";
        }

        @Override
        public String getValueCloneTest() {
            return "11999992222";
        }

        @Override
        public String getValueChangeTest() {
            return "11999993333";
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }

        @Override
        public String getTagXhtml(boolean master, String nameController, String nameMaster, String dataDetail, String entity, String attribute, boolean required, String tabs) {
            return "<a:inputMask id=\"" + this.getGenerateId(nameMaster, dataDetail, attribute) + "\" styleClass=\"input-phone\" mask=\"(99) 99999-9999\" disabled=\"" + FieldType.expressionLanguageDisabled(master, nameController, dataDetail) + "\" label=\"" + 40.getBundleJsf(attribute) + "\" value=\"#{" + nameController + "." + entity + "." + attribute + "}\" required=\"" + FieldType.expressionLanguageRequiredField(master, required, nameController, dataDetail) + "\"/>\n";
        }

        @Override
        public String getColumnSqlType(String columnName, boolean required) {
            return columnName.toUpperCase() + " VARCHAR2(" + this.getSizeColumnDatabase() + ")" + (required ? " NOT NULL" : "");
        }
    };

    private static final String DD_MM_YYYY_HH_MM_SS = "dd/MM/yyyy HH:mm:ss";
    private static final String DD_MM_YYYY = "dd/MM/yyyy";
    private static final String MM_YYYY = "MM/yyyy";
    private final String attribute;
    private final String nameColumnDatabase;
    private final Integer widthXhtml;
    private final Integer sizeColumnDataBase;
    private final Integer span;

    private FieldType(String attribute, String nameColumnDatabase, Integer widthXhtml, Integer sizeColumnDatabase, Integer span) {
        this.attribute = attribute;
        this.nameColumnDatabase = nameColumnDatabase;
        this.widthXhtml = widthXhtml;
        this.sizeColumnDataBase = sizeColumnDatabase;
        this.span = span;
    }

    public abstract Collection<ConditionSearchType> getConditionals();

    public abstract Class<?> getClassType();

    public String getName() {
        return this.name();
    }

    public abstract String getValueInsertTest();

    public abstract String getValueCloneTest();

    public abstract String getValueChangeTest();

    public abstract String format(Object var1);

    public abstract String getTagXhtml(boolean var1, String var2, String var3, String var4, String var5, String var6, boolean var7, String var8);

    public abstract String getColumnSqlType(String var1, boolean var2);

    public String getAttribute() {
        return this.attribute;
    }

    public String getDescription() {
        if (this.equals((Object)INTEGER)) {
            return BundleUtils.messageBundle("label.inteiro");
        }
        return BundleUtils.messageBundle("label." + this.attribute);
    }

    public String getNameColumnDatabase() {
        return this.nameColumnDatabase;
    }

    public Integer getWidthXhtml() {
        return this.widthXhtml;
    }

    public Integer getSizeColumnDatabase() {
        return this.sizeColumnDataBase;
    }

    public Integer getSpan() {
        return this.span;
    }

    public boolean isDateTime() {
        return this.equals((Object)DATE) || this.equals((Object)DATE_TIME);
    }

    public boolean isEnum() {
        return this.equals((Object)TYPE) || this.equals((Object)INITIALS) || this.equals((Object)STATUS) || this.equals((Object)ENUMERATED);
    }

    public boolean isGeneric() {
        return this.equals((Object)GENERIC);
    }

    public boolean isAddress() {
        return this.equals((Object)ADDRESS);
    }

    public boolean isNumber() {
        return this.isInteger() || this.isLong() || this.isDecimal();
    }

    public boolean isInteger() {
        return this.equals((Object)INTEGER);
    }

    public boolean isLong() {
        return this.equals((Object)QUANTITY) || this.equals((Object)NUMBER) || this.equals((Object)SEQUENCE);
    }

    public boolean isDecimal() {
        return this.equals((Object)MONEY) || this.equals((Object)PERCENTAGE) || this.equals((Object)RATE) || this.equals((Object)M2);
    }

    public boolean isString() {
        return this.equals((Object)DESCRIPTION) || this.equals((Object)SHORT_DESCRIPTION) || this.equals((Object)NAME) || this.equals((Object)SHORT_NAME);
    }

    public boolean isEntity() {
        return this.equals((Object)ENTITY);
    }

    public static FieldType getDescription(String fieldDescription) {
        return Arrays.stream(FieldType.values()).filter(f -> f.getDescription().equals(fieldDescription)).findAny().orElse(null);
    }

    public static Collection<FieldType> getCollection() {
        return Arrays.stream(FieldType.values()).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getGenerateId(String nameMaster, String dataDetail, String attribute) {
        String prefix = dataDetail == null || dataDetail.isEmpty() ? nameMaster : dataDetail.replace("dataDetail", "");
        prefix = CharacterUtils.onlyNumberOrLetter(CharacterUtils.removeCharEspecial(prefix).replace(" ", ""));
        prefix = StringUtils.capitalize((String)prefix);
        return "id" + prefix + FieldType.getAtributoPrimeiroLetraMaiusculo(attribute);
    }

    public String getStyleAlignText() {
        if (this.isNumber()) {
            return "text-align: right";
        }
        if (this.equals((Object)BOOLEAN) || this.isDateTime()) {
            return "text-align: center";
        }
        return "text-align: left";
    }

    public String getStyleWidth() {
        return "width: " + this.getWidthXhtml() + "px";
    }

    public static String getBundleJsf(String attribute) {
        return "#{e:bundle('label." + attribute + "')}";
    }

    public boolean isCpfCnpj() {
        return this == CPF || this == CPFCNPJ || this == CNPJ || this == CNPJ_BASE;
    }

    private static String getAtributoPrimeiroLetraMaiusculo(String attribute) {
        return attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
    }

    private static String expressionLanguageDisabled(boolean master, String nomeController, String dataDetail) {
        String atributoDisable = master ? "#{" + nomeController + ".blockedMaster}" : "#{" + nomeController + "." + dataDetail + ".blockedDetail}";
        return atributoDisable;
    }

    private static String expressionLanguageDataFromAttribute(String nameController, String attribute, String entity) {
        return "#{" + nameController + "." + entity + "." + attribute + "}";
    }

    private static String expressionLanguageRequiredField(boolean master, boolean required, String nameController, String dataDetail) {
        if (!required) {
            return "false";
        }
        if (master) {
            return "" + required;
        }
        return "#{" + nameController + "." + dataDetail + ".required}";
    }
}

