/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.rs;

import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.UserSystem;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.JsonUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.crypto.spec.SecretKeySpec;
import javax.json.Json;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.bind.DatatypeConverter;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static String generate(String secret, String issuer, LocalDateTime expiration) {
        SignatureAlgorithm algoritimoAssinatura = SignatureAlgorithm.HS512;
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)secret);
        SecretKeySpec key = new SecretKeySpec(apiKeySecretBytes, algoritimoAssinatura.getJcaName());
        JwtBuilder construtor = Jwts.builder().setIssuedAt(DateUtils.toDate(LocalDateTime.now())).setIssuer(issuer).signWith(algoritimoAssinatura, (Key)key).setExpiration(DateUtils.toDate(expiration));
        return construtor.compact();
    }

    public static void validation(String secret, ContainerRequestContext containerRequestContext) {
        try {
            String token = TokenUtils.getTokenFromContainerRequest(containerRequestContext);
            Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secret)).parseClaimsJws(token).getBody();
            if (claims == null) {
                throw new ValidationException("Invalid token");
            }
            TokenUtils.modifyRequestContext(containerRequestContext, claims.getId());
        }
        catch (ExpiredJwtException e) {
            LogUtils.generate(e);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)Json.createObjectBuilder().add("code", Response.Status.UNAUTHORIZED.getStatusCode()).add("message", e.getMessage()).build()).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            LogUtils.generate(e);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Json.createObjectBuilder().add("code", Response.Status.BAD_REQUEST.getStatusCode()).add("message", e.getMessage()).build()).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public static String getIssuer(String secret, String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secret)).parseClaimsJws(token).getBody();
        if (claims == null) {
            throw new ValidationException("Token inv\u00e1lido");
        }
        return claims.getIssuer();
    }

    public static String getTokenUserSystem(String secret) {
        String jsonUsuarioTo = JsonUtils.toJson(UserSystem.get());
        return TokenUtils.generate(secret, jsonUsuarioTo, LocalDate.now().atTime(LocalTime.MAX));
    }

    public static String getTokenUserSystemWithBearer(String secret) {
        String jsonUsuarioTo = JsonUtils.toJson(UserSystem.get());
        String token = TokenUtils.generate(secret, jsonUsuarioTo, LocalDateTime.now().withHour(23).withMinute(59).withSecond(59));
        return "Bearer " + token;
    }

    public static String getTokenFromContainerRequest(ContainerRequestContext containerRequestContext) {
        String xParseSessionToken = containerRequestContext.getHeaderString("X-Parse-Session-Token");
        if (!StringUtils.isNullOrEmpty(xParseSessionToken)) {
            return xParseSessionToken;
        }
        String authorizationHeader = containerRequestContext.getHeaderString("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
            throw new NotAuthorizedException((Object)"Authorization header precisa ser fornecido", new Object[0]);
        }
        return authorizationHeader.substring("Bearer".length()).trim();
    }

    private static void modifyRequestContext(ContainerRequestContext requestContext, final String id) {
        final SecurityContext currentSecurityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return () -> id;
            }

            public boolean isUserInRole(String role) {
                return true;
            }

            public boolean isSecure() {
                return currentSecurityContext.isSecure();
            }

            public String getAuthenticationScheme() {
                return "Bearer";
            }
        });
    }
}

