/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.migration;

import br.com.jarch.core.crud.repository.CrudRepository;
import br.com.jarch.core.crud.service.ICrudService;
import br.com.jarch.core.model.IBaseEntity;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.BundleUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.manager.BeanManagerImpl;

public class Migrated {
    private ICrudEntity classEntity;
    private ICrudService service;
    private CrudRepository repository;
    private List<ICrudEntity> listAvailable = new ArrayList<ICrudEntity>();
    private List<ICrudEntity> listSelected = new ArrayList<ICrudEntity>();

    public Migrated(ICrudEntity classEntity) {
        this.classEntity = classEntity;
    }

    public IBaseEntity getClassEntity() {
        return this.classEntity;
    }

    public void setClassEntity(ICrudEntity classEntity) {
        this.classEntity = classEntity;
    }

    public List<ICrudEntity> getListAvailable() {
        return this.listAvailable;
    }

    public void setListAvailable(List<ICrudEntity> listAvailable) {
        this.listAvailable = listAvailable;
    }

    public List<ICrudEntity> getListSelected() {
        return this.listSelected;
    }

    public void setListSelected(List<ICrudEntity> listSelected) {
        this.listSelected = listSelected;
    }

    public ICrudService getService() {
        this.carregaServiceEDao();
        return this.service;
    }

    public CrudRepository getRepository() {
        this.carregaServiceEDao();
        return this.repository;
    }

    private void carregaServiceEDao() {
        if (this.service == null || this.repository == null) {
            Class<?> repository = null;
            Class<?> service = null;
            BeanManagerProxy beanManagerProxy = (BeanManagerProxy)CDI.current().getBeanManager();
            BeanManagerImpl beanManager = beanManagerProxy.unwrap();
            List listaBean = beanManager.getBeans((Type)((Object)Object.class), new Annotation[0]).stream().filter(bean -> CrudRepository.class.isAssignableFrom(bean.getBeanClass()) || ICrudService.class.isAssignableFrom(bean.getBeanClass())).collect(Collectors.toList());
            for (Bean bean2 : listaBean) {
                ParameterizedType parameterizedType;
                boolean anyMatch;
                if (!ParameterizedType.class.isAssignableFrom(bean2.getBeanClass().getGenericSuperclass().getClass()) || !(anyMatch = Arrays.stream((parameterizedType = (ParameterizedType)bean2.getBeanClass().getGenericSuperclass()).getActualTypeArguments()).anyMatch(type -> this.classEntity.getClass().getName().equals(type.getTypeName())))) continue;
                if (CrudRepository.class.isAssignableFrom(bean2.getBeanClass())) {
                    repository = bean2.getBeanClass();
                }
                if (!ICrudService.class.isAssignableFrom(bean2.getBeanClass())) continue;
                service = bean2.getBeanClass();
            }
            this.service = (ICrudService)CDI.current().select(service, new Annotation[0]).get();
            this.repository = (CrudRepository)CDI.current().select(repository, new Annotation[0]).get();
        }
    }

    public String getNameClassEntity() {
        if (this.classEntity == null) {
            return "";
        }
        String name = this.classEntity.getClass().getSimpleName().substring(0, 1).toLowerCase() + this.classEntity.getClass().getSimpleName().substring(1);
        return BundleUtils.messageBundle("label." + name.replace("Entity", ""));
    }
}

