/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.migration;

import br.com.jarch.core.annotation.JArchValidExclusive;
import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.exception.ExclusiveException;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

final class ExclusiveMigrated {
    private ExclusiveMigrated() {
    }

    public static <E extends IIdentity, R extends BaseRepository<E>> E validationUniqueField(R repository, E entity) {
        try {
            for (Field field : entity.getClass().getDeclaredFields()) {
                JArchValidExclusive annotation = field.getAnnotation(JArchValidExclusive.class);
                if (annotation == null) continue;
                Object value = ReflectionUtils.getValueByField(entity, field);
                return ExclusiveMigrated.validExistsDataBase(repository, entity, field, annotation, value);
            }
        }
        catch (SecurityException ex) {
            throw new ExclusiveException("ERRO VALIDA\u00c7\u00c3O CAMPO: " + ex.getMessage());
        }
        return null;
    }

    private static <E extends IIdentity, R extends BaseRepository<E>> E validExistsDataBase(R repository, E entity, Field field, JArchValidExclusive annotation, Object conteudoAtributo) {
        Object conteudo = conteudoAtributo;
        Collection<E> lista = repository.searchAllBy(Map.of(field.getName(), conteudo), annotation.caseSensitive());
        for (E item : lista) {
            Long id = (Long)ReflectionUtils.getValueByName(item, "id");
            if (item == null || entity.getId() != null && id.longValue() == entity.getId().longValue()) continue;
            return (E)((IIdentity)item);
        }
        return null;
    }
}

