/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.inspect;

import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.jpa.inspect.AnalyzeSqlRequest;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.LogUtils;
import java.util.Locale;

public final class AnalyzeSql {
    private AnalyzeSql() {
    }

    public static void analyzeSelectWithoutFilter(AnalyzeSqlRequest request) {
        if (request == null) {
            return;
        }
        if (AnalyzeSql.isSqlNotSelect(request)) {
            return;
        }
        if (AnalyzeSql.isNotSelectTableSelected(request)) {
            return;
        }
        AnalyzeSql.validExistsClauseWhere(request);
        AnalyzeSql.validFilterExists(request);
    }

    private static void validFilterExists(AnalyzeSqlRequest request) {
        String sql = request.getSql();
        String clauseWhere = sql.substring(sql.indexOf(" where "));
        if (clauseWhere.contains("order by")) {
            clauseWhere = clauseWhere.substring(0, clauseWhere.indexOf("order by"));
        }
        boolean hasFilterField = false;
        for (String column : request.getColumnsRequiredFilter()) {
            hasFilterField |= clauseWhere.contains(column);
        }
        if (!hasFilterField) {
            AnalyzeSql.blockedExecution(sql);
        }
    }

    private static void validExistsClauseWhere(AnalyzeSqlRequest request) {
        String sql = request.getSql();
        if (!sql.contains(" where ")) {
            AnalyzeSql.blockedExecution(sql);
        }
    }

    private static String sqlNormalyze(AnalyzeSqlRequest analiseSqlRequest) {
        return analiseSqlRequest.getSql().toLowerCase(Locale.ROOT).replaceAll("\\s+", " ").trim();
    }

    private static boolean isNotSelectTableSelected(AnalyzeSqlRequest analiseSqlRequest) {
        String sql = AnalyzeSql.sqlNormalyze(analiseSqlRequest);
        String tableName = JpaUtils.tableFullName(analiseSqlRequest.getRepository());
        boolean involvesTable = sql.contains(" " + tableName + " ");
        involvesTable |= sql.endsWith(tableName);
        involvesTable |= sql.contains(" " + tableName + " as ");
        involvesTable |= sql.contains(" from " + tableName + " ");
        return !(involvesTable |= sql.contains(" join " + tableName + " "));
    }

    private static boolean isSqlNotSelect(AnalyzeSqlRequest analiseSqlRequest) {
        String sql = AnalyzeSql.sqlNormalyze(analiseSqlRequest);
        return !sql.startsWith("select");
    }

    private static void blockedExecution(String sql) {
        String message = BundleUtils.messageBundle("message.identificadoProblemaGerenciamentoAplicacao");
        LogUtils.warning(message + "\n\nSQL ANALISAR: " + sql);
        throw new ValidationException(message);
    }
}

