/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.converter;

import java.sql.Date;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneId;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class YearMonthJpaConverter
implements AttributeConverter<YearMonth, Date> {
    public Date convertToDatabaseColumn(YearMonth yearMonth) {
        if (yearMonth == null) {
            return null;
        }
        return Date.valueOf(yearMonth.atDay(1));
    }

    public YearMonth convertToEntityAttribute(Date date) {
        if (date == null) {
            return null;
        }
        return YearMonth.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
    }
}

