/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class LocalTimeJpaConverter
implements AttributeConverter<LocalTime, String> {
    public String convertToDatabaseColumn(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public LocalTime convertToEntityAttribute(String date) {
        if (date == null) {
            return null;
        }
        try {
            return LocalTime.parse(date, DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        catch (Exception ex) {
            return LocalTime.parse(date, DateTimeFormatter.ofPattern("HH:mm"));
        }
    }
}

