/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchFieldCombobox;
import br.com.jarch.core.annotation.JArchSearchTab;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.exception.SearchException;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

final class ComboBoxFieldSearchFactory
extends BaseFieldSearchFactory {
    ComboBoxFieldSearchFactory() {
    }

    void createFieldSearch(Class<?> classEntityOrController, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        this.createFromFields(classEntityOrController, mapFieldSearch);
        this.createFromClass(classEntityOrController, mapFieldSearch);
        this.createFromPackage(classEntityOrController, mapFieldSearch, onlyThisClass);
    }

    private void createFromPackage(Class<?> classControllerOrEntity, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        JArchSearchTab[] searchTabs;
        Class<?> classEntity = this.getClassEntityFrom(classControllerOrEntity);
        this.createFromArray(null, classEntity, (JArchSearchFieldCombobox[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchFieldCombobox.class), mapFieldSearch);
        for (JArchSearchTab searchTab : searchTabs = (JArchSearchTab[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromArray(searchTab, classEntity, searchTab.searchFieldComboboxes(), mapFieldSearch);
        }
        if (onlyThisClass || classEntity.equals(classControllerOrEntity) || classEntity.getPackage().equals(classControllerOrEntity.getPackage())) {
            return;
        }
        this.createFromArray(null, classEntity, (JArchSearchFieldCombobox[])classEntity.getPackage().getAnnotationsByType(JArchSearchFieldCombobox.class), mapFieldSearch);
        for (JArchSearchTab searchTab : searchTabs = (JArchSearchTab[])classEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromArray(searchTab, classEntity, searchTab.searchFieldComboboxes(), mapFieldSearch);
        }
    }

    private void createFromClass(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        Class<?> classEntity = this.getClassEntityFrom(classActionEntity);
        this.createFromArray(null, classEntity, (JArchSearchFieldCombobox[])classActionEntity.getAnnotationsByType(JArchSearchFieldCombobox.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classActionEntity.getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromArray(searchTab, classEntity, searchTab.searchFieldComboboxes(), mapFieldSearch);
        }
    }

    private void createFromFields(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        for (Field field : classActionEntity.getDeclaredFields()) {
            JArchSearchTab[] searchTabs;
            JArchSearchFieldCombobox[] searchFieldComboboxes;
            for (JArchSearchFieldCombobox searchFieldCombobox : searchFieldComboboxes = (JArchSearchFieldCombobox[])field.getAnnotationsByType(JArchSearchFieldCombobox.class)) {
                this.addSearchFieldCombobox(null, classActionEntity, searchFieldCombobox, field, mapFieldSearch);
            }
            for (JArchSearchTab searchTab : searchTabs = (JArchSearchTab[])field.getAnnotationsByType(JArchSearchTab.class)) {
                for (JArchSearchFieldCombobox searchFieldCombobox : searchTab.searchFieldComboboxes()) {
                    this.addSearchFieldCombobox(searchTab, classActionEntity, searchFieldCombobox, field, mapFieldSearch);
                }
            }
        }
    }

    private void createFromArray(JArchSearchTab searchTab, Class<?> classActionEntity, JArchSearchFieldCombobox[] searchFieldComboboxes, Map<String, FieldSearch> mapFieldSearch) {
        Arrays.stream(searchFieldComboboxes).filter(a -> a.classEntity() == classActionEntity || searchTab != null && searchTab.classEntity() == classActionEntity).forEach(a -> {
            Field field = ReflectionUtils.getField(classActionEntity, a.field(), true);
            this.addSearchFieldCombobox(searchTab, classActionEntity, (JArchSearchFieldCombobox)a, field, mapFieldSearch);
        });
    }

    private void addSearchFieldCombobox(JArchSearchTab searchTab, Class<?> classActionEntity, JArchSearchFieldCombobox searchFieldCombobox, Field field, Map<String, FieldSearch> mapFieldSearch) {
        Collection itemsCombobox;
        Object entidadeParcial;
        try {
            if (Boolean.FALSE.equals(searchFieldCombobox.enable().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get())) {
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Class<?> classEntity = searchTab != null && searchTab.classEntity() != Void.TYPE ? searchTab.classEntity() : this.getClassEntityFrom(classActionEntity);
        String fieldNameItems = searchFieldCombobox.fieldItems();
        try {
            entidadeParcial = classEntity.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new SearchException("Erro ao instanciar " + classEntity.getSimpleName() + " para recuperar o atributo " + fieldNameItems);
        }
        Method campoItems = ReflectionUtils.getGetter(entidadeParcial, fieldNameItems);
        if (campoItems == null) {
            throw new SearchException("N\u00e3o localizado o atributo " + fieldNameItems + " em " + entidadeParcial.getClass().getSimpleName());
        }
        try {
            itemsCombobox = (Collection)campoItems.invoke(entidadeParcial, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new SearchException("Erro ao carregar lista de itens do atributo " + fieldNameItems + " em " + entidadeParcial.getClass().getSimpleName());
        }
        String descricao = BundleUtils.messageBundle(searchFieldCombobox.label());
        String fieldName = searchFieldCombobox.field();
        String atributo = fieldName.isEmpty() ? field.getName() : fieldName;
        String id = this.createId(classActionEntity, searchFieldCombobox.id(), atributo, mapFieldSearch);
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchFieldCombobox.class).id(id).clearValueByButton(!searchFieldCombobox.hide()).classAttribute(field.getType()).converterJsf(searchFieldCombobox.converterJsf()).type(FieldType.TYPE).attribute(atributo).description(descricao).condition(ConditionSearchType.EQUAL).visibleCondition(searchFieldCombobox.visibleCondition()).itemsCombobox(itemsCombobox).fieldShowCombobox(searchFieldCombobox.fieldShow()).row(searchFieldCombobox.row()).column(searchFieldCombobox.column()).span(searchFieldCombobox.span()).tabName(searchTab == null ? "label.main" : searchTab.name()).tabOrder(searchTab == null ? 0 : searchTab.order()).labelFirstItem(BundleUtils.messageBundle(searchFieldCombobox.labelFirstItem())).visibleFirstItem(searchFieldCombobox.visibleFirstItem());
        if (searchFieldCombobox.hide()) {
            fieldSearch.hide();
        }
        mapFieldSearch.put(id, fieldSearch);
    }
}

