/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.jparepository;

import br.com.jarch.core.annotation.JArchEventChange;
import br.com.jarch.core.annotation.JArchEventDelete;
import br.com.jarch.core.annotation.JArchEventDynamicAfterQualifier;
import br.com.jarch.core.annotation.JArchEventDynamicBeforeQualifier;
import br.com.jarch.core.annotation.JArchEventInsert;
import br.com.jarch.core.annotation.JArchEventInsertChange;
import br.com.jarch.core.annotation.JArchEventValidChange;
import br.com.jarch.core.annotation.JArchEventValidDelete;
import br.com.jarch.core.annotation.JArchEventValidDynamicQualifier;
import br.com.jarch.core.annotation.JArchEventValidInsert;
import br.com.jarch.core.annotation.JArchEventValidInsertChange;
import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.annotation.JArchValidation;
import br.com.jarch.core.crud.event.EventChangeField;
import br.com.jarch.core.crud.jparepository.BaseJpaRepository;
import br.com.jarch.core.crud.jparepository.ExclusionLogic;
import br.com.jarch.core.crud.jparepository.MasterDetailSetNullId;
import br.com.jarch.core.crud.jparepository.VersionColumnNull;
import br.com.jarch.core.crud.repository.CrudRepository;
import br.com.jarch.core.crud.util.AutoIncrementUtils;
import br.com.jarch.core.crud.validation.BaseValidation;
import br.com.jarch.core.crud.validation.ChangeValidation;
import br.com.jarch.core.crud.validation.DeleteValidation;
import br.com.jarch.core.crud.validation.InsertChangeValidation;
import br.com.jarch.core.crud.validation.InsertValidation;
import br.com.jarch.core.exception.BaseException;
import br.com.jarch.core.exception.ChangeException;
import br.com.jarch.core.exception.DeleteException;
import br.com.jarch.core.exception.InsertException;
import br.com.jarch.core.model.ErroEntityForm;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.MomentType;
import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.util.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.validation.groups.Default;
import org.hibernate.Hibernate;

public abstract class CrudJpaRepository<E extends ICrudEntity>
extends BaseJpaRepository<E>
implements CrudRepository<E> {
    @Inject
    @JArchEventInsert(momentPersist=MomentType.BEFORE)
    private transient Event<E> eventInsertBeforePersist;
    @Inject
    @JArchEventInsert(momentPersist=MomentType.BEFORE)
    private transient Event<E> eventInsertBeforePersistAsync;
    @Inject
    @JArchEventInsert(momentPersist=MomentType.AFTER)
    private transient Event<E> eventInsertAfterPersist;
    @Inject
    @JArchEventInsert(momentPersist=MomentType.AFTER)
    private transient Event<E> eventInsertAfterPersistAsync;
    @Inject
    @JArchEventInsertChange(momentPersistMerge=MomentType.BEFORE)
    private transient Event<E> eventInsertChangeBeforePersistMerge;
    @Inject
    @JArchEventInsertChange(momentPersistMerge=MomentType.BEFORE)
    private transient Event<E> eventInsertChangeBeforePersistMergeAsync;
    @Inject
    @JArchEventInsertChange(momentPersistMerge=MomentType.AFTER)
    private transient Event<E> eventInsertChangeAfterPersistMerge;
    @Inject
    @JArchEventInsertChange(momentPersistMerge=MomentType.AFTER)
    private transient Event<E> eventInsertChangeAfterPersistMergeAsync;
    @Inject
    @JArchEventChange(momentMerge=MomentType.BEFORE)
    private transient Event<E> eventChangeBeforeMerge;
    @Inject
    @JArchEventChange(momentMerge=MomentType.AFTER)
    private transient Event<E> eventChangeAfterMerge;
    @Inject
    @JArchEventDelete(momentRemove=MomentType.BEFORE)
    private transient Event<E> eventDeleteBeforeRemove;
    @Inject
    @JArchEventDelete(momentRemove=MomentType.AFTER)
    private transient Event<E> eventDeleteAfterRemove;
    @Inject
    @JArchEventValidInsert
    private transient Event<E> eventValidInsertNormal;
    @Inject
    @JArchEventValidInsert(dynamic=true)
    private transient Event<E> eventValidInsertDynamic;
    @Inject
    @JArchEventValidChange
    private transient Event<E> eventValidChangeNormal;
    @Inject
    @JArchEventValidChange(dynamic=true)
    private transient Event<E> eventValidChangeDynamic;
    @Inject
    @JArchEventValidDelete
    private transient Event<E> eventValidDeleteNormal;
    @Inject
    @JArchEventValidDelete(dynamic=true)
    private transient Event<E> eventValidDeleteDynamic;
    @Inject
    @JArchEventValidInsertChange
    private transient Event<E> eventValidInsertChangeNormal;
    @Inject
    @JArchEventValidInsertChange(dynamic=true)
    private transient Event<E> eventValidInsertChangeDynamic;
    @Inject
    private transient Event<E> eventDynamic;
    @Inject
    private transient Event<E> event;
    @Inject
    @JArchValidation
    private transient Instance<BaseValidation<E>> allValidations;

    @Override
    @Transactional
    public void insert(E entityInsert) {
        BeanValidationUtils.applyValidation(entityInsert, InsertValidation.class, Default.class);
        BeanValidationUtils.applyValidation(entityInsert, InsertChangeValidation.class, Default.class);
        this.insertRecord(entityInsert, List.of(), List.of());
    }

    @Override
    @Transactional
    public void insert(E entityInsert, Class<?> ... groupBeanValidation) {
        this.insertRecord(entityInsert, Arrays.stream(groupBeanValidation).collect(Collectors.toList()), List.of());
    }

    @Override
    @Transactional
    public void insert(E entityInsert, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        this.insertRecord(entityInsert, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public E change(E entityChange) {
        BeanValidationUtils.applyValidation(entityChange, InsertChangeValidation.class, Default.class);
        BeanValidationUtils.applyValidation(entityChange, ChangeValidation.class, Default.class);
        return this.changeRecord(entityChange, List.of(), List.of());
    }

    @Override
    @Transactional
    public E change(E entityChange, Class<?> ... groupBeanValidation) {
        return this.changeRecord(entityChange, Arrays.stream(groupBeanValidation).collect(Collectors.toList()), List.of());
    }

    @Override
    @Transactional
    public E change(E entityChange, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        return this.changeRecord(entityChange, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public void delete(E entityDelete) {
        BeanValidationUtils.applyValidation(entityDelete, DeleteValidation.class, Default.class);
        this.deleteRecord(entityDelete, List.of(), List.of());
    }

    @Override
    @Transactional
    public void delete(E entityDelete, Class<?> ... groupBeanValidation) {
        this.deleteRecord(entityDelete, Arrays.stream(groupBeanValidation).collect(Collectors.toList()), List.of());
    }

    @Override
    @Transactional
    public void delete(E entityDelete, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        this.deleteRecord(entityDelete, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public void delete(Long id) {
        ICrudEntity entityDelete = (ICrudEntity)this.find(id);
        this.delete(entityDelete);
    }

    @Override
    @Transactional
    public void delete(Long id, Class<?> ... groupBeanValidation) {
        this.deleteRecord((ICrudEntity)this.find(id), Arrays.stream(groupBeanValidation).collect(Collectors.toList()), List.of());
    }

    @Override
    @Transactional
    public void delete(Long id, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        this.deleteRecord((ICrudEntity)this.find(id), groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> insert(Collection<E> entitysInsert, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ArrayList<ErroEntityForm<E>> erros = new ArrayList<ErroEntityForm<E>>();
        for (ICrudEntity e : entitysInsert) {
            try {
                this.insertRecord(e, groupBeanValidation, validations);
            }
            catch (InsertException ex) {
                this.addError(erros, e, ex);
            }
        }
        return erros;
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> change(Collection<E> entitysChange, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ArrayList<ErroEntityForm<E>> erros = new ArrayList<ErroEntityForm<E>>();
        for (ICrudEntity e : entitysChange) {
            try {
                this.changeRecord(e, groupBeanValidation, validations);
            }
            catch (ChangeException ex) {
                this.addError(erros, e, ex);
            }
        }
        return erros;
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> delete(Collection<E> entitysDelete, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ArrayList<ErroEntityForm<E>> erros = new ArrayList<ErroEntityForm<E>>();
        for (ICrudEntity e : entitysDelete) {
            try {
                this.deleteRecord(e, groupBeanValidation, validations);
            }
            catch (DeleteException ex) {
                this.addError(erros, e, ex);
            }
        }
        return erros;
    }

    @Override
    public boolean isExclusionLogic() {
        return this.isExclusionLogic(this.getClassEntity());
    }

    @Override
    @Transactional
    public void refresh(E entity) {
        this.getEntityManager().refresh(entity);
    }

    private boolean isExclusionLogic(Class<?> classEntity) {
        return classEntity.isAnnotationPresent(JArchExclusionLogic.class);
    }

    private <T extends BaseException> void addError(List<ErroEntityForm<E>> erros, E e, T ex) {
        LogUtils.generate(ex);
        ErroEntityForm<E> erro = new ErroEntityForm<E>();
        erro.setException(ex);
        erro.setEntity(e);
        erros.add(erro);
    }

    private void eventValidActionDynamic(E entity) {
        if (this.getIdDynamic() != null && !this.getIdDynamic().isEmpty()) {
            JArchEventValidDynamicQualifier qualifier = new JArchEventValidDynamicQualifier(this.getIdDynamic());
            Event<E> eventQualifier = this.eventDynamic.select(qualifier);
            eventQualifier.fire(entity);
        }
    }

    private void eventBeforeActionDynamic(E entity) {
        if (this.getIdDynamic() != null && !this.getIdDynamic().isEmpty()) {
            JArchEventDynamicBeforeQualifier qualifier = new JArchEventDynamicBeforeQualifier(this.getIdDynamic());
            Event<E> eventQualifier = this.eventDynamic.select(qualifier);
            eventQualifier.fire(entity);
            eventQualifier.fireAsync(entity);
        }
    }

    private void eventAfterActionDynamic(E entity) {
        if (this.getIdDynamic() != null && !this.getIdDynamic().isEmpty()) {
            JArchEventDynamicAfterQualifier qualifier = new JArchEventDynamicAfterQualifier(this.getIdDynamic());
            Event<E> eventQualifier = this.eventDynamic.select(qualifier);
            eventQualifier.fire(entity);
            eventQualifier.fireAsync(entity);
        }
    }

    private void insertRecord(E entityInsert, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        new MasterDetailSetNullId((IIdentity)entityInsert).setNullId();
        CrudJpaRepository.applyInsertBeanValidation(entityInsert, groupBeanValidation.toArray(new Class[0]));
        this.applyValidations(entityInsert, validations);
        this.eventsValidInsert(entityInsert);
        this.eventValidActionDynamic(entityInsert);
        this.eventBeforeActionDynamic(entityInsert);
        this.eventsBeforeInsert(entityInsert);
        AutoIncrementUtils.generateInsert(entityInsert);
        this.getEntityManager().persist(entityInsert);
        this.eventsAfterInsert(entityInsert);
        this.eventAfterActionDynamic(entityInsert);
    }

    private E changeRecord(E entityChange, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        CrudJpaRepository.applyChangeBeanValidation(entityChange, groupBeanValidation.toArray(new Class[0]));
        this.applyValidations(entityChange, validations);
        this.applyValidChange(entityChange);
        this.eventValidActionDynamic(entityChange);
        VersionColumnNull.validationVersionColumnNull(entityChange);
        this.eventBeforeActionDynamic(entityChange);
        this.eventsChangeField(entityChange);
        this.eventsBeforeChange(entityChange);
        AutoIncrementUtils.generateChange(entityChange);
        ICrudEntity entityAfterChanged = (ICrudEntity)this.getEntityManager().merge(entityChange);
        entityAfterChanged.setLogicFrom(entityChange.getLogicFrom().orElse(null));
        this.eventsAfterChange(entityAfterChanged);
        this.eventAfterActionDynamic(entityChange);
        entityAfterChanged = (ICrudEntity)this.loadCrud(entityAfterChanged.getId());
        return (E)entityAfterChanged;
    }

    private void deleteRecord(E entityDelete, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        CrudJpaRepository.applyDeleteBeanValidation(entityDelete, groupBeanValidation.toArray(new Class[0]));
        this.applyValidations(entityDelete, validations);
        this.applyValidDelete(entityDelete);
        this.eventValidActionDynamic(entityDelete);
        this.eventBeforeActionDynamic(entityDelete);
        this.eventsBeforeDelete(entityDelete);
        Object entityDeleteAfter = entityDelete;
        if (this.isExclusionLogic()) {
            ExclusionLogic.removeLogic(this.getEntityManager(), entityDelete);
            entityDeleteAfter = (ICrudEntity)this.getEntityManager().merge(entityDelete);
            entityDeleteAfter.setLogicFrom(entityDelete.getLogicFrom().orElse(null));
        } else {
            this.getEntityManager().remove(this.getEntityManager().getReference(this.getClassEntity(), (Object)entityDelete.getId()));
        }
        this.eventsAfterDelete(entityDeleteAfter);
        this.eventAfterActionDynamic(entityDeleteAfter);
    }

    private static <E extends ICrudEntity> void applyInsertBeanValidation(E entityInsert, Class<?> ... groupBeanValidation) {
        if (groupBeanValidation == null || groupBeanValidation.length == 0) {
            return;
        }
        BeanValidationUtils.applyValidation(entityInsert, groupBeanValidation);
    }

    private void applyValidations(E entityInsert, List<Class<? extends BaseValidation<E>>> validations) {
        validations.forEach(va -> this.allValidations.stream().filter(vl -> va.isAssignableFrom(vl.getClass())).forEach(vl -> vl.valid(entityInsert)));
    }

    private void eventsAfterInsert(E entityInsert) {
        this.eventInsertAfterPersist.fire(entityInsert);
        this.eventInsertAfterPersistAsync.fireAsync(entityInsert);
        this.eventInsertChangeAfterPersistMerge.fire(entityInsert);
        this.eventInsertChangeAfterPersistMergeAsync.fireAsync(entityInsert);
    }

    private void eventsBeforeInsert(E entityInsert) {
        this.eventInsertBeforePersist.fire(entityInsert);
        this.eventInsertBeforePersistAsync.fireAsync(entityInsert);
        this.eventInsertChangeBeforePersistMerge.fire(entityInsert);
        this.eventInsertChangeBeforePersistMergeAsync.fireAsync(entityInsert);
    }

    private void eventsValidInsert(E entityInsert) {
        if (this.getIdDynamic() == null || this.getIdDynamic().isBlank()) {
            this.eventValidInsertNormal.fire(entityInsert);
            this.eventValidInsertChangeNormal.fire(entityInsert);
        } else {
            this.eventValidInsertDynamic.fire(entityInsert);
            this.eventValidInsertChangeDynamic.fire(entityInsert);
        }
    }

    private void eventsAfterChange(E entityAfterChanged) {
        this.eventChangeAfterMerge.fire(entityAfterChanged);
        this.eventChangeAfterMerge.fireAsync(entityAfterChanged);
        this.eventInsertChangeAfterPersistMerge.fire(entityAfterChanged);
        this.eventInsertChangeAfterPersistMerge.fireAsync(entityAfterChanged);
    }

    private void eventsBeforeChange(E entityChange) {
        this.eventInsertChangeBeforePersistMerge.fire(entityChange);
        this.eventInsertChangeBeforePersistMerge.fireAsync(entityChange);
        this.eventChangeBeforeMerge.fire(entityChange);
        this.eventChangeBeforeMerge.fireAsync(entityChange);
    }

    private void eventsChangeField(E entityChange) {
        ICrudEntity entityOld = (ICrudEntity)this.loadCrud(entityChange.getId(), "JARCH_EVENT_FIELD_CHANGE");
        if (entityOld != null) {
            if (!entityOld.getClass().equals(entityChange.getClass())) {
                entityOld = (ICrudEntity)Hibernate.unproxy((Object)entityOld);
            }
            entityChange.setCrudEntityBefore(entityOld);
            EventChangeField.fireValid(this.event, entityOld, entityChange);
            EventChangeField.fire(this.event, entityOld, entityChange);
            EventChangeField.fireAsync(this.event, entityOld, entityChange);
        }
    }

    private void applyValidChange(E entityChange) {
        if (this.getIdDynamic() == null || this.getIdDynamic().isBlank()) {
            this.eventValidChangeNormal.fire(entityChange);
            this.eventValidInsertChangeNormal.fire(entityChange);
        } else {
            this.eventValidChangeDynamic.fire(entityChange);
            this.eventValidInsertChangeDynamic.fire(entityChange);
        }
    }

    private static <E extends ICrudEntity> void applyChangeBeanValidation(E entityChange, Class<?> ... groupBeanValidation) {
        if (groupBeanValidation == null || groupBeanValidation.length == 0) {
            return;
        }
        BeanValidationUtils.applyValidation(entityChange, groupBeanValidation);
    }

    private void eventsAfterDelete(E entityDeleteAfter) {
        this.eventDeleteAfterRemove.fire(entityDeleteAfter);
        this.eventDeleteAfterRemove.fireAsync(entityDeleteAfter);
    }

    private void eventsBeforeDelete(E entityDelete) {
        this.eventDeleteBeforeRemove.fire(entityDelete);
        this.eventDeleteBeforeRemove.fireAsync(entityDelete);
    }

    private void applyValidDelete(E entityDelete) {
        if (this.getIdDynamic() == null || this.getIdDynamic().isBlank()) {
            this.eventValidDeleteNormal.fire(entityDelete);
        } else {
            this.eventValidDeleteDynamic.fire(entityDelete);
        }
    }

    private static <E extends ICrudEntity> void applyDeleteBeanValidation(E entityDelete, Class<?> ... groupBeanValidation) {
        if (groupBeanValidation == null || groupBeanValidation.length == 0) {
            return;
        }
        BeanValidationUtils.applyValidation(entityDelete, groupBeanValidation);
    }
}

