/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.event;

import br.com.jarch.core.annotation.JArchEventChangeFieldQualifier;
import br.com.jarch.core.annotation.JArchEventValidChangeFieldQualifier;
import br.com.jarch.core.crud.util.RemoveMasksUtils;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;

public final class EventChangeField {
    private EventChangeField() {
    }

    public static <T extends ICrudEntity> void fireValid(Event<T> event, T entityOld, T entityNew) {
        EventChangeField.fieldsChange(entityOld, entityNew).forEach(f -> {
            JArchEventValidChangeFieldQualifier annotation = new JArchEventValidChangeFieldQualifier(f.getName()){};
            Event<ICrudEntity> eventQualifier = event.select(annotation);
            eventQualifier.fire(entityNew);
        });
    }

    public static <T> void fire(Event<T> event, T entityOld, T entityNew) {
        EventChangeField.fieldsChange(entityOld, entityNew).forEach(f -> {
            JArchEventChangeFieldQualifier annotation = new JArchEventChangeFieldQualifier(f.getName()){};
            Event<Object> eventQualifier = event.select(annotation);
            eventQualifier.fire(entityNew);
        });
    }

    public static <T> void fireAsync(Event<T> event, T entityOld, T entityNew) {
        EventChangeField.fieldsChange(entityOld, entityNew).forEach(f -> {
            JArchEventChangeFieldQualifier annotation = new JArchEventChangeFieldQualifier(f.getName()){};
            Event eventQualifier = event.select(annotation);
            eventQualifier.fireAsync(entityNew);
        });
    }

    private static <T> List<Field> fieldsChange(T t1, T t2) {
        RemoveMasksUtils.removeMaskAllFields(t1);
        RemoveMasksUtils.removeMaskAllFields(t2);
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : ReflectionUtils.getListFields(t2, true, true)) {
            if (!JpaUtils.isObjectInitialize(t1, field) || !JpaUtils.isObjectInitialize(t2, field)) continue;
            Object value1 = ReflectionUtils.getValueByField(t1, field);
            Object value2 = ReflectionUtils.getValueByField(t2, field);
            if (!(value1 == null && value2 != null || value1 != null && value2 == null) && (value1 == null || value1.equals(value2))) continue;
            result.add(field);
        }
        return result;
    }
}

