/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchExclusionLogic;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.persistence.ManyToOne;

@SupportedAnnotationTypes(value={"javax.persistence.ManyToOne"})
public class ManyToOneProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWith(ManyToOne.class).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                ProcessorUtils.validFilterTenant(element);
                ManyToOneProcessor.validWhereLogicExclusionManyToOne(element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static void validWhereLogicExclusionManyToOne(Element element) {
        JArchExclusionLogic anotacaoFilter = element.getAnnotation(JArchExclusionLogic.class);
        if (anotacaoFilter != null) {
            ProcessorUtils.messageError("JARCH ERROR: Exclus\u00e3o l\u00f3gica n\u00e3o pode conter @ManyToOne, se for um mapeamento BI-DIRECIONAL remova esse mapeamento tornando UNI-DIRECIONAL ou transforme em exclus\u00e3o f\u00edsica", element);
        }
    }
}

