/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.TabXhtmlType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.core.form.XhtmlFieldForm;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public final class DataXhtmlCodeGenerate {
    final String ENTITY = "entity";
    final String DATA_DETAIL = "dataDetail";
    final String DOT_ENTITY = ".entity";
    private final Element element;
    private final JArchGenerateCrud generateLogicCrud;
    private File fileDataXhtml;
    private File fileDadosXhtml;
    private String nameMaster;
    private String nameMasterSemCaracterEspecial;
    private String nameMasterSemCaracterEspecialMinusculo;
    private String nameController;

    public DataXhtmlCodeGenerate(Element element, JArchGenerateCrud generateLogicCrud) {
        this.element = element;
        this.generateLogicCrud = generateLogicCrud;
        this.configure(element, generateLogicCrud.master().name(), generateLogicCrud.nameSubPackage());
    }

    public static void generate(Element element, JArchGenerateCrud generateLogicCrud) {
        new DataXhtmlCodeGenerate(element, generateLogicCrud).create();
    }

    private void create() {
        if (ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileDataXhtml) || ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileDadosXhtml)) {
            return;
        }
        StringBuilder dataXhtml = new StringBuilder();
        ProcessorUtils.addCode(dataXhtml, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        ProcessorUtils.addCode(dataXhtml, "<html xml:lang=\"pt-BR\" xmlns=\"http://www.w3.org/1999/xhtml\"");
        ProcessorUtils.addCode(dataXhtml, "\txmlns:f=\"http://xmlns.jcp.org/jsf/core\"");
        ProcessorUtils.addCode(dataXhtml, "\txmlns:h=\"http://xmlns.jcp.org/jsf/html\"");
        ProcessorUtils.addCode(dataXhtml, "\txmlns:ui=\"http://xmlns.jcp.org/jsf/facelets\"");
        ProcessorUtils.addCode(dataXhtml, "\txmlns:a=\"http://jarch.com.br/ui\"");
        ProcessorUtils.addCode(dataXhtml, "\txmlns:e=\"http://jarch.com.br/ui/extension\">");
        ProcessorUtils.addCode(dataXhtml, "\t<h:head>");
        ProcessorUtils.addCode(dataXhtml, "\t\t<title/>");
        ProcessorUtils.addCode(dataXhtml, "\t</h:head>");
        ProcessorUtils.addCode(dataXhtml, "<ui:composition template=\"/paginas/templates/templateData.xhtml\">");
        ProcessorUtils.addCode(dataXhtml, "\t<ui:define name=\"panelBodyTemplateDados\">");
        ProcessorUtils.addCode(dataXhtml, "\t\t<h:form id=\"frm" + this.nameMasterSemCaracterEspecial + "\">");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t<e:panelTitle");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t\ttitle=\"#{e:bundle('label." + this.nameMasterSemCaracterEspecialMinusculo + "')} - #{" + this.nameMasterSemCaracterEspecialMinusculo + "DataController.labelAction}\"");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t\tdescription=\"#{e:bundle('label.manter')} #{e:bundle('label." + this.nameMasterSemCaracterEspecialMinusculo + "')}\"/>");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t<e:panelDataMaster id=\"ddm" + this.nameMasterSemCaracterEspecial + "\"");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t\ttitle=\"#{e:bundle('label." + this.nameMasterSemCaracterEspecialMinusculo + "')}\"");
        ProcessorUtils.addCode(dataXhtml, "\t\t\t\tactionData=\"#{" + this.nameMasterSemCaracterEspecialMinusculo + "DataController}\">");
        ProcessorUtils.addCode(dataXhtml, this.generateXhtmlFromFieldsMaster(this.nameMaster, ProcessorUtils.getListFieldForm(this.generateLogicCrud.master().fields()), "entity", ""));
        ProcessorUtils.addCode(dataXhtml, "\t\t\t</e:panelDataMaster>");
        if (this.generateLogicCrud.master().details().length > 0) {
            this.addDivDataDetail(dataXhtml);
            ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t<a:tabView>");
            Arrays.stream(this.generateLogicCrud.master().details()).forEach(detail -> {
                String nameSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(detail.name());
                String nameSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail.name());
                String entity = "dataDetail" + nameSemCaracterEspecial + ".entity";
                String dataDetail = "dataDetail" + nameSemCaracterEspecial;
                String actionDataDetail = this.nameController + "." + dataDetail;
                ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t<a:tab id=\"tab" + nameSemCaracterEspecial + "\">\n\t\t\t\t\t\t\t<f:facet name=\"title\">\n\t\t\t\t\t\t\t\t<e:tabTitle title=\"#{e:bundle('label." + nameSemCaracterEspecialMinusculo + "')}\" entityParent=\"#{" + this.nameController + ".entity}\" dataDetail=\"#{" + actionDataDetail + "}\" idTab=\"tab" + nameSemCaracterEspecial + "\" update=\"#{e:component('tabBody" + nameSemCaracterEspecial + "')}\" hideInsert=\"#{" + this.nameController + ".blockedDetail}\"/>\n\t\t\t\t\t\t\t</f:facet>\n\t\t\t\t\t\t\t<e:tabBody id=\"tabBody" + nameSemCaracterEspecial + "\" actionData=\"#{" + this.nameController + "}\" dataDetail=\"#{" + actionDataDetail + "}\" idTab=\"tab" + nameSemCaracterEspecial + "\">");
                ProcessorUtils.addCode(dataXhtml, this.generateXhtmlFromFieldsDetail(detail.name(), ProcessorUtils.getListFieldForm(detail.fields()), entity, dataDetail));
                Arrays.stream(detail.subDetails()).forEach(subDetail -> {
                    String nameSubDetalheSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(subDetail.name());
                    String nameSubDetalheSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(subDetail.name());
                    String entitySubDetalhe = "dataDetail" + nameSubDetalheSemCaracterEspecial + ".entity";
                    String dataDetailSubDetalhe = "dataDetail" + nameSubDetalheSemCaracterEspecial;
                    String actionDataDetailSubDetalhe = this.nameController + "." + dataDetailSubDetalhe;
                    ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t\t<a:panelGrid columns=\"1\">\n\t\t\t\t\t\t\t\t\t<a:tabView>\n\t\t\t\t\t\t\t\t\t\t<a:tab id=\"tab" + nameSubDetalheSemCaracterEspecial + "\">\n\t\t\t\t\t\t\t\t\t\t\t<f:facet name=\"title\">\n\t\t\t\t\t\t\t\t\t\t\t\t<e:tabTitle title=\"#{e:bundle('label." + nameSubDetalheSemCaracterEspecialMinusculo + "')}\" entityParent=\"#{" + actionDataDetail + ".entity}\" dataDetail=\"#{" + actionDataDetailSubDetalhe + "}\" idTab=\"tab" + nameSubDetalheSemCaracterEspecial + "\" update=\"#{e:component('tabBody" + nameSubDetalheSemCaracterEspecial + "')}\" hideInsert=\"#{" + this.nameController + ".blockedDetail}\"/>\n\t\t\t\t\t\t\t\t\t\t\t</f:facet>\n\t\t\t\t\t\t\t\t\t\t\t<e:tabBody id=\"tabBody" + nameSubDetalheSemCaracterEspecial + "\" actionData=\"#{" + this.nameController + "}\" dataDetail=\"#{" + actionDataDetailSubDetalhe + "}\" idTab=\"tab" + nameSubDetalheSemCaracterEspecial + "\" dataDetailParent=\"#{" + actionDataDetail + "}\">");
                    ProcessorUtils.addCode(dataXhtml, this.generateXhtmlFromFieldsSubDetail(subDetail.name(), ProcessorUtils.getListFieldForm(subDetail.fields()), entitySubDetalhe, dataDetailSubDetalhe));
                    ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t\t\t\t\t</e:tabBody>");
                    ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t\t\t\t</a:tab>");
                    ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t\t\t</a:tabView>");
                    ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t\t</a:panelGrid>");
                });
                ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t\t</e:tabBody>");
                ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t\t</a:tab>");
            });
            ProcessorUtils.addCode(dataXhtml, "\t\t\t\t\t</a:tabView>");
            this.addCloseDivDataDetail(dataXhtml);
        }
        ProcessorUtils.addCode(dataXhtml, "\t\t</h:form>");
        ProcessorUtils.addCode(dataXhtml, "\t</ui:define>");
        ProcessorUtils.addCode(dataXhtml, "</ui:composition>");
        ProcessorUtils.addCode(dataXhtml, "</html>");
        try {
            FileUtils.save(this.fileDataXhtml, dataXhtml.toString());
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.fileDataXhtml.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    private void addCloseDivDataDetail(StringBuilder sbListaXhtml) {
        ProcessorUtils.addCode(sbListaXhtml, "\t\t\t\t</e:panelDataDetail>");
        ProcessorUtils.addCode(sbListaXhtml, "\t\t\t</f:validateBean>");
    }

    private void addDivDataDetail(StringBuilder sbListaXhtml) {
        ProcessorUtils.addCode(sbListaXhtml, "\t\t\t<f:validateBean disabled=\"true\">");
        ProcessorUtils.addCode(sbListaXhtml, "\t\t\t\t<e:panelDataDetail title=\"#{e:bundle('label.manutencaoDetalhe')}\">");
    }

    private String generateXhtmlFromFieldsMaster(String name, List<FieldForm> formFields, String entity, String dataDetail) {
        return this.generateXhtmlFromFields(TabXhtmlType.MASTER, name, formFields, entity, dataDetail);
    }

    private String generateXhtmlFromFieldsDetail(String name, List<FieldForm> formFields, String entity, String dataDetail) {
        return this.generateXhtmlFromFields(TabXhtmlType.DETAIL, name, formFields, entity, dataDetail);
    }

    private String generateXhtmlFromFieldsSubDetail(String name, List<FieldForm> formFields, String entity, String dataDetail) {
        return this.generateXhtmlFromFields(TabXhtmlType.SUBDETAIL, name, formFields, entity, dataDetail);
    }

    private String generateXhtmlFromFields(TabXhtmlType tabXhtmlType, String name, List<FieldForm> formFields, String entity, String dataDetail) {
        boolean master = Objects.equals(name, this.nameMaster);
        StringBuilder result = new StringBuilder();
        int maiorLinha = formFields.stream().mapToInt(f -> f.getXhtml().stream().mapToInt(XhtmlFieldForm::getRowDataXhtml).max().orElse(0)).max().orElse(0);
        for (int linha = 1; linha <= maiorLinha; ++linha) {
            int linhaComparacao = linha;
            List formFieldsOrderByRowColumn = formFields.stream().filter(f -> !f.getXhtml().isEmpty()).filter(f -> f.getXhtml().stream().allMatch(l -> l.getRowDataXhtml() == linhaComparacao)).sorted(Comparator.comparing(f -> f.getXhtml().get(0).getColumnDataXhtml())).collect(Collectors.toList());
            if (formFieldsOrderByRowColumn.isEmpty()) continue;
            Object tabsDentro = tabXhtmlType.tabs();
            String stylePanelGrid = "";
            if (formFieldsOrderByRowColumn.stream().anyMatch(f -> f.getTipo() == FieldType.ADDRESS)) {
                stylePanelGrid = " style=\"width: 100%\"";
            }
            result.append((String)tabsDentro + "<a:panelGrid id='pnlgrd" + linha + "' columns=\"" + formFieldsOrderByRowColumn.size() + "\"" + stylePanelGrid + ">\n");
            String fechandoTagPanelGrid = (String)tabsDentro + "</a:panelGrid>";
            tabsDentro = (String)tabsDentro + "\t";
            for (FieldForm campoForm : formFieldsOrderByRowColumn) {
                result.append((String)tabsDentro);
                result.append("<h:panelGroup>\n");
                if (!(FieldType.ENTITY.equals((Object)campoForm.getTipo()) || FieldType.MONEY.equals((Object)campoForm.getTipo()) || campoForm.getTipo().isAddress())) {
                    result.append((String)tabsDentro + "\t<a:outputLabel value=\"" + campoForm.getBundleJsf() + "\" for=\"" + campoForm.getGenerateId(this.nameMaster, dataDetail) + "\" ");
                    if (campoForm.getTipo().isNumber()) {
                        result.append("styleClass=\"outputlabel-inputnumber\"");
                    }
                    result.append("/>\n");
                    result.append((String)tabsDentro + "\t<br/>\n");
                }
                result.append((String)tabsDentro + "\t");
                result.append(campoForm.getTagXhtml(master, this.nameController, this.nameMasterSemCaracterEspecial, dataDetail, entity, (String)tabsDentro));
                result.append((String)tabsDentro + "</h:panelGroup>\n");
            }
            result.append(fechandoTagPanelGrid);
            if (linha == maiorLinha) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private void configure(Element element, String nameMaster, String nameSubPackage) {
        this.nameMaster = nameMaster;
        this.nameMasterSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(nameMaster);
        this.nameMasterSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(nameMaster);
        this.nameController = this.nameMasterSemCaracterEspecialMinusculo + "DataController";
        File folder = new File(ProcessorUtils.getPathPage(element, nameSubPackage));
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.fileDataXhtml = new File(ProcessorUtils.getPathPage(element, nameSubPackage) + this.nameMasterSemCaracterEspecialMinusculo + "Data.xhtml");
        this.fileDadosXhtml = new File(ProcessorUtils.getPathPage(element, nameSubPackage) + "dados" + this.nameMasterSemCaracterEspecial + ".xhtml");
    }
}

