/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.JsonWebToken;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OpaqueURI;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.spi.OracleResourceProvider;

final class AccessTokenBuilder {
    private Supplier<? extends AccessToken> tokenSupplier;
    private String passwordAuthentication;
    private String userName;
    private OpaqueString password;
    private boolean isSepsCredentials;
    private OpaqueString accessToken;
    private String tokenAuthentication;
    private String tokenLocation;
    private String ociIamUrl;
    private Properties tlsConfig;
    private String ociConfigFile;
    private String ociProfile;
    private String ociTenancy;
    private String ociCompartment;
    private String ociDatabase;
    private String azureDatabaseApplicationIdUri;
    private String tenantId;
    private String clientId;
    private OpaqueString clientSecret;
    private String clientCertificate;
    private OpaqueString clientCertificatePassword;
    private String redirectUri;
    private OpaqueString providerAccessToken;

    AccessTokenBuilder() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessTokenBuilder)) {
            return false;
        }
        AccessTokenBuilder accessTokenBuilder = (AccessTokenBuilder)object;
        return this.isSepsCredentials == accessTokenBuilder.isSepsCredentials && Objects.equals(this.tokenSupplier, accessTokenBuilder.tokenSupplier) && Objects.equals(this.passwordAuthentication, accessTokenBuilder.passwordAuthentication) && Objects.equals(this.userName, accessTokenBuilder.userName) && Objects.equals(this.password, accessTokenBuilder.password) && Objects.equals(this.accessToken, accessTokenBuilder.accessToken) && Objects.equals(this.tokenAuthentication, accessTokenBuilder.tokenAuthentication) && Objects.equals(this.tokenLocation, accessTokenBuilder.tokenLocation) && Objects.equals(this.ociIamUrl, accessTokenBuilder.ociIamUrl) && Objects.equals(this.tlsConfig, accessTokenBuilder.tlsConfig) && Objects.equals(this.ociConfigFile, accessTokenBuilder.ociConfigFile) && Objects.equals(this.ociProfile, accessTokenBuilder.ociProfile) && Objects.equals(this.ociTenancy, accessTokenBuilder.ociTenancy) && Objects.equals(this.ociCompartment, accessTokenBuilder.ociCompartment) && Objects.equals(this.ociDatabase, accessTokenBuilder.ociDatabase) && Objects.equals(this.azureDatabaseApplicationIdUri, accessTokenBuilder.azureDatabaseApplicationIdUri) && Objects.equals(this.tenantId, accessTokenBuilder.tenantId) && Objects.equals(this.clientId, accessTokenBuilder.clientId) && Objects.equals(this.clientSecret, accessTokenBuilder.clientSecret) && Objects.equals(this.clientCertificate, accessTokenBuilder.clientCertificate) && Objects.equals(this.clientCertificatePassword, accessTokenBuilder.clientCertificatePassword) && Objects.equals(this.redirectUri, accessTokenBuilder.redirectUri) && Objects.equals(this.providerAccessToken, accessTokenBuilder.providerAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.tokenSupplier, this.passwordAuthentication, this.userName, this.password, this.isSepsCredentials, this.accessToken, this.tokenAuthentication, this.tokenLocation, this.ociIamUrl, this.tlsConfig, this.ociConfigFile, this.ociProfile, this.ociTenancy, this.ociCompartment, this.ociDatabase, this.azureDatabaseApplicationIdUri, this.tenantId, this.clientId, this.clientSecret, this.clientCertificate, this.clientCertificatePassword, this.redirectUri, this.providerAccessToken);
    }

    AccessTokenBuilder tokenSupplier(Supplier<? extends AccessToken> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
        return this;
    }

    AccessTokenBuilder accessToken(OpaqueString accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    AccessTokenBuilder passwordAuthentication(String passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
        return this;
    }

    AccessTokenBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    AccessTokenBuilder password(OpaqueString password) {
        this.password = password;
        return this;
    }

    AccessTokenBuilder isSepsCredentials(boolean isSepsCredentials) {
        this.isSepsCredentials = isSepsCredentials;
        return this;
    }

    AccessTokenBuilder tokenAuthentication(String tokenAuthentication) {
        this.tokenAuthentication = tokenAuthentication;
        return this;
    }

    AccessTokenBuilder tokenLocation(String tokenLocation) {
        this.tokenLocation = tokenLocation;
        return this;
    }

    AccessTokenBuilder ociIamUrl(String ociIamUrl) {
        this.ociIamUrl = ociIamUrl;
        return this;
    }

    AccessTokenBuilder tlsConfig(Properties tlsConfig) {
        this.tlsConfig = tlsConfig;
        return this;
    }

    AccessTokenBuilder ociConfigFile(String ociConfigFile) {
        this.ociConfigFile = ociConfigFile;
        return this;
    }

    AccessTokenBuilder ociProfile(String ociProfile) {
        this.ociProfile = ociProfile;
        return this;
    }

    AccessTokenBuilder ociTenancy(String ociTenancy) {
        this.ociTenancy = ociTenancy;
        return this;
    }

    AccessTokenBuilder ociCompartment(String ociCompartment) {
        this.ociCompartment = ociCompartment;
        return this;
    }

    AccessTokenBuilder ociDatabase(String ociDatabase) {
        this.ociDatabase = ociDatabase;
        return this;
    }

    AccessTokenBuilder azureDatabaseApplicationIdUri(String azureDatabaseApplicationIdUri) {
        this.azureDatabaseApplicationIdUri = azureDatabaseApplicationIdUri;
        return this;
    }

    AccessTokenBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    AccessTokenBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    AccessTokenBuilder clientSecret(OpaqueString clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    AccessTokenBuilder clientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    AccessTokenBuilder clientCertificatePassword(OpaqueString clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    AccessTokenBuilder redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    AccessTokenBuilder providerAccessToken(OpaqueString providerAccessToken) {
        this.providerAccessToken = providerAccessToken;
        return this;
    }

    @Blind
    AccessToken build() throws SQLException {
        if (this.isSepsCredentials || this.userName == null && OpaqueString.isNull(this.password)) {
            if (this.tokenSupplier != null) {
                return this.getTokenFromSupplier();
            }
            if (!OpaqueString.isNull(this.accessToken)) {
                return this.getTokenFromProperty();
            }
            if (this.tokenAuthentication != null) {
                return this.getTokenFromTokenAuthentication();
            }
            if (!OpaqueString.isNull(this.providerAccessToken)) {
                return this.getTokenFromProvider();
            }
        }
        return this.getTokenFromPasswordAuthentication();
    }

    @Blind
    private AccessToken getTokenFromSupplier() throws SQLException {
        try {
            AccessToken accessToken = this.tokenSupplier.get();
            if (accessToken != null) {
                return accessToken;
            }
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A null value was output by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier)").fillInStackTrace();
        }
        catch (RuntimeException runtimeException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "An exception was thrown by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier).", (Throwable)runtimeException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getTokenFromProperty() throws SQLException {
        char[] clearText = this.accessToken.getChars();
        try {
            AccessToken accessToken = AccessToken.createJsonWebToken(clearText);
            return accessToken;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 25707, MessageFormat.format(DatabaseError.findMessage(1721, null), "[OMITTED]", "oracle.jdbc.accessToken"), (Throwable)exception).fillInStackTrace();
        }
        finally {
            Arrays.fill(clearText, '\u0000');
        }
    }

    private AccessToken getTokenFromTokenAuthentication() throws SQLException {
        TokenAuthentication tokenAuthentication = TokenAuthentication.parseProperty(this.tokenAuthentication);
        switch (tokenAuthentication) {
            case OCI_TOKEN: 
            case OAUTH: {
                return this.getTokenFromFile(tokenAuthentication);
            }
            case OCI_API_KEY: 
            case OCI_INSTANCE_PRINCIPAL: 
            case OCI_DELEGATION_TOKEN: 
            case OCI_INTERACTIVE: 
            case OCI_DEFAULT: {
                return AccessTokenBuilder.getTokenFromUri(this.createOciUri(tokenAuthentication));
            }
            case AZURE_SERVICE_PRINCIPAL: 
            case AZURE_MANAGED_IDENTITY: 
            case AZURE_PASSWORD: 
            case AZURE_DEVICE_CODE: 
            case AZURE_INTERACTIVE: 
            case AZURE_DEFAULT: {
                return AccessTokenBuilder.getTokenFromUri(this.createAzureUri(tokenAuthentication));
            }
        }
        throw new IllegalStateException("Unexpected value: " + tokenAuthentication);
    }

    @Blind
    private AccessToken getTokenFromFile(TokenAuthentication authenticationMethod) throws SQLException {
        Path tokenPath;
        boolean isOciToken;
        boolean bl = isOciToken = TokenAuthentication.OCI_TOKEN == authenticationMethod;
        if (!isOciToken && TokenAuthentication.OAUTH != authenticationMethod) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, this.tokenAuthentication, "oracle.jdbc.tokenAuthentication").fillInStackTrace();
        }
        if (this.tokenLocation != null) {
            tokenPath = Paths.get(this.tokenLocation, new String[0]);
        } else if (isOciToken) {
            String userHome = GeneratedPhysicalConnection.getSystemPropertyUserHome(null);
            if (userHome == null) {
                throw (SQLException)DatabaseError.createSqlException(null, "System property \"user.home\" is not set. The default token location can not be resolved", 1718).fillInStackTrace();
            }
            tokenPath = Paths.get(userHome, ".oci", "db-token");
        } else {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.tokenAuthentication=" + this.tokenAuthentication, null, "oracle.jdbc.tokenLocation").fillInStackTrace();
        }
        try {
            return isOciToken ? JsonWebToken.fromOciFile(tokenPath) : JsonWebToken.fromFile(tokenPath);
        }
        catch (IOException ioException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a token file or private key file that can not be read.", (Throwable)ioException).fillInStackTrace();
        }
        catch (SQLException exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a private key file that cannot be read.", (Throwable)exception).fillInStackTrace();
        }
        catch (GeneralSecurityException exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a private key file that can not be read.", (Throwable)exception).fillInStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (SQLException)DatabaseError.createSqlException(null, 25707, "An invalid token was configured by connection property oracle.jdbc.tokenLocation", (Throwable)illegalArgumentException).fillInStackTrace();
        }
    }

    private OpaqueURI createOciUri(TokenAuthentication authenticationMethod) throws SQLException {
        return OpaqueURI.builder().scheme("ojdbc-resource").authority("oci.token").parameter("authentication-method", authenticationMethod.uriValue).optionalParameter("scope", this.composeOciScope()).optionalParameter("tenant-id", this.ociTenancy).optionalParameter("config-file", this.ociConfigFile).optionalParameter("profile", this.ociProfile).build();
    }

    private String composeOciScope() throws SQLException {
        if (this.ociCompartment == null && this.ociDatabase != null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.ociDatabase is set.", null, "oracle.jdbc.ociCompartment").fillInStackTrace();
        }
        return "urn:oracle:db::id::" + (String)(this.ociCompartment == null ? "*" : (this.ociDatabase == null ? this.ociCompartment : this.ociCompartment + "::" + this.ociDatabase));
    }

    @Blind
    private OpaqueURI createAzureUri(TokenAuthentication authenticationMethod) throws SQLException {
        String clientId = this.clientId;
        OpaqueString clientSecret = this.clientSecret;
        if (this.isSepsCredentials && authenticationMethod == TokenAuthentication.AZURE_SERVICE_PRINCIPAL) {
            if (clientId == null) {
                clientId = this.userName;
            }
            if (OpaqueString.isNull(clientSecret) && this.clientCertificate == null) {
                clientSecret = this.password;
            }
        }
        return OpaqueURI.builder().scheme("ojdbc-resource").authority("azure.token").parameter("authentication-method", authenticationMethod.uriValue).parameter("scope", this.composeAzureScope()).optionalParameter("tenant-id", this.tenantId).optionalParameter("client-id", clientId).optionalParameter("client-secret", clientSecret).optionalParameter("certificate-path", this.clientCertificate).optionalParameter("certificate-password", this.clientCertificatePassword).optionalParameter("username", this.userName).optionalParameter("password", this.password).optionalParameter("redirect-uri", this.redirectUri).build();
    }

    private String composeAzureScope() throws SQLException {
        if (this.azureDatabaseApplicationIdUri == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.tokenAuthentication is set to " + this.tokenAuthentication, null, "oracle.jdbc.azureDatabaseApplicationIdUri").fillInStackTrace();
        }
        return this.azureDatabaseApplicationIdUri + "/.default";
    }

    @Blind
    private static AccessToken getTokenFromUri(OpaqueURI providerURI) throws SQLException {
        char[] uriChars = providerURI.toCharArray();
        try {
            AccessToken accessToken = AccessTokenBuilder.getTokenFromProvider(CharBuffer.wrap(uriChars));
            return accessToken;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Token request failed with provider URI: " + providerURI, (Throwable)exception).fillInStackTrace();
        }
        finally {
            Arrays.fill(uriChars, '\u0000');
        }
    }

    private AccessToken getTokenFromPasswordAuthentication() throws SQLException {
        PasswordAuthentication authenticationMethod = PasswordAuthentication.parseProperty(this.passwordAuthentication);
        switch (authenticationMethod) {
            case PASSWORD_VERIFIER: 
            case KERBEROS5: {
                return null;
            }
            case OCI_TOKEN: {
                return this.getTokenFromIam();
            }
            case AZURE_TOKEN: {
                return AccessTokenBuilder.getTokenFromUri(this.createAzureUri(TokenAuthentication.AZURE_PASSWORD));
            }
        }
        throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, new Object[]{authenticationMethod, "oracle.jdbc.passwordAuthentication"}).fillInStackTrace();
    }

    @Blind
    private AccessToken getTokenFromIam() throws SQLException {
        if (this.ociIamUrl == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.passwordAuthentication=" + PasswordAuthentication.OCI_TOKEN, null, "oracle.jdbc.ociIamUrl").fillInStackTrace();
        }
        if (this.ociTenancy == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.passwordAuthentication=" + PasswordAuthentication.OCI_TOKEN, null, "oracle.jdbc.ociTenancy").fillInStackTrace();
        }
        if (this.ociDatabase != null && this.ociCompartment == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.ociDatabase is set.", null, "oracle.jdbc.ociCompartment").fillInStackTrace();
        }
        if (this.userName == null) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A user name must be provided when connection property oracle.jdbc.passwordAuthentication=" + PasswordAuthentication.OCI_TOKEN).fillInStackTrace();
        }
        if (this.password == null || this.password.isNull()) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A password must be provided when connection property oracle.jdbc.passwordAuthentication=" + PasswordAuthentication.OCI_TOKEN).fillInStackTrace();
        }
        try {
            return JsonWebToken.requestBuilder().endPoint(this.ociIamUrl).tenancy(this.ociTenancy).compartment(this.ociCompartment).database(this.ociDatabase).user(this.userName).password(this.password).tlsConfig(this.tlsConfig).build();
        }
        catch (IOException ioException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Failed to authenticate with IAM endpoint: " + this.ociIamUrl + ", with tenant OCID: " + this.ociTenancy + (String)(this.ociCompartment == null ? "" : ", with compartment OCID: " + this.ociCompartment) + (String)(this.ociDatabase == null ? "" : ", with database OCID: " + this.ociDatabase), (Throwable)ioException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getTokenFromProvider() throws SQLException {
        char[] identifierChars = this.providerAccessToken.getChars();
        try {
            AccessToken accessToken = AccessTokenBuilder.getTokenFromProvider(CharBuffer.wrap(identifierChars));
            return accessToken;
        }
        finally {
            Arrays.fill(identifierChars, '\u0000');
        }
    }

    @Blind
    private static AccessToken getTokenFromProvider(CharSequence identifier) throws SQLException {
        try {
            return OracleResourceProvider.findAndGet(AccessToken.class, identifier);
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1726, null, (Throwable)exception).fillInStackTrace();
        }
    }

    static enum TokenAuthentication {
        OCI_TOKEN(null),
        OCI_API_KEY("config-file"),
        OCI_INSTANCE_PRINCIPAL("instance-principal"),
        OCI_DELEGATION_TOKEN("cloud-shell"),
        OCI_INTERACTIVE("interactive"),
        OCI_DEFAULT("auto-detect"),
        OAUTH(null),
        AZURE_SERVICE_PRINCIPAL("service-principal"),
        AZURE_MANAGED_IDENTITY("managed-identity"),
        AZURE_PASSWORD("password"),
        AZURE_DEVICE_CODE("device-code"),
        AZURE_INTERACTIVE("interactive"),
        AZURE_DEFAULT("auto-detect");

        private final String uriValue;

        private TokenAuthentication(String uriValue) {
            this.uriValue = uriValue;
        }

        static TokenAuthentication parseProperty(String propertyValue) throws SQLException {
            if (propertyValue == null) {
                return null;
            }
            try {
                return TokenAuthentication.valueOf(propertyValue.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, propertyValue, "oracle.jdbc.tokenAuthentication", illegalArgumentException).fillInStackTrace();
            }
        }
    }

    static enum PasswordAuthentication {
        PASSWORD_VERIFIER,
        OCI_TOKEN,
        AZURE_TOKEN,
        KERBEROS5;


        static PasswordAuthentication parseProperty(String propertyValue) throws SQLException {
            if (propertyValue == null) {
                return null;
            }
            try {
                return PasswordAuthentication.valueOf(propertyValue.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, propertyValue, "oracle.jdbc.passwordAuthentication", illegalArgumentException).fillInStackTrace();
            }
        }
    }
}

