/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.jasperreports.components.BaseElementHtmlHandler;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.components.sort.actions.FilterAction;
import net.sf.jasperreports.components.sort.actions.SortAction;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.util.JacksonUtil;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.velocity.VelocityContext;

public class SortElementHtmlHandler
extends BaseElementHtmlHandler {
    private static final String CSS_FILTER_DEFAULT = "filterBtnDefault";
    private static final String CSS_FILTER_WRONG = "filterBtnWrong";
    private static final String CSS_SORT_DEFAULT_ASC = "sortAscBtnDefault";
    private static final String CSS_SORT_DEFAULT_DESC = "sortDescBtnDefault";
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/sort/resources/SortElementHtmlTemplate.vm";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String FILTER_SYMBOL_ACTIVE = "Active";
    protected static final String FILTER_SYMBOL_INACTIVE = "Inactive";

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        String htmlFragment = null;
        Exporter exporter = context.getExporterRef();
        ReportContext reportContext = exporter.getReportContext();
        if (reportContext != null) {
            String sortField;
            FilterTypesEnum filterType;
            Color sortHandlerColor;
            String sortColumnName = (String)element.getParameterValue("sortColumnName");
            String sortColumnType = (String)element.getParameterValue("sortColumnType");
            String sortHandlerVAlign = (String)element.getParameterValue("sortHandlerVerticalAlign");
            String sortHandlerHAlign = (String)element.getParameterValue("sortHandlerHorizontalAlign");
            String sortDatasetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.dsr");
            JRBaseFont sortHandlerFont = (JRBaseFont)element.getParameterValue("sortHandlerFont");
            if (sortHandlerFont == null) {
                sortHandlerFont = new JRBaseFont(element);
            }
            if ((sortHandlerColor = (Color)element.getParameterValue("sortHandlerColor")) == null) {
                sortHandlerColor = Color.WHITE;
            }
            if ((filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrTp"))) == null) {
                return null;
            }
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("uuid", (Object)element.getUUID().toString());
            velocityContext.put("elementWidth", (Object)element.getWidth());
            velocityContext.put("elementHeight", (Object)element.getHeight());
            velocityContext.put("sortHandlerHAlign", (Object)(sortHandlerHAlign != null ? sortHandlerHAlign : CSS_TEXT_ALIGN_LEFT));
            velocityContext.put("sortHandlerVAlign", (Object)(sortHandlerVAlign != null ? sortHandlerVAlign : HTML_VERTICAL_ALIGN_TOP));
            velocityContext.put("sortHandlerColor", (Object)JRColorUtil.getColorHexa(sortHandlerColor));
            velocityContext.put("sortHandlerFontSize", (Object)Float.valueOf(sortHandlerFont.getFontsize()));
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            if ((sortField = this.getCurrentSortField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortDatasetName, sortColumnName, sortColumnType)) == null) {
                velocityContext.put("isSorted", (Object)false);
            } else {
                String[] sortActionData = SortElementUtils.extractColumnInfo(sortField);
                boolean isAscending = "Asc".equals(sortActionData[2]);
                velocityContext.put("isSorted", (Object)true);
                velocityContext.put("sortSymbolResource", (Object)(isAscending ? CSS_SORT_DEFAULT_ASC : CSS_SORT_DEFAULT_DESC));
            }
            String filterActiveInactive = FILTER_SYMBOL_INACTIVE;
            boolean isFiltered = false;
            String filterSymbolImageResource = CSS_FILTER_DEFAULT;
            List<FieldFilter> fieldFilters = this.getExistingFiltersForField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortColumnName);
            if (fieldFilters.size() > 0) {
                FieldFilter ff = fieldFilters.get(0);
                filterActiveInactive = FILTER_SYMBOL_ACTIVE;
                isFiltered = true;
                if (ff.getIsValid() != null && !ff.getIsValid().booleanValue()) {
                    filterSymbolImageResource = CSS_FILTER_WRONG;
                }
            }
            velocityContext.put("isFiltered", (Object)isFiltered);
            velocityContext.put("filterSymbolImageResource", (Object)filterSymbolImageResource);
            velocityContext.put("filterActiveInactive", (Object)filterActiveInactive);
            htmlFragment = VelocityUtil.processTemplate(SORT_ELEMENT_HTML_TEMPLATE, velocityContext);
        }
        return htmlFragment;
    }

    private String getCurrentSortField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String sortDatasetName, String sortColumnName, String sortColumnType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        SortAction action = new SortAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            List<JRSortField> existingFields = dataset.getSortFieldsList();
            String sortField = null;
            if (existingFields != null && existingFields.size() > 0) {
                for (JRSortField field : existingFields) {
                    if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                    sortField = sortColumnName + ":" + sortColumnType + ":";
                    switch (field.getOrderValue()) {
                        case ASCENDING: {
                            sortField = sortField + "Asc";
                            break;
                        }
                        case DESCENDING: {
                            sortField = sortField + "Dsc";
                        }
                    }
                    break;
                }
            }
            return sortField;
        }
        return null;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public static void getFieldFilters(DatasetFilter existingFilter, List<FieldFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add((FieldFilter)existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter datasetFilter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                SortElementHtmlHandler.getFieldFilters(datasetFilter, fieldFilters, fieldName);
            }
        }
    }

    private List<FieldFilter> getExistingFiltersForField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String filterFieldName) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        ArrayList<FieldFilter> result = new ArrayList<FieldFilter>();
        if (target != null) {
            List<FieldFilter> existingFilters;
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            String serializedFilters = "[]";
            JRPropertiesMap propertiesMap = dataset.getPropertiesMap();
            if (propertiesMap.getProperty("net.sf.jasperreports.filters") != null) {
                serializedFilters = propertiesMap.getProperty("net.sf.jasperreports.filters");
            }
            if ((existingFilters = JacksonUtil.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class)).size() > 0) {
                for (DatasetFilter datasetFilter : existingFilters) {
                    if (!((FieldFilter)datasetFilter).getField().equals(filterFieldName)) continue;
                    result.add((FieldFilter)datasetFilter);
                    break;
                }
            }
        }
        return result;
    }
}

