/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumberUtils {
    private static final Locale LOCAL = new Locale("pt", "BR");
    private static final Pattern LATITUDE_PATTERN = Pattern.compile("^\\(?[+-]?([1-8]?\\d(\\.\\d+)?|90(\\.0+)?)$");
    private static final Pattern LONGITUDE_PATTERN = Pattern.compile("^\\(?[+-]?((1?[0-7]?\\d(\\.\\d+)?|180(\\.0+)?))$");

    private NumberUtils() {
    }

    public static int random(int begin, int end) {
        int quantity = end - begin + 1;
        int valueReturn = (int)(Math.random() * (double)quantity);
        return valueReturn += begin;
    }

    public static boolean containsOnlyNumber(String value) {
        if (value == null) {
            return false;
        }
        Pattern pat = Pattern.compile("[0-9]+");
        Matcher mat = pat.matcher(value);
        return mat.matches();
    }

    public static String onlyNumber(String value) {
        value = Objects.requireNonNullElse(value, "");
        return value.replaceAll("\\D+", "");
    }

    public static String onlyNumberWithoutZeroLeft(String value) {
        if (StringUtils.isNullOrEmpty(value = NumberUtils.onlyNumber(value))) {
            return value;
        }
        return new BigInteger(value).toString();
    }

    public static String currencyExtensive(double value) {
        return NumberUtils.extensive(value, true);
    }

    public static String numberExtensive(double value) {
        return NumberUtils.extensive(value, false);
    }

    public static String format(String mask, Number value) {
        value = Objects.requireNonNullElse(value, 0);
        return new DecimalFormat(mask, new DecimalFormatSymbols(LOCAL)).format(value);
    }

    public static String formatMoney(Number value) {
        value = Objects.requireNonNullElse(value, 0);
        return new DecimalFormat("#,##0.00", new DecimalFormatSymbols(LOCAL)).format(value);
    }

    public static String formatRate(Number value) {
        value = Objects.requireNonNullElse(value, 0);
        return new DecimalFormat("#,##0.0000", new DecimalFormatSymbols(LOCAL)).format(value);
    }

    public static String formatPercent(Number value) {
        value = Objects.requireNonNullElse(value, 0);
        return new DecimalFormat("#,##0.000000", new DecimalFormatSymbols(LOCAL)).format(value);
    }

    public static String formatInteger(Number value) {
        value = Objects.requireNonNullElse(value, 0);
        return new DecimalFormat("#,###", new DecimalFormatSymbols(LOCAL)).format(value);
    }

    public static String formatZeroLeft(Number value, int size) {
        return new DecimalFormat("0".repeat(Math.max(0, size)), new DecimalFormatSymbols(LOCAL)).format(value);
    }

    private static String extensive(Double value, boolean moeda) {
        int unid;
        int dez;
        int n;
        if (value == 0.0) {
            return "zero";
        }
        long inteiro = (long)Math.abs(value);
        double resto = value - (double)inteiro;
        String vlrS = String.valueOf(inteiro);
        if (vlrS.length() > 15) {
            return "Error: Value upper 999 billion";
        }
        Object s = "";
        String centavos = String.valueOf((int)Math.round(resto * 100.0));
        String[] chaveUnidade = new String[]{"", "um", "dois", "tres", "quatro", "cinco", "seis", "sete", "oito", "nove", "dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezessete", "dezoito", "dezenove"};
        String[] chaveCentena = new String[]{"", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"};
        String[] chaveDezena = new String[]{"", "", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa"};
        String[] chaveQualificaS = new String[]{"", "mil", "milhao", "bilhao", "trilhao"};
        String[] chaveQualificaP = new String[]{"", "mil", "milhoes", "bilhoes", "trilhoes"};
        int i = 0;
        boolean umReal = false;
        boolean tem = false;
        while (!vlrS.equals("0")) {
            String vlrP;
            int tam = vlrS.length();
            if (tam > 3) {
                vlrP = vlrS.substring(tam - 3, tam);
                vlrS = vlrS.substring(0, tam - 3);
            } else {
                vlrP = vlrS;
                vlrS = "0";
            }
            if (!vlrP.equals("000")) {
                Object saux = "";
                if (vlrP.equals("100")) {
                    saux = "cem";
                } else {
                    n = Integer.parseInt(vlrP, 10);
                    int cent = n / 100;
                    dez = n % 100 / 10;
                    unid = n % 100 % 10;
                    if (cent != 0) {
                        saux = NumberUtils.bundle(chaveCentena[cent]);
                    }
                    if (n % 100 <= 19) {
                        saux = !((String)saux).isEmpty() ? (String)saux + " e " + NumberUtils.bundle(chaveUnidade[n % 100]) : NumberUtils.bundle(chaveUnidade[n % 100]);
                    } else {
                        saux = !((String)saux).isEmpty() ? (String)saux + " e " + NumberUtils.bundle(chaveDezena[dez]) : NumberUtils.bundle(chaveDezena[dez]);
                        if (unid != 0) {
                            saux = !((String)saux).isEmpty() ? (String)saux + " e " + NumberUtils.bundle(chaveUnidade[unid]) : NumberUtils.bundle(chaveUnidade[unid]);
                        }
                    }
                }
                if (vlrP.equals("1") || vlrP.equals("001")) {
                    if (i == 0) {
                        umReal = true;
                    } else {
                        saux = (String)saux + " " + NumberUtils.bundle(chaveQualificaS[i]);
                    }
                } else if (i != 0) {
                    saux = (String)saux + " " + NumberUtils.bundle(chaveQualificaP[i]);
                }
                s = ((String)s).length() != 0 ? (moeda ? (String)saux + ", " + (String)s : (String)saux + " e " + (String)s) : saux;
            }
            if ((i == 0 || i == 1) && ((String)s).length() != 0) {
                tem = true;
            }
            ++i;
        }
        if (moeda) {
            if (!((String)s).isEmpty()) {
                s = umReal ? (String)s + " " + NumberUtils.bundle("real") : (tem ? (String)s + " " + NumberUtils.bundle("reais") : (String)s + " " + NumberUtils.bundle("de") + " " + NumberUtils.bundle("reais"));
            }
            if (!centavos.equals("0")) {
                if (!((String)s).isEmpty()) {
                    s = (String)s + " " + NumberUtils.bundle("e") + " ";
                }
                if (centavos.equals("1")) {
                    s = (String)s + NumberUtils.bundle("um") + " " + NumberUtils.bundle("centavo");
                } else {
                    n = Integer.parseInt(centavos, 10);
                    if (n <= 19) {
                        s = (String)s + NumberUtils.bundle(chaveUnidade[n]);
                    } else {
                        unid = n % 10;
                        dez = n / 10;
                        s = (String)s + NumberUtils.bundle(chaveDezena[dez]);
                        if (unid != 0) {
                            s = (String)s + " " + NumberUtils.bundle("e") + " " + NumberUtils.bundle(chaveUnidade[unid]);
                        }
                    }
                    s = (String)s + " " + NumberUtils.bundle("centavos");
                }
            }
        } else if ((double)value.longValue() != value && !centavos.equals("0")) {
            if (!((String)s).isEmpty()) {
                s = (String)s + " " + NumberUtils.bundle("e") + " ";
            }
            if (centavos.equals("1")) {
                s = (String)s + NumberUtils.bundle("um") + " ";
            } else {
                n = Integer.parseInt(centavos, 10);
                if (n <= 19) {
                    s = (String)s + NumberUtils.bundle(chaveUnidade[n]);
                } else {
                    unid = n % 10;
                    dez = n / 10;
                    s = (String)s + NumberUtils.bundle(chaveDezena[dez]);
                    if (unid != 0) {
                        s = (String)s + " " + NumberUtils.bundle("e") + " " + NumberUtils.bundle(chaveUnidade[unid]);
                    }
                }
                s = (String)s + " ";
            }
        }
        return s;
    }

    private static String bundle(String key) {
        return Objects.requireNonNullElse(key, "");
    }

    public static BigDecimal nullAsZero(BigDecimal value) {
        return Objects.requireNonNullElse(value, BigDecimal.ZERO);
    }

    public static boolean isNullOrZero(Number value) {
        return NumberUtils.isNullOrZeroTolerance(value, false);
    }

    public static boolean isNotNullAndNotZero(Number value) {
        return !NumberUtils.isNullOrZero(value);
    }

    public static boolean isMoneyNullOrZero(BigDecimal value) {
        return NumberUtils.isNullOrZeroTolerance(value, true);
    }

    private static boolean isNullOrZeroTolerance(Number value, boolean tolerance) {
        if (value == null) {
            return true;
        }
        if (value.getClass().isAssignableFrom(Byte.class) && (Byte)value == 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(Integer.class) && (Integer)value == 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(Long.class) && (Long)value == 0L) {
            return true;
        }
        if (value.getClass().isAssignableFrom(BigInteger.class) && value.intValue() == 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(BigDecimal.class)) {
            if (tolerance) {
                return Math.abs(value.doubleValue()) <= 0.009;
            }
            return BigDecimal.ZERO.doubleValue() == value.doubleValue();
        }
        return false;
    }

    public static boolean isDiffNullAndZero(Number value) {
        if (value == null) {
            return false;
        }
        if (value.getClass().isAssignableFrom(Byte.class) && (Byte)value != 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(Integer.class) && (Integer)value != 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(Long.class) && (Long)value != 0L) {
            return true;
        }
        if (value.getClass().isAssignableFrom(BigInteger.class) && value.intValue() != 0) {
            return true;
        }
        if (value.getClass().isAssignableFrom(BigDecimal.class) && value.doubleValue() != 0.0) {
            return true;
        }
        return value.shortValue() != 0;
    }

    public static boolean isValidLatitude(String latitude) {
        return LATITUDE_PATTERN.matcher(latitude).matches();
    }

    public static boolean isValidLongitude(String longitude) {
        return LONGITUDE_PATTERN.matcher(longitude).matches();
    }

    public static BigDecimal applyRuleThree(BigDecimal valuePartial, BigDecimal valueTotal, BigDecimal valuePartialCalculate) {
        if (NumberUtils.isNullOrZero(valuePartial)) {
            return BigDecimal.ZERO;
        }
        return valueTotal.multiply(valuePartialCalculate).divide(valuePartial, 6, RoundingMode.HALF_DOWN);
    }

    public static Double applyRuleThree(Double valuePartial, Double valueTotal, Double valuePartialCalculate) {
        if (NumberUtils.isNullOrZero(valuePartial)) {
            return 0.0;
        }
        return valueTotal * valuePartialCalculate / valuePartial;
    }

    public static boolean isEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null) {
            return false;
        }
        return Math.abs(value1.doubleValue() - value2.doubleValue()) < 0.01;
    }

    public static void main(String[] args) throws InterruptedException {
        int total = 100;
        int atual = 0;
        do {
            System.out.println("Atual: " + ++atual);
            Thread.sleep(1000L);
            if (atual <= 10) continue;
            total = 0;
        } while (total == 100);
    }

    public static <T extends Number> T numberOrNull(Class<T> clazz, String numero) {
        if (numero == null) {
            return null;
        }
        if (StringUtils.isNullOrEmpty(numero = NumberUtils.onlyNumber(numero))) {
            return null;
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(numero);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(numero);
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(numero);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(numero);
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(numero);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(numero);
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(numero);
        }
        if (clazz == BigInteger.class) {
            return (T)new BigInteger(numero);
        }
        throw new IllegalArgumentException("Unsupported number type: " + String.valueOf(clazz));
    }
}

