/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.report.util;

import br.com.jarch.util.LogUtils;
import jakarta.enterprise.inject.Vetoed;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;

@Vetoed
public final class JasperReportsUtils {
    private JasperReportsUtils() {
    }

    public static void visualizaJasperEmPdf(String nomeArquivoJasper, List<?> listaDados, Map<String, Object> parametros) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        try {
            ServletOutputStream streamDeSaida = response.getOutputStream();
            JRBeanCollectionDataSource dados = new JRBeanCollectionDataSource(listaDados);
            JasperPrint impressoraJasper = JasperFillManager.fillReport((String)nomeArquivoJasper, parametros, (JRDataSource)dados);
            response.setContentType("application/pdf");
            response.setHeader("Content-disposition", "inline; filename=\"relatorio.pdf\"");
            JasperExportManager.exportReportToPdfStream((JasperPrint)impressoraJasper, (OutputStream)streamDeSaida);
            facesContext.responseComplete();
        }
        catch (IOException | JRException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    public static void visualizaJasperEmExcel(String nomeArquivoJasper, List<?> listaDados, Map<String, Object> parametros) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        try {
            ServletOutputStream streamDeSaida = response.getOutputStream();
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachments; filename=\"relatorio.xls\"");
            JRBeanCollectionDataSource dados = new JRBeanCollectionDataSource(listaDados);
            JasperPrint impressoraJasper = JasperFillManager.fillReport((String)nomeArquivoJasper, parametros, (JRDataSource)dados);
            JRXlsExporter exporter = new JRXlsExporter();
            SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
            configuration.setWhitePageBackground(Boolean.valueOf(true));
            configuration.setOnePagePerSheet(Boolean.valueOf(true));
            exporter.setConfiguration((ReportExportConfiguration)configuration);
            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)streamDeSaida));
            exporter.exportReport();
            facesContext.responseComplete();
        }
        catch (IOException | JRException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    public static String geraArquivoPDF(List<?> lista, String nomeRelatorio, Map<String, Object> parametros) throws IOException, JRException {
        String arquivo;
        InputStream relatorio;
        Map parametrosGeral = (Map)((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getServletContext().getAttribute("parametrosRelatorio");
        if (parametrosGeral != null) {
            Set listaChave = parametrosGeral.keySet();
            for (String chave : listaChave) {
                parametros.put(chave, parametrosGeral.get(chave));
            }
        }
        if ((relatorio = new File(arquivo = JasperReportsUtils.getPath("relatorios") + nomeRelatorio + ".jasper").exists() ? new FileInputStream(arquivo) : JasperReportsUtils.class.getResourceAsStream("/relatorios/" + nomeRelatorio + ".jasper")) == null) {
            throw new JRException("N\u00e3o foi possivel localizar o relatorio " + nomeRelatorio + ".jasper");
        }
        JasperPrint impressoraJasper = JasperFillManager.fillReport((InputStream)relatorio, parametros, (JRDataSource)new JRBeanCollectionDataSource(lista));
        File file = File.createTempFile(nomeRelatorio, ".pdf");
        JasperExportManager.exportReportToPdfFile((JasperPrint)impressoraJasper, (String)file.getAbsolutePath());
        relatorio.close();
        return file.getAbsolutePath();
    }

    public static String generateFilePDF(File jasper, List<?> lista, Map<String, Object> params) throws IOException, JRException {
        FileInputStream relatorio = new FileInputStream(jasper);
        JasperPrint impressoraJasper = JasperFillManager.fillReport((InputStream)relatorio, params, (JRDataSource)new JRBeanCollectionDataSource(lista));
        File file = File.createTempFile(jasper.getName(), ".pdf");
        JasperExportManager.exportReportToPdfFile((JasperPrint)impressoraJasper, (String)file.getAbsolutePath());
        ((InputStream)relatorio).close();
        return file.getAbsolutePath();
    }

    private static String getPath(String path) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        ServletContext ctx = (ServletContext)externalContext.getContext();
        String realPath = ctx.getRealPath(path) + "/";
        if ("null/".equals(realPath)) {
            realPath = ctx.getAttribute("jakarta.servlet.context.tempdir").toString() + "/" + path;
        }
        return realPath;
    }
}

