/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchEventSearchConfig;
import br.com.jarch.core.annotation.JArchEventSearchConfigLiteral;
import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.annotation.JArchSearchFieldCheckbox;
import br.com.jarch.core.annotation.JArchSearchFieldComboboxCommandJpa;
import br.com.jarch.core.annotation.JArchSearchFieldShow;
import br.com.jarch.core.annotation.JArchSearchWhereJpa;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.crud.search.CheckBoxFieldSearchFactory;
import br.com.jarch.core.crud.search.ComboBoxCommandJpaFieldSearchFactory;
import br.com.jarch.core.crud.search.ComboBoxFieldSearchFactory;
import br.com.jarch.core.crud.search.DynamicFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.crud.search.FieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearchLookupFactory;
import br.com.jarch.core.crud.search.ISearch;
import br.com.jarch.core.crud.search.SearchWhereJpaFactory;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.model.ColumnsList;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.core.util.JpqlUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.Attribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class Search<E>
implements ISearch<E>,
Serializable {
    private static final String CODE_LOOKUP = "codeLookup";
    private static final int COLUMNS_DATATABLE = 12;
    private static final String SESSION_DOT = "session.";
    private static final String DOT_RECNO_START = ".recnoStart";
    private static final String DOT_LAST_FILTER = ".lastFilter";
    private static final String DOT_RECNO_TOTAL = ".recnoTotal";
    @Inject
    @JArchEventSearchConfig
    private Event<ISearch<E>> eventSearchConfig;
    private int first;
    private int maxResults = 10;
    private int total;
    private long totalManipulated;
    private ColumnsList columnsList;
    private final Map<String, FieldSearch> filters = new HashMap<String, FieldSearch>();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final List<FieldOrder> listFieldOrder = new ArrayList<FieldOrder>();
    private Class<?> classReturn;
    private String logicFrom;
    private boolean totalize;
    private String hint;

    protected Search() {
        this.createFields(this.getClassEntity());
        this.classReturn = this.getClassEntity();
    }

    @PostConstruct
    private void init() {
        this.eventSearchConfig.fire((Object)this);
    }

    @Override
    public final void createFields(Class<?> clazzTarget) {
        this.filters.clear();
        new FieldSearchFactory().createFieldSearch(clazzTarget, this.filters, false);
        new FieldSearchLookupFactory().createFieldSearch(clazzTarget, this.filters, false);
        new CheckBoxFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, false);
        new ComboBoxFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, false);
        new ComboBoxCommandJpaFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, false);
        new SearchWhereJpaFactory().createFieldSearch(clazzTarget, this.filters, false);
        new DynamicFieldSearchFactory().createFieldSearch(clazzTarget, this.filters);
        this.addOrderByFromEntity();
        this.removeNotSearchFieldShow(clazzTarget);
    }

    @Override
    public final void createFieldsOnlyClass(Class<?> clazzTarget) {
        this.filters.clear();
        new FieldSearchFactory().createFieldSearch(clazzTarget, this.filters, true);
        new FieldSearchLookupFactory().createFieldSearch(clazzTarget, this.filters, true);
        new CheckBoxFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, true);
        new ComboBoxFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, true);
        new ComboBoxCommandJpaFieldSearchFactory().createFieldSearch(clazzTarget, this.filters, true);
        new SearchWhereJpaFactory().createFieldSearch(clazzTarget, this.filters, true);
        new DynamicFieldSearchFactory().createFieldSearch(clazzTarget, this.filters);
        this.addOrderByFromEntity();
        this.removeNotSearchFieldShow(clazzTarget);
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    @Override
    public void setFirst(int first) {
        this.first = first;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public void setMaxResults(int quantity) {
        this.maxResults = quantity;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public long getTotalManipulated() {
        return this.totalManipulated;
    }

    @Override
    public void setTotalManipulated(long totalManipulated) {
        this.totalManipulated = totalManipulated;
    }

    @Override
    public void addFieldOrder(FieldOrder fieldOrder) {
        if (this.listFieldOrder.contains(fieldOrder)) {
            return;
        }
        this.listFieldOrder.add(fieldOrder);
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public final List<FieldOrder> getListFieldOrder() {
        return Collections.unmodifiableList(this.listFieldOrder);
    }

    @Override
    public final void clearFieldOrder() {
        this.listFieldOrder.clear();
    }

    @Override
    public final void setCodeLookup(String field, Object codeLookup) {
        FieldSearch fieldSearch = this.filters.get(CODE_LOOKUP);
        if (fieldSearch == null) {
            this.newSearchLookup(CODE_LOOKUP, field, codeLookup).attribute(field).setId(CODE_LOOKUP);
        } else {
            fieldSearch.setValue(codeLookup);
        }
    }

    @Override
    public final void removeFilterLookup() {
        this.filters.remove(CODE_LOOKUP);
    }

    @Override
    public final FieldSearch newSearchLookup(String id, String field, Object value) {
        Field fieldAttribute = ReflectionUtils.getField(this.getClassEntity(), (String)field, (boolean)false);
        Class clazzAttribute = Object.class;
        if (fieldAttribute == null && JpqlUtils.aliasEntity(this.getClassEntity()).equals(field)) {
            clazzAttribute = this.getClassEntity();
        } else if (fieldAttribute != null) {
            clazzAttribute = fieldAttribute.getType();
        }
        Class<Object> clazzAttributeFinal = clazzAttribute;
        FieldSearch fieldSearch = this.filters.computeIfAbsent(id, f -> FieldSearch.createInstance().annotation(JArchSearchField.class).id(id).classAttribute(clazzAttributeFinal).attribute(field).hide().noClearValueByButton().visibleCondition(false).condition(ConditionSearchType.EQUAL));
        fieldSearch.value(value);
        this.filters.put(field, fieldSearch);
        return fieldSearch;
    }

    @Override
    public final FieldSearch newSearchField(FieldType fieldType, String field, Object value) {
        Field fieldAttribute = ReflectionUtils.getField(this.getClassEntity(), (String)field, (boolean)false);
        Class clazzAttribute = Object.class;
        if (fieldAttribute == null && JpqlUtils.aliasEntity(this.getClassEntity()).equals(field)) {
            clazzAttribute = this.getClassEntity();
        } else if (fieldAttribute != null) {
            clazzAttribute = fieldAttribute.getType();
        }
        Class<Object> clazzAttributeFinal = clazzAttribute;
        FieldSearch fieldSearch = this.filters.computeIfAbsent(field, f -> FieldSearch.createInstance().annotation(JArchSearchField.class).classAttribute(clazzAttributeFinal).attribute(field).id(field).hide().noClearValueByButton().visibleCondition(false).condition(ConditionSearchType.EQUAL));
        fieldSearch.type(fieldType).value(value);
        this.filters.put(field, fieldSearch);
        return fieldSearch;
    }

    @Override
    public final <T> FieldSearch newSearchField(FieldType fieldType, Attribute<?, T> field, T value) {
        return this.newSearchField(fieldType, field.getName(), value);
    }

    @Override
    public final void setValue(String fieldOrId, Object value) {
        if (this.notExistsFilter(fieldOrId)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(fieldOrId)).forEach(c -> ((FieldSearch)c.getValue()).value(value));
    }

    @Override
    public final void setDescriptionValueForId(String id, String description, Object value) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).value(value).description(description));
    }

    @Override
    public final void addParamWhereJpa(String id, String namedParameter, Object valueParameter) {
        if (this.notExistsFilter(id)) {
            return;
        }
        HashMap<String, Object> mapValues = new HashMap<String, Object>();
        mapValues.put(namedParameter, valueParameter);
        this.addParamWhereJpa(id, mapValues);
    }

    @Override
    public final void addParamWhereJpa(String id, Map<String, Object> values) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).value(values));
    }

    @Override
    public final void activeAndAddParamWhereJpa(String id, String nameParam, Object valueParam) {
        this.activeWhereJpa(id);
        this.addParamWhereJpa(id, nameParam, valueParam);
    }

    @Override
    public final void activeAndAddParamsWhereJpa(String id, Map<String, Object> paramsFilter) {
        this.activeWhereJpa(id);
        this.addParamWhereJpa(id, paramsFilter);
    }

    @Override
    public final void activeWhereJpa(String id) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).active());
    }

    @Override
    public final void deactiveWhereJpa(String id) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).inactive());
    }

    @Override
    public final void changeCondition(String id, ConditionSearchType condicao) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).condition(condicao));
    }

    @Override
    public final void removeFilter(String fieldOrId) {
        this.filters.remove(fieldOrId);
    }

    @Override
    public final Map<String, FieldSearch> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    @Override
    public final List<FieldSearch> orderedRowColumn(String tab, Integer row) {
        return this.filtersVisible().values().stream().filter(f -> f.getTabName().equals(tab) && f.getRow().equals(row)).sorted(Comparator.comparing(FieldSearch::getColumn)).collect(Collectors.toList());
    }

    @Override
    public final List<FieldSearch> fieldSearchs() {
        return this.filtersVisible().values().stream().sorted(Comparator.comparing(FieldSearch::getTabName).thenComparing(FieldSearch::getRow).thenComparing(FieldSearch::getColumn)).collect(Collectors.toList());
    }

    @Override
    public final void clearFilter() {
        this.filters.entrySet().stream().filter(f -> ((FieldSearch)f.getValue()).isClearValueByButton()).forEach(f -> ((FieldSearch)f.getValue()).value(null));
    }

    @Override
    public final Integer columns(String tabName, Integer row) {
        if (row == null || row == 0) {
            return 12;
        }
        long quantityFieldsTabRow = this.filtersVisible().values().stream().filter(f -> f.getTabName().equals(tabName) && f.getRow().equals(row)).count() + 1L;
        return 12 / (int)quantityFieldsTabRow;
    }

    @Override
    public final Integer maxRow(String tabName) {
        return this.filtersVisible().values().stream().filter(fieldSearch -> fieldSearch.getRow() != null).filter(fieldSearch -> fieldSearch.getTabName().equals(tabName)).mapToInt(FieldSearch::getRow).max().orElse(0);
    }

    @Override
    public final List<String> tabs() {
        return this.filtersVisible().entrySet().stream().sorted(Comparator.comparingInt(f -> ((FieldSearch)f.getValue()).getTabOrder())).map(c -> ((FieldSearch)c.getValue()).getTabName()).distinct().collect(Collectors.toList());
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public final Class<E> getClassEntity() {
        Class retorno = ReflectionUtils.getGenericClass(this.getClass(), (int)0);
        return retorno;
    }

    @Override
    public void addValueFilterAndParam(Query query) {
        for (String atributo : this.filters.keySet()) {
            FieldSearch fieldSearch = this.filters.get(atributo);
            if (fieldSearch == null || !fieldSearch.isActive() || fieldSearch.getAnnotation() == JArchSearchFieldCheckbox.class && !fieldSearch.getWhereJpa().isEmpty() && !Boolean.TRUE.equals(fieldSearch.getValue())) continue;
            if (fieldSearch.isAddedValue() && fieldSearch.getAnnotation() == JArchSearchWhereJpa.class && Map.class.isAssignableFrom(fieldSearch.getValue().getClass())) {
                Map parametros = (Map)fieldSearch.getValue();
                for (String nameParametro : parametros.keySet()) {
                    if (!Arrays.stream(fieldSearch.getParametersBind()).noneMatch(s -> s.equals(nameParametro))) continue;
                    this.logParam(nameParametro, parametros.get(nameParametro));
                    JpaUtils.setParameter(query, nameParametro, parametros.get(nameParametro));
                }
                continue;
            }
            fieldSearch.getValueWhereJpa().forEach((key, value) -> {
                this.logParam((String)key, value);
                JpaUtils.setParameter(query, key, value);
            });
            if (query.getParameters().stream().noneMatch(p -> p.getName().equals(fieldSearch.getParameterJpql()))) continue;
            this.logParam(fieldSearch.getParameterJpql(), fieldSearch.getValueReadyFilter());
            if (fieldSearch.isAjustFilterMask()) {
                String valueOrigin = fieldSearch.getValue().toString();
                String valueNoMask = NumberUtils.onlyNumber((String)valueOrigin);
                String valueNoZeroLeft = StringUtils.removeZerosLeft((String)valueNoMask);
                List<String> values = List.of(valueOrigin, valueNoMask, valueNoZeroLeft);
                JpaUtils.setParameter(query, fieldSearch.getParameterJpql(), values);
            } else {
                JpaUtils.setParameter(query, fieldSearch.getParameterJpql(), fieldSearch.getValueReadyFilter());
            }
            if (!query.getParameters().stream().anyMatch(p -> p.getName().equals(fieldSearch.getParameterJpql().concat("_NoCharEspecial")))) continue;
            JpaUtils.setParameter(query, fieldSearch.getParameterJpql().concat("_NoCharEspecial"), StringUtils.removeAccents((String)fieldSearch.getValueReadyFilter().toString()));
        }
        this.getParams().entrySet().stream().filter(p1 -> query.getParameters().stream().anyMatch(p2 -> p2.getName().equals(p1.getKey()))).forEach(param -> JpaUtils.setParameter(query, (String)param.getKey(), param.getValue()));
    }

    private void logParam(String nameParametro, Object value) {
        if (this.isShowLog()) {
            LogUtils.generate((String)("JARCH LOG PARAM: " + nameParametro + "=" + String.valueOf(value)));
        }
    }

    private boolean isShowLog() {
        return System.getProperty("JARCH.LOG.PARAMSEARCH", "N").equals("S");
    }

    @Override
    public void addParamValueWhereJpaId(String id, String nameParam, Object valueParam) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).addParamValueWhereJpa(nameParam, valueParam));
    }

    @Override
    public void removeParamValueWhereJpaId(String id, String nameParam) {
        if (this.notExistsFilter(id)) {
            return;
        }
        this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).getId().equals(id)).forEach(c -> ((FieldSearch)c.getValue()).removeParamValueWhereJpa(nameParam));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generateClauseWhere() {
        StringBuilder whereJpa = new StringBuilder();
        HashMap<String, String> whereFromToParameterUnbind = new HashMap<String, String>();
        for (FieldSearch fieldSearch : this.filters.values().stream().filter(Objects::nonNull).filter(FieldSearch::isActive).collect(Collectors.toList())) {
            if (!fieldSearch.isAddedValue() && (fieldSearch.getWhereJpa().isEmpty() || fieldSearch.getWhereJpa().contains(":")) || fieldSearch.isCheckbox() && !fieldSearch.isAddedValue() || fieldSearch.isCombobox() && !fieldSearch.isAddedValue() || fieldSearch.getAnnotation() == JArchSearchFieldCheckbox.class && !fieldSearch.getWhereJpa().isEmpty() && !Boolean.TRUE.equals(fieldSearch.getValue())) continue;
            if (fieldSearch.getAnnotation() == JArchSearchFieldComboboxCommandJpa.class && fieldSearch.getValue() != null && !fieldSearch.getValue().toString().isEmpty()) {
                Optional<Object> optional = fieldSearch.getItemsCombobox().stream().filter(t -> t.toString().equals(fieldSearch.getValue().toString())).findAny();
                if (optional.isPresent()) {
                    Object valueEnum = Enum.class.isAssignableFrom(optional.get().getClass()) ? optional.get() : Arrays.stream(fieldSearch.getClassEnum().getEnumConstants()).filter(l -> l.name().equals(fieldSearch.getValue().toString())).findAny().orElse(null);
                    Object commandJpa = "";
                    Field fieldValue = ReflectionUtils.getField(fieldSearch.getClassEnum(), (String)fieldSearch.getFieldValueCombobox(), (boolean)false);
                    if (fieldValue == null) {
                        Method getter = ReflectionUtils.getGetter(fieldSearch.getClassEnum(), (String)fieldSearch.getFieldValueCombobox(), (boolean)false);
                        if (getter != null) {
                            try {
                                commandJpa = getter.invoke(valueEnum, new Object[0]);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                LogUtils.generate((Throwable)e);
                            }
                        }
                    } else {
                        commandJpa = ReflectionUtils.getValueByField((Object)valueEnum, (Field)fieldValue);
                    }
                    whereJpa.append("AND ").append(commandJpa.toString().concat(" "));
                    continue;
                }
                whereJpa.append("AND ").append(fieldSearch.getValue().toString().concat(" "));
                continue;
            }
            if (!fieldSearch.getWhereJpa().isEmpty()) {
                whereJpa.append("AND ").append(fieldSearch.getWhereJpa().concat(" "));
            } else if (fieldSearch.isCollection()) {
                String string = fieldSearch.getCondition().equals((Object)ConditionSearchType.DIFFERENT) ? "NOT IN" : "IN";
                whereJpa.append("AND ").append(fieldSearch.getAttributeJpql(this.getClassEntity())).append(" ").append(string).append(" (:").append(fieldSearch.getParameterJpql()).append(") ");
            } else if (fieldSearch.isEntity()) {
                whereJpa.append("AND ").append(fieldSearch.getAttributeJpql(this.getClassEntity())).append(" = :").append(fieldSearch.getParameterJpql()).append(" ");
            } else if (fieldSearch.isComboboxCommandJpa()) {
                whereJpa.append("AND ").append(fieldSearch.getValue()).append(" ");
            } else {
                void var5_26;
                String string = "";
                String field = fieldSearch.getAttributeJpql(this.getClassEntity());
                if (fieldSearch.isAjustFilterMask()) {
                    String string2 = string + "AND ".concat(field);
                } else if (fieldSearch.isApplyLower()) {
                    String string3 = string + "AND (LOWER({field}) {condition} :{parameter} OR LOWER({field}) {condition} :{parameter}_NoCharEspecial) ";
                } else if (fieldSearch.isApplyTrunc()) {
                    String string4 = string + "AND TRUNC(".concat(field.concat(")"));
                } else {
                    String string5 = string + "AND ".concat(field);
                }
                boolean different = fieldSearch.getCondition().equals((Object)ConditionSearchType.DIFFERENT);
                boolean notContains = fieldSearch.getCondition().equals((Object)ConditionSearchType.NOT_CONTAINS);
                if (fieldSearch.isAjustFilterMask()) {
                    void var5_15;
                    if (different || notContains) {
                        String string6 = (String)var5_13 + " NOT";
                    }
                    String string7 = (String)var5_15 + " IN";
                } else if (!fieldSearch.isApplyLower()) {
                    String string8 = (String)var5_13 + " ".concat(fieldSearch.getCondition().getJpql());
                }
                if (fieldSearch.isApplyTrunc()) {
                    void var5_18;
                    String string9 = (String)var5_18 + " TRUNC(";
                }
                String nameParameter = fieldSearch.getParameterJpql();
                if (fieldSearch.isAjustFilterMask()) {
                    String string10 = (String)var5_20 + " :".concat(nameParameter);
                } else if (fieldSearch.isApplyLower()) {
                    String string11 = var5_20.replace("{field}", field).replace("{condition}", fieldSearch.getCondition().getJpql()).replace("{parameter}", nameParameter);
                } else {
                    String string12 = (String)var5_20 + " :".concat(nameParameter);
                }
                if (fieldSearch.isApplyTrunc()) {
                    void var5_24;
                    String string13 = (String)var5_24 + ")";
                }
                whereJpa.append(var5_26.concat(" "));
            }
            for (String parameterBind : fieldSearch.getParametersBind()) {
                Object value;
                if (fieldSearch.getId().equals(parameterBind)) {
                    value = fieldSearch.getValue();
                } else {
                    Map mapValue = (Map)this.filters.get(fieldSearch.getId()).getValue();
                    value = mapValue.get(parameterBind);
                }
                if (value == null) continue;
                whereFromToParameterUnbind.put(parameterBind, value.toString());
            }
        }
        if (whereJpa.length() > 0) {
            whereJpa = new StringBuilder("WHERE " + whereJpa.substring(4));
        }
        String whereJpaResult = whereJpa.toString();
        for (String string : whereFromToParameterUnbind.keySet()) {
            String value = (String)whereFromToParameterUnbind.get(string);
            whereJpaResult = whereJpaResult.replace(":" + string, value);
        }
        return whereJpaResult;
    }

    @Override
    public String generateClauseOrderBy() {
        return JpqlUtils.orderBy(this.getClassEntity(), this.listFieldOrder);
    }

    @Override
    public void savePageDataTable(int page) {
        this.first = page * this.maxResults;
    }

    @Override
    public final void saveLastSearch(Class<?> classe) {
        GlobalInformation.getInstance().set(SESSION_DOT + classe.getName() + DOT_LAST_FILTER, (Serializable)((Object)this.filters));
        GlobalInformation.getInstance().set(SESSION_DOT + classe.getName() + DOT_RECNO_START, Integer.valueOf(this.first));
        GlobalInformation.getInstance().set(SESSION_DOT + classe.getName() + DOT_RECNO_TOTAL, Integer.valueOf(this.total));
    }

    @Override
    public final void restoreLastSearch(Class<?> classe) {
        Integer totalRecno;
        Integer recnoFirst;
        Map fieldSearchMap = (Map)GlobalInformation.getInstance().get(SESSION_DOT + classe.getName() + DOT_LAST_FILTER);
        if (fieldSearchMap != null) {
            this.filters.putAll(fieldSearchMap);
        }
        if ((recnoFirst = (Integer)GlobalInformation.getInstance().get(SESSION_DOT + classe.getName() + DOT_RECNO_START)) != null) {
            this.first = recnoFirst;
        }
        if ((totalRecno = (Integer)GlobalInformation.getInstance().get(SESSION_DOT + classe.getName() + DOT_RECNO_TOTAL)) != null) {
            this.total = totalRecno;
        }
    }

    @Override
    public boolean isNullValue(String fieldOrId) {
        return this.filters.get(fieldOrId) == null || !this.filters.get(fieldOrId).isAddedValue();
    }

    @Override
    public boolean isNotNullValue(String fieldOrId) {
        return !this.isNullValue(fieldOrId);
    }

    @Override
    public Object getValue(String fieldOrId) {
        return this.filters.get(fieldOrId).getValue();
    }

    @Override
    public Optional<FieldSearch> getFieldSearch(String fieldOrId) {
        return this.filters.entrySet().stream().filter(es -> ((String)es.getKey()).equals(fieldOrId)).map(Map.Entry::getValue).findAny();
    }

    private void addOrderByFromEntity() {
        JArchOrderBy annotation = this.getClassEntity().getAnnotation(JArchOrderBy.class);
        if (annotation == null) {
            return;
        }
        this.listFieldOrder.clear();
        Arrays.stream(annotation.fields()).map(f -> f.desc() ? FieldOrder.desc(f.value()) : FieldOrder.asc(f.value())).forEach(this::addFieldOrder);
    }

    private Map<String, FieldSearch> filtersVisible() {
        return this.filters.entrySet().stream().filter(p -> ((FieldSearch)p.getValue()).isVisible()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void removeNotSearchFieldShow(Class<?> classAction) {
        if (classAction == null) {
            return;
        }
        JArchSearchFieldShow annotation = classAction.getAnnotation(JArchSearchFieldShow.class);
        if (annotation == null) {
            return;
        }
        ArrayList<String> listRemove = new ArrayList<String>();
        for (String field : this.filtersVisible().keySet()) {
            boolean visibleField = false;
            for (String campoTela : annotation.attributeOrId()) {
                if (!field.equals(campoTela) && !field.equals(campoTela + "1") && !field.equals(campoTela + "2")) continue;
                visibleField = true;
                break;
            }
            if (visibleField) continue;
            listRemove.add(field);
        }
        listRemove.forEach(a -> this.filters.entrySet().stream().filter(m -> ((String)m.getKey()).equals(a)).forEach(f -> ((FieldSearch)f.getValue()).hide()));
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public String getDescriptionFilter() {
        List list = this.getFilters().values().stream().filter(FieldSearch::isAddedValue).sorted(Comparator.comparing(FieldSearch::getRow, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(FieldSearch::getColumn, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
        String filter = list.stream().map(f -> (f.getDescription() == null ? "" : f.getDescription()) + (String)(f.getCondition() == null ? "" : (f.getCondition() == ConditionSearchType.EQUAL ? ": " : " " + f.getCondition().getDescription())) + " " + f.getFormattedValue()).collect(Collectors.joining(", "));
        return filter.isEmpty() ? BundleUtils.messageBundle("label.nenhumFiltro") : BundleUtils.messageBundle("label.filtros") + ": " + filter;
    }

    @Override
    public ColumnsList getColumnsList() {
        return this.columnsList;
    }

    @Override
    public void setColumnsList(ColumnsList columnsList) {
        this.columnsList = columnsList;
    }

    @Override
    public Class<?> getClassReturn() {
        return this.classReturn;
    }

    @Override
    public void setClassReturn(Class<?> classReturn) {
        this.classReturn = classReturn;
    }

    @Override
    public void addParam(String param, Object value) {
        this.params.put(param, value);
    }

    @Override
    public void removeParam(String param) {
        this.params.remove(param);
    }

    @Override
    public final Map<String, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public Optional<String> getLogicFrom() {
        return this.logicFrom == null ? Optional.empty() : Optional.of(this.logicFrom);
    }

    @Override
    public void setLogicFrom(String logicFrom) {
        this.logicFrom = logicFrom;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public List<String> getParamsConstructorClassReturn() {
        return List.of();
    }

    @Override
    public void setParamsConstructorClassReturn(List<String> paramsConstructorClassReturn) {
    }

    private boolean notExistsFilter(String fieldOrId) {
        boolean find;
        boolean bl = find = this.filters.get(fieldOrId) != null;
        if (!find) {
            LogUtils.warning((String)("###### FILTER: " + fieldOrId + " NOT FOUND ######"));
        }
        return !find;
    }

    @Override
    public boolean isTotalize() {
        return this.totalize;
    }

    @Override
    public void setTotalize(boolean totalize) {
        this.totalize = totalize;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    public void newWhereJpql(String id, String whereJpql) {
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchWhereJpa.class).id(id).hide().noClearValueByButton().active().where(whereJpql);
        this.filters.put(id, fieldSearch);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Event evt;
            CDI cdi = CDI.current();
            this.eventSearchConfig = evt = (Event)cdi.select(Event.class, new Annotation[]{JArchEventSearchConfigLiteral.INSTANCE}).get();
            this.eventSearchConfig.fire((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

