/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.exception.BaseException;
import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ErrorUtils {
    private ErrorUtils() {
    }

    public static String messageErro(Exception ex) {
        List<String> messages = ErrorUtils.messagesErro(ex);
        return String.join((CharSequence)"/n", messages);
    }

    public static List<String> messagesErro(Exception ex) {
        LogUtils.generate((Throwable)ex);
        ArrayList<String> errors = new ArrayList<Object>();
        if (OptimisticLockException.class.isAssignableFrom(ex.getClass())) {
            errors.add(BundleUtils.messageBundle("label.concorrencia") + ": " + BundleUtils.messageBundle("message.erroConcorrencia"));
        }
        Throwable first = ex;
        while (first.getCause() != null) {
            errors.addAll(ErrorUtils.extractErrorsFromConstraintViolation(first));
            errors.addAll(ErrorUtils.extractErrorsFromBaseException(first));
            first = first.getCause();
        }
        errors.addAll(ErrorUtils.extractErrorsFromConstraintViolation(first));
        errors.addAll(ErrorUtils.extractErrorsFromBaseException(first));
        ErrorUtils.extractOtherErrorFrom(first).ifPresent(errors::add);
        if (errors.isEmpty()) {
            errors.add(first.getCause() == null ? first.getMessage() : first.getCause().getMessage());
        }
        errors = errors.stream().distinct().collect(Collectors.toList());
        return errors;
    }

    private static List<String> extractErrorsFromConstraintViolation(Throwable exception) {
        ArrayList<String> result = new ArrayList<String>();
        if (ConstraintViolationException.class.isAssignableFrom(exception.getClass())) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)exception;
            for (ConstraintViolation cve : constraintViolationException.getConstraintViolations()) {
                String label;
                String messageErro = cve.getMessage();
                Pattern pattern = Pattern.compile("\\{(.*?)\\}");
                Matcher matcher = pattern.matcher(messageErro);
                while (matcher.find()) {
                    String key = matcher.group(1);
                    if (BeanValidationUtils.existsKeyBundle(key)) {
                        messageErro = messageErro.replace(matcher.group(0), BeanValidationUtils.messageBundle(key));
                        continue;
                    }
                    if (!BundleUtils.exists(key)) continue;
                    messageErro = messageErro.replace(matcher.group(0), BundleUtils.messageBundle(key));
                }
                Object messageErroNew = cve.getPropertyPath().toString().isBlank() ? messageErro : (String)(messageErro.startsWith(label = BundleUtils.messageBundle("label." + String.valueOf(cve.getPropertyPath())) + ": ") ? "" : label) + messageErro;
                result.add((String)messageErroNew);
            }
            result = new ArrayList(new HashSet(result));
        }
        return result.stream().map(e -> e.replace(": {0}:", ":").replace("??????:", "")).collect(Collectors.toList());
    }

    private static List<String> extractErrorsFromBaseException(Throwable throwable) {
        ArrayList<String> result = new ArrayList<String>();
        if (BaseException.class.isAssignableFrom(throwable.getClass())) {
            BaseException baseException = (BaseException)throwable;
            if (baseException.getListExceptions().isEmpty()) {
                result.add(baseException.getMessage());
            } else {
                baseException.getListExceptions().forEach(be -> result.add(be.getMessage()));
            }
        }
        return result;
    }

    private static Optional<String> extractOtherErrorFrom(Throwable exception) {
        if (!(ConstraintViolationException.class.isAssignableFrom(exception.getClass()) || BaseException.class.isAssignableFrom(exception.getClass()) || exception.getLocalizedMessage() == null || exception.getLocalizedMessage().isEmpty() || exception.getLocalizedMessage().startsWith(exception.getClass().getName()))) {
            return Optional.of(BundleUtils.messageBundle("label.erro") + ": " + exception.getLocalizedMessage());
        }
        return Optional.empty();
    }
}

