/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.model.IMultiTenantEntity;
import br.com.jarch.core.model.MultiTenant;
import jakarta.persistence.EntityManager;
import org.hibernate.Session;

public class EntityManagerFilterUtils {
    public static void addFilters(EntityManager entityManager) {
        EntityManagerFilterUtils.applyFilterMultiTenant(entityManager);
        EntityManagerFilterUtils.applyFilterExclusionLogic(entityManager);
    }

    private static void applyFilterExclusionLogic(EntityManager entityManager) {
        if (EntityManagerFilterUtils.isFilterExclusionLogic(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("exclusionLogic");
        }
    }

    private static void applyFilterMultiTenant(EntityManager entityManager) {
        if (MultiTenant.getInstance().notExists()) {
            return;
        }
        if (EntityManagerFilterUtils.isFilterBaseMultiTenant(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("tenantBase").setParameter("tenantId", (Object)MultiTenant.getInstance().get());
        }
        if (EntityManagerFilterUtils.isFilterCrudMultiTenant(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("tenantCrud").setParameter("tenantId", (Object)MultiTenant.getInstance().get());
        }
        if (EntityManagerFilterUtils.isFilterPessimistMultiTenant(entityManager)) {
            ((Session)entityManager.unwrap(Session.class)).enableFilter("tenantPessimist").setParameter("tenantId", (Object)MultiTenant.getInstance().get());
        }
    }

    private static boolean isFilterExclusionLogic(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().contains("exclusionLogic");
    }

    private static boolean isEntityExclusionLogic(Class<? extends IIdentity> classEntity) {
        return classEntity.isAnnotationPresent(JArchExclusionLogic.class);
    }

    private static boolean isFilterBaseMultiTenant(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().stream().anyMatch(f -> f.contains("tenantBase"));
    }

    private static boolean isFilterCrudMultiTenant(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().stream().anyMatch(f -> f.contains("tenantCrud"));
    }

    private static boolean isFilterPessimistMultiTenant(EntityManager entityManager) {
        return ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getDefinedFilterNames().stream().anyMatch(f -> f.contains("tenantPessimist"));
    }

    private static boolean isEntityMultiTenant(Class<? extends IIdentity> classEntity) {
        return IMultiTenantEntity.class.isAssignableFrom(classEntity);
    }
}

