/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.report;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import br.com.jarch.core.report.ReportBuilder;
import br.com.jarch.core.report.ReportGroup;
import br.com.jarch.core.report.ReportUtils;
import br.com.jarch.core.util.MessagePropertiesUtils;
import jakarta.persistence.metamodel.SingularAttribute;

public class ReportGroupBuilder {
    private GroupBuilder groupBuilder = new GroupBuilder();
    private DynamicReportBuilder dynamicReportBuilder;
    private Style styleHeader = new Style();
    private Style styleFooter;
    private Style styleColumn;

    private ReportGroupBuilder() {
        this.styleHeader.getFont().setBold(true);
        this.styleHeader.setHorizontalAlign(HorizontalAlign.CENTER);
        this.styleFooter = new Style();
        this.styleFooter.getFont().setBold(true);
        this.styleFooter.setHorizontalAlign(HorizontalAlign.CENTER);
        this.styleColumn = new Style();
        this.styleColumn.getFont().setBold(true);
        this.styleColumn.setHorizontalAlign(HorizontalAlign.CENTER);
    }

    public static ReportGroupBuilder createInstance(ReportBuilder reportBuilder, String attribute) {
        return ReportGroupBuilder.createInstance(reportBuilder, attribute, String.class);
    }

    public static ReportGroupBuilder createInstance(ReportBuilder reportBuilder, SingularAttribute<?, ?> attribute) {
        return ReportGroupBuilder.createInstance(reportBuilder, attribute.getName(), attribute.getJavaType());
    }

    public static ReportGroupBuilder createInstance(ReportBuilder reportBuilder, String attribute, Class<?> type) {
        ReportGroupBuilder reportGroupBuilder = new ReportGroupBuilder();
        reportGroupBuilder.dynamicReportBuilder = reportBuilder.getDynamicReportBuilder();
        AbstractColumn abstractColumn = ReportUtils.findColumn(reportGroupBuilder.dynamicReportBuilder, attribute);
        ReportUtils.format(type, abstractColumn, reportGroupBuilder.styleHeader, reportGroupBuilder.styleColumn);
        reportGroupBuilder.setCriteriaColumn((PropertyColumn)abstractColumn);
        return reportGroupBuilder;
    }

    public ReportGroupBuilder withFooterLabel(String text) {
        DJGroupLabel glabel = new DJGroupLabel(text, this.styleFooter);
        this.setFooterLabel(glabel);
        this.setGroupLayout(GroupLayout.DEFAULT);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(String attribute, DJCalculation dJCalculation) {
        this.addFooterVariable(null, attribute, dJCalculation);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(String title, String attribute, DJCalculation dJCalculation) {
        DJGroupLabel glabel = title == null ? null : new DJGroupLabel(title, this.styleFooter);
        Style style = DJCalculation.SUM.equals(dJCalculation) || DJCalculation.COUNT.equals(dJCalculation) || DJCalculation.AVERAGE.equals(dJCalculation) ? ReportUtils.cloneStyleRight(this.styleColumn) : this.styleColumn;
        AbstractColumn abstractColumn = ReportUtils.findColumn(this.dynamicReportBuilder, attribute);
        this.addFooterVariable(abstractColumn, dJCalculation, style, null, glabel);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(SingularAttribute<?, ?> attribute, DJCalculation dJCalculation) {
        this.addHeaderVariable(MessagePropertiesUtils.messageBundle("bundle.bundle", "label." + attribute.getName()), attribute.getName(), dJCalculation);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(String attribute, DJCalculation dJCalculation) {
        this.addHeaderVariable(null, attribute, dJCalculation);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(String title, String attribute, DJCalculation dJCalculation) {
        DJGroupLabel glabel = title == null ? null : new DJGroupLabel(title, this.styleHeader);
        AbstractColumn abstractColumn = ReportUtils.findColumn(this.dynamicReportBuilder, attribute);
        this.addHeaderVariable(abstractColumn, dJCalculation, this.styleColumn, null, glabel);
        return this;
    }

    public ReportGroup build() {
        ReportGroup reportGroup = new ReportGroup();
        reportGroup.setDjGroup(this.groupBuilder.build());
        return reportGroup;
    }

    public ReportGroupBuilder withHeaderFont(Font font) {
        this.styleHeader.setFont(font);
        return this;
    }

    public ReportGroupBuilder withHeaderFontSize(float size) {
        this.styleHeader.getFont().setFontSize(size);
        return this;
    }

    public ReportGroupBuilder withHeaderFontBold(boolean bold) {
        this.styleHeader.getFont().setBold(bold);
        return this;
    }

    public ReportGroupBuilder withHeaderFontItalic(boolean italic) {
        this.styleHeader.getFont().setItalic(italic);
        return this;
    }

    public ReportGroupBuilder withHeaderFontUnderline(boolean underline) {
        this.styleHeader.getFont().setUnderline(underline);
        return this;
    }

    public ReportGroupBuilder withHeaderFontAlign(HorizontalAlign horizontalAlign) {
        this.styleHeader.setHorizontalAlign(horizontalAlign);
        return this;
    }

    public ReportGroupBuilder withFooterFont(Font font) {
        this.styleFooter.setFont(font);
        return this;
    }

    public ReportGroupBuilder withFooterFontSize(float size) {
        this.styleFooter.getFont().setFontSize(size);
        return this;
    }

    public ReportGroupBuilder withFooterFontBold(boolean bold) {
        this.styleFooter.getFont().setBold(bold);
        return this;
    }

    public ReportGroupBuilder withFooterFontItalic(boolean italic) {
        this.styleFooter.getFont().setItalic(italic);
        return this;
    }

    public ReportGroupBuilder withFooterFontUnderline(boolean underline) {
        this.styleFooter.getFont().setUnderline(underline);
        return this;
    }

    public ReportGroupBuilder withFooterFontAlign(HorizontalAlign horizontalAlign) {
        this.styleFooter.setHorizontalAlign(horizontalAlign);
        return this;
    }

    public int hashCode() {
        return this.groupBuilder.hashCode();
    }

    public ReportGroupBuilder setCriteriaColumn(PropertyColumn column) {
        this.groupBuilder.setCriteriaColumn(column);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(DJGroupVariable variable) {
        this.groupBuilder.addHeaderVariable(variable);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation) {
        this.groupBuilder.addHeaderVariable(column, operation);
        return this;
    }

    public boolean equals(Object obj) {
        return this.groupBuilder.equals(obj);
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation, Style style) {
        this.groupBuilder.addHeaderVariable(column, operation, style);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation, Style style, DJValueFormatter formatter) {
        this.groupBuilder.addHeaderVariable(column, operation, style, formatter);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation, Style style, DJValueFormatter formatter, DJGroupLabel glabel1) {
        this.groupBuilder.addHeaderVariable(column, operation, style, formatter, glabel1);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.groupBuilder.addHeaderVariable(column, valueExpression);
        return this;
    }

    public ReportGroupBuilder addHeaderVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.groupBuilder.addHeaderVariable(column, valueExpression, style);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(DJGroupVariable variable) {
        this.groupBuilder.addFooterVariable(variable);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation) {
        this.groupBuilder.addFooterVariable(column3, operation);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation, Style style) {
        this.groupBuilder.addFooterVariable(column3, operation, style);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation, Style style, DJValueFormatter valueFormatter) {
        this.groupBuilder.addFooterVariable(column3, operation, style, valueFormatter);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation, Style style, DJValueFormatter valueFormatter, DJGroupLabel label) {
        this.groupBuilder.addFooterVariable(column3, operation, style, valueFormatter, label);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.groupBuilder.addFooterVariable(column, valueExpression);
        return this;
    }

    public ReportGroupBuilder addFooterVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.groupBuilder.addFooterVariable(column, valueExpression, style);
        return this;
    }

    public ReportGroupBuilder addVariable(String name, String property, String className, DJCalculation operation) {
        this.groupBuilder.addVariable(name, property, className, operation);
        return this;
    }

    public ReportGroupBuilder addVariable(String name, ColumnProperty prop, DJCalculation operation) {
        this.groupBuilder.addVariable(name, prop, operation);
        return this;
    }

    public ReportGroupBuilder addVariable(String name, AbstractColumn column, DJCalculation operation) {
        this.groupBuilder.addVariable(name, column, operation);
        return this;
    }

    public ReportGroupBuilder setHeaderHeight(int height) {
        this.groupBuilder.setHeaderHeight(height);
        return this;
    }

    public ReportGroupBuilder setHeaderHeight(int height, boolean fitHeightToContent) {
        this.groupBuilder.setHeaderHeight(height, fitHeightToContent);
        return this;
    }

    public ReportGroupBuilder setFooterHeight(int height) {
        this.groupBuilder.setFooterHeight(height);
        return this;
    }

    public ReportGroupBuilder setFooterHeight(int height, boolean fitHeightToConent) {
        this.groupBuilder.setFooterHeight(height, fitHeightToConent);
        return this;
    }

    public ReportGroupBuilder setHeaderVariablesHeight(int height) {
        this.groupBuilder.setHeaderVariablesHeight(height);
        return this;
    }

    public ReportGroupBuilder setFooterVariablesHeight(int height) {
        this.groupBuilder.setFooterVariablesHeight(height);
        return this;
    }

    public ReportGroupBuilder setGroupLayout(GroupLayout layout) {
        this.groupBuilder.setGroupLayout(layout);
        return this;
    }

    public ReportGroupBuilder setDefaultFooterVariableStyle(Style defaultFooterVariableStyle) {
        this.groupBuilder.setDefaultFooterVariableStyle(defaultFooterVariableStyle);
        return this;
    }

    public ReportGroupBuilder setDefaultHeaderVariableStyle(Style defaultHeaderVariableStyle) {
        this.groupBuilder.setDefaultHeaderVariableStyle(defaultHeaderVariableStyle);
        return this;
    }

    public String toString() {
        return this.groupBuilder.toString();
    }

    public ReportGroupBuilder addHeaderSubreport(Subreport subreport) {
        this.groupBuilder.addHeaderSubreport(subreport);
        return this;
    }

    public ReportGroupBuilder addFooterSubreport(Subreport subreport) {
        this.groupBuilder.addFooterSubreport(subreport);
        return this;
    }

    public ReportGroupBuilder setStartInNewPage(boolean bool) {
        this.groupBuilder.setStartInNewPage(bool);
        return this;
    }

    public ReportGroupBuilder setStartInNewColumn(boolean bool) {
        this.groupBuilder.setStartInNewColumn(bool);
        return this;
    }

    public ReportGroupBuilder addColumnHeaderStyle(AbstractColumn column, Style style) {
        this.groupBuilder.addColumnHeaderStyle(column, style);
        return this;
    }

    public ReportGroupBuilder setDefaultColumnHeaderStyle(Style style) {
        this.groupBuilder.setDefaultColumnHeaderStyle(style);
        return this;
    }

    public ReportGroupBuilder setAllowHeaderSplit(boolean headerSplit) {
        this.groupBuilder.setAllowHeaderSplit(headerSplit);
        return this;
    }

    public ReportGroupBuilder setAllowFooterSplit(boolean footerSplit) {
        this.groupBuilder.setAllowFooterSplit(footerSplit);
        return this;
    }

    public ReportGroupBuilder setAllowSplitting(boolean headerSplit, boolean footerSplit) {
        this.groupBuilder.setAllowSplitting(headerSplit, footerSplit);
        return this;
    }

    public ReportGroupBuilder setFooterLabel(DJGroupLabel label) {
        this.groupBuilder.setFooterLabel(label);
        return this;
    }

    public ReportGroupBuilder setReprintHeaderOnEachPage(boolean bool) {
        this.groupBuilder.setReprintHeaderOnEachPage(bool);
        return this;
    }

    public ReportGroupBuilder addHeaderCrosstab(DJCrosstab cross) {
        this.groupBuilder.addHeaderCrosstab(cross);
        return this;
    }

    public ReportGroupBuilder addFooterCrosstab(DJCrosstab cross) {
        this.groupBuilder.addFooterCrosstab(cross);
        return this;
    }

    public ReportGroupBuilder setResetPageNumber(boolean resetPageNumber) {
        this.groupBuilder.setResetPageNumber(resetPageNumber);
        return this;
    }
}

