/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.report;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.JasperDesignDecorator;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DJWaterMark;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.ImageBanner;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.crud.report.FileResultDto;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.report.ReportGroup;
import br.com.jarch.core.report.ReportSubReport;
import br.com.jarch.core.report.ReportUtils;
import br.com.jarch.core.type.FileType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.MessagePropertiesUtils;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.LogUtils;
import jakarta.persistence.metamodel.SingularAttribute;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;

public class ReportBuilder {
    private final DynamicReportBuilder dynamicReportBuilder = new DynamicReportBuilder();
    private String title;
    private String templateJrxml;
    private Collection<?> listData;
    private Map<String, Object> parameters;
    private ar.com.fdvs.dj.domain.constants.Font fontColumnHeader;
    private ar.com.fdvs.dj.domain.constants.Font fontDetail;
    private ar.com.fdvs.dj.domain.constants.Font fontGrandTotal;
    private Style styleColumnHeader;
    private Style styleDetail;
    private Style styleSubtitle;
    private Style styleGrandTotal;

    protected ReportBuilder() {
        this.dynamicReportBuilder.setReportLocale(GlobalInformation.getInstance().getLocale());
        this.dynamicReportBuilder.setTitleStyle(this.defaultStyleTitle());
        this.dynamicReportBuilder.setSubtitleStyle(this.defaultStyleSubTitle());
        this.setPrintBackgroundOnOddRows(true);
        this.setPrintColumnNames(true);
        this.setUseFullPageWidth(true);
        this.setAllowDetailSplit(true);
        Style oddRowBackgroundStyle = new StyleBuilder(false, "defaultOddRowStyle").setBackgroundColor(new Color(240, 240, 240, 128)).build();
        this.setOddRowBackgroundStyle(oddRowBackgroundStyle);
        this.parameters = new HashMap<String, Object>();
        this.fontColumnHeader = new ar.com.fdvs.dj.domain.constants.Font();
        this.fontColumnHeader.setBold(true);
        this.fontColumnHeader.setFontSize(8.0f);
        this.styleColumnHeader = new StyleBuilder(false).setFont(this.fontColumnHeader).build();
        this.styleColumnHeader.setTransparency(Transparency.OPAQUE);
        this.styleColumnHeader.setHorizontalAlign(HorizontalAlign.LEFT);
        this.styleColumnHeader.setBorder(Border.PEN_1_POINT());
        this.fontGrandTotal = new ar.com.fdvs.dj.domain.constants.Font();
        this.fontGrandTotal.setBold(true);
        this.fontGrandTotal.setFontSize(8.0f);
        this.styleGrandTotal = new StyleBuilder(false).setFont(this.fontGrandTotal).build();
        this.styleGrandTotal.setHorizontalAlign(HorizontalAlign.RIGHT);
        this.styleGrandTotal.setBorderBottom(Border.THIN());
        this.styleGrandTotal.setVerticalAlign(VerticalAlign.TOP);
        this.styleGrandTotal.setStretchWithOverflow(true);
        this.styleSubtitle = new StyleBuilder(false).setBorderBottom(Border.PEN_1_POINT()).build();
        this.fontDetail = new ar.com.fdvs.dj.domain.constants.Font();
        this.fontDetail.setFontSize(8.0f);
        this.styleDetail = new StyleBuilder(false).setFont(this.fontDetail).build();
        this.styleDetail.setHorizontalAlign(HorizontalAlign.LEFT);
    }

    public static ReportBuilder createInstance() {
        return new ReportBuilder();
    }

    public DynamicReportBuilder getDynamicReportBuilder() {
        return this.dynamicReportBuilder;
    }

    public FileResultDto exportFormatPdf() throws JRException, IOException {
        return this.exportFormatPdf("Report");
    }

    public FileResultDto exportFormatPdf(String name) throws JRException, IOException {
        return this.generateReport(name, FileType.PDF);
    }

    public FileResultDto exportFormatTxt(String name) throws JRException, IOException {
        return this.generateReport(name, FileType.TXT);
    }

    public FileResultDto generateReport(String name, FileType type) throws IOException, JRException {
        if (type != FileType.PDF && type != FileType.TXT) {
            throw new ValidationException(BundleUtils.messageBundle("label.tipoNaoSuportado"));
        }
        DynamicReport dynamicReport = this.dynamicReportBuilder.build();
        File arquivoPdfGeracao = File.createTempFile(name, "." + type.name().toLowerCase());
        String path = arquivoPdfGeracao.getPath().substring(0, arquivoPdfGeracao.getPath().indexOf(arquivoPdfGeracao.getName()));
        JRFileVirtualizer virtualizer = new JRFileVirtualizer(5, path);
        this.parameters.put("REPORT_VIRTUALIZER", virtualizer);
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(this.listData);
        JasperPrint jasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)dynamicReport, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds, this.parameters);
        FileInputStream fileInputStream = new FileInputStream(arquivoPdfGeracao.getAbsolutePath());
        if (type == FileType.PDF) {
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)arquivoPdfGeracao.getAbsolutePath());
        } else if (type == FileType.TXT) {
            JRTextExporter exporter = new JRTextExporter();
            try {
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)200);
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)100);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)arquivoPdfGeracao.getAbsolutePath());
                exporter.exportReport();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
                throw new ValidationException(ex);
            }
        }
        return new FileResultDto(type, fileInputStream);
    }

    public ReportBuilder addFieldNumber(SingularAttribute<?, ? extends Number> attribute, Integer width, boolean printRepeatedValues, boolean addTotal) {
        return this.addFieldNumber(MessagePropertiesUtils.messageBundle("bundle.bundle", "label." + attribute.getName()), attribute.getName(), width, attribute.getJavaType(), printRepeatedValues, addTotal);
    }

    public ReportBuilder addFieldNumber(String title, String attribute, Integer width, Class<? extends Number> type, boolean printRepeatedValues, boolean addTotal) {
        this.addField(title, attribute, width, type, printRepeatedValues);
        if (addTotal) {
            this.addGlobalFooterVariable(attribute, DJCalculation.SUM);
        }
        return this;
    }

    public ReportBuilder addField(SingularAttribute<?, ?> attribute, Integer width) {
        this.addField(MessagePropertiesUtils.messageBundle("bundle.bundle", "label." + attribute.getName()), attribute.getName(), width, attribute.getJavaType(), true);
        return this;
    }

    public ReportBuilder addField(String title, String attribute, Integer width, Class<?> type) {
        this.addField(title, attribute, width, type, true);
        return this;
    }

    public ReportBuilder addField(SingularAttribute<?, ?> attribute, Integer width, boolean printRepeatedValues) {
        return this.addField(MessagePropertiesUtils.messageBundle("bundle.bundle", "label." + attribute.getName()), attribute.getName(), width, attribute.getJavaType(), printRepeatedValues);
    }

    public ReportBuilder addField(String title, final String attribute, Integer width, Class<?> type, boolean printRepeatedValues) {
        ColumnBuilder columnBuilder = ColumnBuilder.getNew().setTitle(title).setColumnProperty(attribute, type).setWidth(width.intValue()).setHeaderStyle(this.styleColumnHeader).setStyle(this.styleDetail).setPrintRepeatedValues(printRepeatedValues);
        if (Boolean.class.isAssignableFrom(type)) {
            columnBuilder.setCustomExpression(new CustomExpression(){

                public Object evaluate(Map fields, Map variables, Map parameters) {
                    Boolean value = (Boolean)fields.get(attribute);
                    if (value != null && value.booleanValue()) {
                        return BundleUtils.messageBundle("label.sim");
                    }
                    return BundleUtils.messageBundle("label.nao");
                }

                public String getClassName() {
                    return String.class.getName();
                }
            });
        } else if (LocalDate.class.isAssignableFrom(type)) {
            columnBuilder.setCustomExpression(new CustomExpression(){

                public Object evaluate(Map fields, Map variables, Map parameters) {
                    LocalDate value = (LocalDate)fields.get(attribute);
                    if (value != null) {
                        return DateUtils.formatddMMyyyy((LocalDate)value);
                    }
                    return null;
                }

                public String getClassName() {
                    return String.class.getName();
                }
            });
        } else if (LocalDateTime.class.isAssignableFrom(type)) {
            columnBuilder.setCustomExpression(new CustomExpression(){

                public Object evaluate(Map fields, Map variables, Map parameters) {
                    LocalDateTime value = (LocalDateTime)fields.get(attribute);
                    if (value != null) {
                        return DateUtils.formatddMMyyyyHHmm((LocalDateTime)value);
                    }
                    return null;
                }

                public String getClassName() {
                    return String.class.getName();
                }
            });
        } else if (YearMonth.class.isAssignableFrom(type)) {
            columnBuilder.setCustomExpression(new CustomExpression(){

                public Object evaluate(Map fields, Map variables, Map parameters) {
                    YearMonth value = (YearMonth)fields.get(attribute);
                    if (value != null) {
                        return value.format(DateTimeFormatter.ofPattern("MM/yyyy"));
                    }
                    return null;
                }

                public String getClassName() {
                    return String.class.getName();
                }
            });
        }
        AbstractColumn abstractColumn = columnBuilder.build();
        ReportUtils.format(type, abstractColumn, this.styleColumnHeader, this.styleDetail);
        this.addColumn(abstractColumn);
        return this;
    }

    public ReportBuilder addGroup(ReportGroup reportGroup) {
        this.addGroup(reportGroup.getDjGroup());
        return this;
    }

    public ReportBuilder addSubReport(ReportSubReport reportSubReport, SingularAttribute<?, ?> attribute, Integer numberGroup) {
        return this.addSubReport(reportSubReport, attribute.getName(), numberGroup);
    }

    public ReportBuilder addSubReport(ReportSubReport reportSubReport, String attribute, Integer numberGroup) {
        this.addSubreportInGroupFooter(numberGroup, reportSubReport, (LayoutManager)new ClassicLayoutManager(), attribute, 1, 0, null);
        return this;
    }

    public ReportBuilder addProperty(SingularAttribute<?, ?> attribute) {
        return this.addProperty(attribute.getName(), attribute.getJavaType().getName());
    }

    public ReportBuilder addProperty(String attribute, String type) {
        ColumnProperty columnProperty = new ColumnProperty();
        columnProperty.setProperty(attribute);
        columnProperty.setValueClassName(type);
        this.getFields().add(columnProperty);
        return this;
    }

    public ReportBuilder addGrandTotalLegend(String title) {
        this.setGrandTotalLegend(title);
        this.setGrandTotalLegendStyle(this.styleGrandTotal);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(SingularAttribute<?, ?> attribute, DJCalculation djCalculation) {
        return this.addGlobalFooterVariable(MessagePropertiesUtils.messageBundle("bundle.bundle", "label." + attribute.getName()), attribute.getName(), djCalculation);
    }

    public ReportBuilder addGlobalFooterVariable(String attribute, DJCalculation djCalculation) {
        Style style = djCalculation == DJCalculation.SUM || djCalculation == DJCalculation.COUNT ? ReportUtils.cloneStyleRight(this.styleGrandTotal) : this.styleGrandTotal;
        return this.addGlobalFooterVariable(attribute, djCalculation, style);
    }

    public ReportBuilder addGlobalFooterVariable(String attribute, DJCalculation djCalculation, Style style) {
        this.addGlobalFooterVariable(ReportUtils.findColumn(this.dynamicReportBuilder, attribute), djCalculation, style);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(final String title, String attribute, DJCalculation djCalculation) {
        DJValueFormatter djValueFormatter = new DJValueFormatter(){

            public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
                if (value != null) {
                    return title + " " + String.valueOf(value);
                }
                return title;
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
        AbstractColumn column = ReportUtils.findColumn(this.dynamicReportBuilder, attribute);
        this.addGlobalFooterVariable(column, djCalculation, this.styleGrandTotal, djValueFormatter);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ReportBuilder withPortraitOrientation() {
        this.setPageSizeAndOrientation(Page.Page_A4_Portrait());
        return this;
    }

    public ReportBuilder withLandscapeOrientation() {
        this.setPageSizeAndOrientation(Page.Page_A4_Landscape());
        return this;
    }

    public Collection<?> getListData() {
        return this.listData;
    }

    public ReportBuilder withListData(Collection<?> listData) {
        this.listData = listData;
        return this;
    }

    public ReportBuilder addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameters() {
        return this.parameters.toString();
    }

    public ReportBuilder withTemplateJrxml(String templateJrxml) {
        this.templateJrxml = templateJrxml;
        this.dynamicReportBuilder.setTemplateFile(templateJrxml);
        return this;
    }

    public String getTemplateJrxml() {
        return this.templateJrxml;
    }

    public ReportBuilder withColumnHeaderFont(ar.com.fdvs.dj.domain.constants.Font font) {
        this.styleColumnHeader.setFont(font);
        return this;
    }

    public ReportBuilder withColumnHeaderFontSize(float size) {
        this.styleColumnHeader.getFont().setFontSize(size);
        return this;
    }

    public ReportBuilder withColumnHeaderFontBold(boolean bold) {
        this.styleColumnHeader.getFont().setBold(bold);
        return this;
    }

    public ReportBuilder withColumnHeaderFontItalic(boolean italic) {
        this.styleColumnHeader.getFont().setItalic(italic);
        return this;
    }

    public ReportBuilder withColumnHeaderFontUnderline(boolean underline) {
        this.styleColumnHeader.getFont().setUnderline(underline);
        return this;
    }

    public ReportBuilder setColumnHeaderBorder(Border border) {
        this.styleColumnHeader.setBorder(border);
        return this;
    }

    public ReportBuilder setColumnHeaderBackgroundColor(Color color) {
        this.styleColumnHeader.setBackgroundColor(color);
        return this;
    }

    public ReportBuilder withDetailFont(ar.com.fdvs.dj.domain.constants.Font font) {
        this.styleDetail.setFont(font);
        return this;
    }

    public ReportBuilder withDetailFontSize(float size) {
        this.styleDetail.getFont().setFontSize(size);
        return this;
    }

    public ReportBuilder withDetailFontBold(boolean bold) {
        this.styleDetail.getFont().setBold(bold);
        return this;
    }

    public ReportBuilder withDetailFontItalic(boolean italic) {
        this.styleDetail.getFont().setItalic(italic);
        return this;
    }

    public ReportBuilder withDetailFontUnderline(boolean underline) {
        this.styleDetail.getFont().setUnderline(underline);
        return this;
    }

    public ReportBuilder setDetailBorder(Border border) {
        this.styleDetail.setBorder(border);
        return this;
    }

    public ReportBuilder setDetailBackgroundColor(Color color) {
        this.styleDetail.setBackgroundColor(color);
        return this;
    }

    public ReportBuilder withGrandTotalFont(ar.com.fdvs.dj.domain.constants.Font font) {
        this.styleGrandTotal.setFont(font);
        return this;
    }

    public ReportBuilder withGrandTotalFontSize(float size) {
        this.styleGrandTotal.getFont().setFontSize(size);
        return this;
    }

    public ReportBuilder withGrandTotalFontBold(boolean bold) {
        this.styleGrandTotal.getFont().setBold(bold);
        return this;
    }

    public ReportBuilder withGrandTotalFontItalic(boolean italic) {
        this.styleGrandTotal.getFont().setItalic(italic);
        return this;
    }

    public ReportBuilder withGrandTotalFontUnderline(boolean underline) {
        this.styleGrandTotal.getFont().setUnderline(underline);
        return this;
    }

    public ReportBuilder setGrandTotalBorder(Border border) {
        this.styleGrandTotal.setBorder(border);
        return this;
    }

    public ReportBuilder setGrandTotalBackgroundColor(Color color) {
        this.styleGrandTotal.setBackgroundColor(color);
        return this;
    }

    public int hashCode() {
        return this.dynamicReportBuilder.hashCode();
    }

    public boolean equals(Object obj) {
        return this.dynamicReportBuilder.equals(obj);
    }

    public ReportBuilder addAutoText(AutoText text) {
        this.dynamicReportBuilder.addAutoText(text);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, pattern);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern, int width, int width2) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, pattern, width, width2);
        return this;
    }

    public ReportBuilder addAutoText(String message, byte position, byte alignment) {
        this.dynamicReportBuilder.addAutoText(message, position, alignment);
        return this;
    }

    public ReportBuilder addAutoText(String message, byte position, byte alignment, int width) {
        this.dynamicReportBuilder.addAutoText(message, position, alignment, width);
        return this;
    }

    public String toString() {
        return this.dynamicReportBuilder.toString();
    }

    public ReportBuilder addAutoText(String message, byte position, byte alignment, int width, Style style) {
        this.dynamicReportBuilder.addAutoText(message, position, alignment, width, style);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, width, width2);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2, Style style) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, width, width2, style);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2, int pageOffset, Style style) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, width, width2, pageOffset, style);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2, int pageOffset, boolean useI18n, Style style) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment, width, width2, pageOffset, useI18n, style);
        return this;
    }

    public ReportBuilder addAutoText(byte type, byte position, byte alignment) {
        this.dynamicReportBuilder.addAutoText(type, position, alignment);
        return this;
    }

    public ReportBuilder setTitle(String title) {
        this.dynamicReportBuilder.setTitle(title);
        return this;
    }

    public ReportBuilder setTitleIsJrExpression(boolean isExpression) {
        this.dynamicReportBuilder.setTitleIsJrExpression(isExpression);
        return this;
    }

    public ReportBuilder setReportName(String reportName) {
        this.dynamicReportBuilder.setReportName(reportName);
        return this;
    }

    public ReportBuilder setSubtitle(String subtitle) {
        this.dynamicReportBuilder.setSubtitle(subtitle);
        return this;
    }

    public ReportBuilder addColumn(AbstractColumn column) {
        this.dynamicReportBuilder.addColumn(column);
        return this;
    }

    public List getColumns() {
        return this.dynamicReportBuilder.getColumns();
    }

    public ReportBuilder addGroup(DJGroup group) {
        this.dynamicReportBuilder.addGroup(group);
        return this;
    }

    public ReportBuilder setHeaderHeight(int height) {
        this.dynamicReportBuilder.setHeaderHeight(height);
        return this;
    }

    public ReportBuilder setFooterVariablesHeight(int height) {
        this.dynamicReportBuilder.setFooterVariablesHeight(height);
        return this;
    }

    public ReportBuilder setHeaderVariablesHeight(int height) {
        this.dynamicReportBuilder.setHeaderVariablesHeight(height);
        return this;
    }

    public ReportBuilder setDetailHeight(int height) {
        this.dynamicReportBuilder.setDetailHeight(height);
        return this;
    }

    public ReportBuilder setLeftMargin(int margin) {
        this.dynamicReportBuilder.setLeftMargin(margin);
        return this;
    }

    public ReportBuilder setRightMargin(int margin) {
        this.dynamicReportBuilder.setRightMargin(margin);
        return this;
    }

    public ReportBuilder setTopMargin(int margin) {
        this.dynamicReportBuilder.setTopMargin(margin);
        return this;
    }

    public ReportBuilder setBottomMargin(int margin) {
        this.dynamicReportBuilder.setBottomMargin(margin);
        return this;
    }

    public ReportBuilder setColumnsPerPage(int numColumns) {
        this.dynamicReportBuilder.setColumnsPerPage(numColumns);
        return this;
    }

    public ReportBuilder setColumnsPerPage(int numColumns, int columnSpace) {
        this.dynamicReportBuilder.setColumnsPerPage(numColumns, columnSpace);
        return this;
    }

    public ReportBuilder setColumnSpace(int columSpace) {
        this.dynamicReportBuilder.setColumnSpace(columSpace);
        return this;
    }

    public ReportBuilder setPrintColumnNames(boolean bool) {
        this.dynamicReportBuilder.setPrintColumnNames(bool);
        return this;
    }

    public ReportBuilder setIgnorePagination(boolean bool) {
        this.dynamicReportBuilder.setIgnorePagination(bool);
        return this;
    }

    public ReportBuilder setUseFullPageWidth(boolean useFullwidth) {
        this.dynamicReportBuilder.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public ReportBuilder setTitleStyle(Style titleStyle) {
        this.dynamicReportBuilder.setTitleStyle(titleStyle);
        return this;
    }

    public ReportBuilder setSubtitleStyle(Style subtitleStyle) {
        this.dynamicReportBuilder.setSubtitleStyle(subtitleStyle);
        return this;
    }

    public ReportBuilder setPrintBackgroundOnOddRows(boolean printBackgroundOnOddRows) {
        this.dynamicReportBuilder.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public ReportBuilder setOddRowBackgroundStyle(Style oddRowBackgroundStyle) {
        this.dynamicReportBuilder.setOddRowBackgroundStyle(oddRowBackgroundStyle);
        return this;
    }

    public ReportBuilder setGrandTotalLegend(String title) {
        this.dynamicReportBuilder.setGrandTotalLegend(title);
        return this;
    }

    public ReportBuilder setGlobalHeaderVariableHeight(int height) {
        this.dynamicReportBuilder.setGlobalHeaderVariableHeight(height);
        return this;
    }

    public ReportBuilder setGlobalFooterVariableHeight(int height) {
        this.dynamicReportBuilder.setGlobalFooterVariableHeight(height);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(col, op);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op, Style style) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(col, op, style);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(col, op, style, valueFormatter);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(DJGroupVariable variable) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(variable);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(column, valueExpression);
        return this;
    }

    public ReportBuilder addGlobalHeaderVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.dynamicReportBuilder.addGlobalHeaderVariable(column, valueExpression, style);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalFooterVariable(col, op);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op, Style style) {
        this.dynamicReportBuilder.addGlobalFooterVariable(col, op, style);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        this.dynamicReportBuilder.addGlobalFooterVariable(col, op, style, valueFormatter);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(DJGroupVariable variable) {
        this.dynamicReportBuilder.addGlobalFooterVariable(variable);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.dynamicReportBuilder.addGlobalFooterVariable(column, valueExpression);
        return this;
    }

    public ReportBuilder addGlobalFooterVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.dynamicReportBuilder.addGlobalFooterVariable(column, valueExpression, style);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, col, op);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op, Style style) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, col, op, style);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, col, op, style, valueFormatter);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, DJGroupVariable variable) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, variable);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, AbstractColumn column, CustomExpression valueExpression) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, column, valueExpression);
        return this;
    }

    public ReportBuilder addGlobalColumnVariable(String position, AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.dynamicReportBuilder.addGlobalColumnVariable(position, column, valueExpression, style);
        return this;
    }

    public ReportBuilder addGlobalVariable(String name, AbstractColumn col, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalVariable(name, col, op);
        return this;
    }

    public ReportBuilder addGlobalVariable(String name, ColumnProperty prop, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalVariable(name, prop, op);
        return this;
    }

    public ReportBuilder addGlobalVariable(String name, String property, String className, DJCalculation op) {
        this.dynamicReportBuilder.addGlobalVariable(name, property, className, op);
        return this;
    }

    public ReportBuilder setTitleHeight(int height) {
        this.dynamicReportBuilder.setTitleHeight(height);
        return this;
    }

    public ReportBuilder setSubtitleHeight(int height) {
        this.dynamicReportBuilder.setSubtitleHeight(height);
        return this;
    }

    public ReportBuilder setPageSizeAndOrientation(Page page) {
        this.dynamicReportBuilder.setPageSizeAndOrientation(page);
        return this;
    }

    public ReportBuilder addImageBanner(String path, int width, int height, ImageBanner.Alignment alignment) {
        this.dynamicReportBuilder.addImageBanner(path, width, height, alignment);
        return this;
    }

    public ReportBuilder addImageBanner(String path, int width, int height, ImageBanner.Alignment alignment, ImageScaleMode scaleMode) {
        this.dynamicReportBuilder.addImageBanner(path, width, height, alignment, scaleMode);
        return this;
    }

    public ReportBuilder addFooterImageBanner(String path, int width, int height, ImageBanner.Alignment alignment, ImageScaleMode scaleMode) {
        this.dynamicReportBuilder.addFooterImageBanner(path, width, height, alignment, scaleMode);
        return this;
    }

    public ReportBuilder addFirstPageImageBanner(String path, int width, int height, ImageBanner.Alignment align) {
        this.dynamicReportBuilder.addFirstPageImageBanner(path, width, height, align);
        return this;
    }

    public ReportBuilder addFirstPageFooterImageBanner(String path, int width, int height, ImageBanner.Alignment alignment) {
        this.dynamicReportBuilder.addFirstPageFooterImageBanner(path, width, height, alignment);
        return this;
    }

    public ReportBuilder addFirstPageImageBanner(String path, int width, int height, ImageBanner.Alignment alignment, ImageScaleMode scaleMode) {
        this.dynamicReportBuilder.addFirstPageImageBanner(path, width, height, alignment, scaleMode);
        return this;
    }

    public ReportBuilder addField(String name, String className) {
        this.dynamicReportBuilder.addField(name, className);
        return this;
    }

    public ReportBuilder addField(String name, Class clazz) {
        this.dynamicReportBuilder.addField(name, clazz);
        return this;
    }

    public ReportBuilder addField(ColumnProperty columnProperty) {
        this.dynamicReportBuilder.addField(columnProperty);
        return this;
    }

    public List<ColumnProperty> getFields() {
        return this.dynamicReportBuilder.getFields();
    }

    public ReportBuilder addChart(DJChart djChart) {
        this.dynamicReportBuilder.addChart(djChart);
        return this;
    }

    public ReportBuilder setTemplateFile(String path) {
        this.dynamicReportBuilder.setTemplateFile(path);
        return this;
    }

    public ReportBuilder setTemplateFile(String path, boolean importFields, boolean importVariables, boolean importParameters, boolean importDatasets) {
        this.dynamicReportBuilder.setTemplateFile(path, importFields, importVariables, importParameters, importDatasets);
        return this;
    }

    public ReportBuilder setMargins(int top, int bottom, int left, int right) {
        this.dynamicReportBuilder.setMargins(top, bottom, left, right);
        return this;
    }

    public ReportBuilder setDefaultStyles(Style title, Style subtitle, Style columnHeader, Style columDetail) {
        this.dynamicReportBuilder.setDefaultStyles(title, subtitle, columnHeader, columDetail);
        return this;
    }

    public ReportBuilder setReportLocale(Locale locale) {
        this.dynamicReportBuilder.setReportLocale(locale);
        return this;
    }

    public ReportBuilder addConcatenatedReport(Subreport subreport) {
        this.dynamicReportBuilder.addConcatenatedReport(subreport);
        return this;
    }

    public ReportBuilder addConcatenatedReport(DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addConcatenatedReport(dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addConcatenatedReport(DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startOnNewPage) throws DJBuilderException {
        this.dynamicReportBuilder.addConcatenatedReport(dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, startOnNewPage);
        return this;
    }

    public ReportBuilder addConcatenatedReport(JasperReport jasperReport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addConcatenatedReport(jasperReport, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addConcatenatedReport(JasperReport jasperReport, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startOnNewPage) throws DJBuilderException {
        this.dynamicReportBuilder.addConcatenatedReport(jasperReport, dataSourcePath, dataSourceOrigin, dataSourceType, startOnNewPage);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, Subreport subreport) {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, subreport);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, ReportSubReport reportSubReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, reportSubReport.getDynamicReport(), layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params);
        return this;
    }

    public ReportBuilder addSubreportInGroup(String position, int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroup(position, groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage, fitParent);
        return this;
    }

    public ReportBuilder addSubreportInGroup(String position, int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroup(position, groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage, fitParent);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage, fitParent);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, pathToSubreport, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startInNewPage) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupFooter(groupNumber, pathToSubreport, dataSourcePath, dataSourceOrigin, dataSourceType, startInNewPage);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, Subreport subreport) {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, subreport);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addSubreportInGroupHeader(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        this.dynamicReportBuilder.addSubreportInGroupHeader(groupNumber, pathToSubreport, dataSourcePath, dataSourceOrigin, dataSourceType);
        return this;
    }

    public ReportBuilder addStyle(Style style) throws DJBuilderException {
        this.dynamicReportBuilder.addStyle(style);
        return this;
    }

    public ReportBuilder setResourceBundle(String resourceBundle) {
        this.dynamicReportBuilder.setResourceBundle(resourceBundle);
        return this;
    }

    public ReportBuilder setGrandTotalLegendStyle(Style grandTotalStyle) {
        this.dynamicReportBuilder.setGrandTotalLegendStyle(grandTotalStyle);
        return this;
    }

    public ReportBuilder addHeaderCrosstab(DJCrosstab cross) {
        this.dynamicReportBuilder.addHeaderCrosstab(cross);
        return this;
    }

    public ReportBuilder addFooterCrosstab(DJCrosstab cross) {
        this.dynamicReportBuilder.addFooterCrosstab(cross);
        return this;
    }

    public ReportBuilder setQuery(String text, String language) {
        this.dynamicReportBuilder.setQuery(text, language);
        return this;
    }

    public ReportBuilder addFont(String fontName, Font font) {
        this.dynamicReportBuilder.addFont(fontName, font);
        return this;
    }

    public ReportBuilder setWhenNoDataType(byte whenNoDataType) {
        this.dynamicReportBuilder.setWhenNoDataType(whenNoDataType);
        return this;
    }

    public ReportBuilder setWhenNoDataNoPages() {
        this.dynamicReportBuilder.setWhenNoDataNoPages();
        return this;
    }

    public ReportBuilder setWhenNoDataBlankPage() {
        this.dynamicReportBuilder.setWhenNoDataBlankPage();
        return this;
    }

    public ReportBuilder setWhenNoDataAllSectionNoDetail() {
        this.dynamicReportBuilder.setWhenNoDataAllSectionNoDetail();
        return this;
    }

    public ReportBuilder setWhenNoDataShowNoDataSection() {
        this.dynamicReportBuilder.setWhenNoDataShowNoDataSection();
        return this;
    }

    public ReportBuilder setWhenResourceMissing(byte whenResourceMissing) {
        this.dynamicReportBuilder.setWhenResourceMissing(whenResourceMissing);
        return this;
    }

    public ReportBuilder setWhenResourceMissingLeaveEmptySpace() {
        this.dynamicReportBuilder.setWhenResourceMissingLeaveEmptySpace();
        return this;
    }

    public ReportBuilder setWhenResourceMissingThrowException() {
        this.dynamicReportBuilder.setWhenResourceMissingThrowException();
        return this;
    }

    public ReportBuilder setWhenResourceMissingShowKey() {
        this.dynamicReportBuilder.setWhenResourceMissingShowKey();
        return this;
    }

    public ReportBuilder setWhenResourceMissingReturnNull() {
        this.dynamicReportBuilder.setWhenResourceMissingReturnNull();
        return this;
    }

    public ReportBuilder setWhenNoData(String text, Style style) {
        this.dynamicReportBuilder.setWhenNoData(text, style);
        return this;
    }

    public ReportBuilder setWhenNoData(String text, Style style, boolean showTitle, boolean showColumnHeader) {
        this.dynamicReportBuilder.setWhenNoData(text, style, showTitle, showColumnHeader);
        return this;
    }

    public ReportBuilder setAllowDetailSplit(boolean split) {
        this.dynamicReportBuilder.setAllowDetailSplit(split);
        return this;
    }

    public ReportBuilder setProperty(String name, String value) {
        this.dynamicReportBuilder.setProperty(name, value);
        return this;
    }

    public ReportBuilder setShowDetailBand(boolean bool) {
        this.dynamicReportBuilder.setShowDetailBand(bool);
        return this;
    }

    public AbstractColumn getColumn(int idx) {
        return this.dynamicReportBuilder.getColumn(idx);
    }

    public ReportBuilder addVariable(DJVariable var) {
        this.dynamicReportBuilder.addVariable(var);
        return this;
    }

    public ReportBuilder setColspan(int colNumber, int colQuantity, String colspanTitle) {
        this.dynamicReportBuilder.setColspan(colNumber, colQuantity, colspanTitle);
        return this;
    }

    public ReportBuilder setColspan(int colNumber, int colQuantity, String colspanTitle, Style colspanStyle) {
        this.dynamicReportBuilder.setColspan(colNumber, colQuantity, colspanTitle, colspanStyle);
        return this;
    }

    public ReportBuilder setLanguage(String language) {
        this.dynamicReportBuilder.setLanguage(language);
        return this;
    }

    public ReportBuilder addWatermark(String text) {
        this.dynamicReportBuilder.addWatermark(text);
        return this;
    }

    public ReportBuilder addWatermark(DJWaterMark waterMark) {
        this.dynamicReportBuilder.addWatermark(waterMark);
        return this;
    }

    public ReportBuilder addWatermark(String text, ar.com.fdvs.dj.domain.constants.Font font, Color color, int angle) {
        this.dynamicReportBuilder.addWatermark(text, font, color, angle);
        return this;
    }

    public ReportBuilder setJasperDesignDecorator(JasperDesignDecorator jasperDesignDecorator) {
        this.dynamicReportBuilder.setJasperDesignDecorator(jasperDesignDecorator);
        return this;
    }

    public ReportBuilder setDefaultEncoding(String encoding) {
        this.dynamicReportBuilder.setDefaultEncoding(encoding);
        return this;
    }

    private Style defaultStyleTitle() {
        Style titleStyle = new Style();
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        ar.com.fdvs.dj.domain.constants.Font font = new ar.com.fdvs.dj.domain.constants.Font();
        font.setBold(true);
        font.setFontSize(20.0f);
        titleStyle.setFont(font);
        return titleStyle;
    }

    private Style defaultStyleSubTitle() {
        Style titleStyle = new Style();
        titleStyle.setHorizontalAlign(HorizontalAlign.LEFT);
        ar.com.fdvs.dj.domain.constants.Font font = new ar.com.fdvs.dj.domain.constants.Font();
        font.setBold(true);
        font.setFontSize(8.0f);
        titleStyle.setFont(font);
        return titleStyle;
    }
}

