/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.servlet;

import br.com.jarch.core.annotation.JArchEventLogoutAfter;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(urlPatterns={"/LogoutServlet"})
public class LogoutServlet
extends HttpServlet {
    @Inject
    @JArchEventLogoutAfter
    private Event<HttpServletRequest> eventLogoutAfter;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        long tenantId = 0L;
        MultiTenant multiTenant = MultiTenant.getInstance();
        if (multiTenant != null) {
            tenantId = multiTenant.get();
        }
        this.eventLogoutAfter.fire((Object)request);
        GlobalInformation.getInstance().clear();
        request.getSession().invalidate();
        try {
            response.sendRedirect("paginas/login/login.jsf?multiTenantId=" + tenantId);
        }
        catch (IOException e) {
            LogUtils.generate((Throwable)e);
        }
    }
}

