/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.annotation.JArchSearchTab;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;

final class FieldSearchFactory
extends BaseFieldSearchFactory {
    FieldSearchFactory() {
    }

    void createFieldSearch(Class<?> clazzEntityOrController, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        this.createFromFields(clazzEntityOrController, mapFieldSearch);
        this.createFromClass(clazzEntityOrController, mapFieldSearch);
        this.createFromPackage(clazzEntityOrController, mapFieldSearch, onlyThisClass);
    }

    private void createFromFields(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        for (Field field : ReflectionUtils.getArrayFields(classActionEntity, (boolean)true, (boolean)true)) {
            Arrays.stream((JArchSearchField[])field.getAnnotationsByType(JArchSearchField.class)).forEach(a -> this.addFieldSearch(null, classActionEntity, (JArchSearchField)a, field, mapFieldSearch));
            for (JArchSearchTab searchTab : (JArchSearchTab[])field.getAnnotationsByType(JArchSearchTab.class)) {
                Arrays.stream(searchTab.searchFields()).forEach(a -> this.addFieldSearch(searchTab, searchTab.classEntity(), (JArchSearchField)a, field, mapFieldSearch));
            }
        }
    }

    private void createFromPackage(Class<?> classControllerOrEntity, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        Class<?> classEntity = this.getClassEntityFrom(classControllerOrEntity);
        this.createFromSearchTab(null, classEntity, (JArchSearchField[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchField.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFields(), mapFieldSearch);
        }
        if (onlyThisClass || classEntity.equals(classControllerOrEntity) || classEntity.getPackage().equals(classControllerOrEntity.getPackage())) {
            return;
        }
        this.createFromSearchTab(null, classEntity, (JArchSearchField[])classEntity.getPackage().getAnnotationsByType(JArchSearchField.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFields(), mapFieldSearch);
        }
    }

    private void createFromSearchTab(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchField[] searchFields, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchField searchField : searchFields) {
            if (searchField.classEntity() != Void.TYPE && searchField.classEntity() != classEntity || searchTab != null && searchTab.classEntity() != classEntity) continue;
            String fieldName = searchField.field();
            Field field = searchField.classEntity() != Void.TYPE ? ReflectionUtils.getField(searchField.classEntity(), (String)fieldName, (boolean)true) : ReflectionUtils.getField(classEntity, (String)fieldName, (boolean)true);
            this.addFieldSearch(searchTab, classEntity, searchField, field, mapFieldSearch);
        }
    }

    private void createFromClass(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        this.createFromClass(null, (JArchSearchField[])classActionEntity.getAnnotationsByType(JArchSearchField.class), classActionEntity, mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classActionEntity.getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromClass(searchTab, searchTab.searchFields(), searchTab.classEntity(), mapFieldSearch);
        }
    }

    private void createFromClass(JArchSearchTab searchTab, JArchSearchField[] searchFields, Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchField searchField : searchFields) {
            Class<?> classEntity = this.getClassEntityFrom(classActionEntity);
            String fieldName = searchField.field();
            Field field = searchField.classEntity() != Void.TYPE ? ReflectionUtils.getField(searchField.classEntity(), (String)fieldName, (boolean)false) : ReflectionUtils.getField(classEntity, (String)fieldName, (boolean)false);
            this.addFieldSearch(searchTab, classActionEntity, searchField, field, mapFieldSearch);
        }
    }

    private void addFieldSearch(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchField searchField, Field field, Map<String, FieldSearch> mapFieldSearch) {
        try {
            if (Boolean.FALSE.equals(searchField.enable().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get())) {
                return;
            }
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
        classEntity = searchTab != null && searchTab.classEntity() != Void.TYPE ? searchTab.classEntity() : classEntity;
        String fieldName = searchField.field();
        String atributo = fieldName.isEmpty() && field != null ? field.getName() : fieldName;
        String descricao = searchField.label() == null || searchField.label().isEmpty() ? "label.".concat(atributo) : searchField.label();
        descricao = BundleUtils.messageBundle(descricao);
        String id = this.createId(classEntity, searchField.id(), atributo, mapFieldSearch);
        ConditionSearchType condition = searchField.condition();
        if (condition == ConditionSearchType.EQUAL && searchField.type().isString()) {
            condition = ConditionSearchType.STARTS_WITH;
        }
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchField.class).id(id).mask(searchField.mask()).clearValueByButton(!searchField.hide()).classAttribute(FieldSearchFactory.getAttributeType(searchField, field)).type(searchField.type()).attribute(atributo).description(descricao).condition(condition).visibleCondition(searchField.visibleCondition()).disabledCondition(searchField.disableCondition()).row(searchField.row()).column(searchField.column()).where(searchField.whereJpa()).span(searchField.span()).zeroLeft(searchField.zeroLeft()).quantityZeroLeft(searchField.quantityZeroLeft()).hide(searchField.hide()).converterJsf(searchField.converterJsf()).tooltip(searchField.toolTip().isEmpty() ? "" : BundleUtils.messageBundle(searchField.toolTip())).tabName(searchTab == null ? "label.main" : searchTab.name()).tabOrder(searchTab == null ? 0 : searchTab.order());
        mapFieldSearch.put(id, fieldSearch);
    }

    private static Class<?> getAttributeType(JArchSearchField searchField, Field field) {
        Class<Object> attributeType = null;
        if (field != null) {
            attributeType = field.getType();
        }
        if (attributeType == null && !Enum.class.isAssignableFrom(searchField.enumeration())) {
            attributeType = searchField.enumeration();
        }
        if (attributeType == null && searchField.type().isInteger()) {
            attributeType = Integer.class;
        }
        if (attributeType == null && searchField.type().isLong()) {
            attributeType = BigInteger.class;
        }
        if (attributeType == null && searchField.type().isDecimal()) {
            attributeType = BigDecimal.class;
        }
        if (attributeType == null) {
            attributeType = String.class;
        }
        return attributeType;
    }
}

