/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.jparepository;

import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.ReflectionUtils;
import jakarta.persistence.EntityManager;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;

public final class ExclusionLogic {
    private ExclusionLogic() {
    }

    public static void removeLogic(EntityManager entityManager, ICrudEntity entity) {
        entity.setDateHourLogicExclusion(new Date());
        for (Field field : entity.getClass().getDeclaredFields()) {
            if (!JpaUtils.isCollectionOneToManyWithCascadeAllOrCascadeRemove(entity, field)) continue;
            ICrudEntity before = (ICrudEntity)entityManager.find(entity.getClass(), (Object)entity.getId());
            Object valorAntesAlteracao = ReflectionUtils.getValueByField((Object)before, (Field)field);
            Collection listaEntidadeAntesAlteracao = (Collection)valorAntesAlteracao;
            for (Object itemColecao : listaEntidadeAntesAlteracao) {
                if (!(itemColecao instanceof ICrudEntity)) continue;
                ICrudEntity entidadeAtual = (ICrudEntity)itemColecao;
                ExclusionLogic.removeLogic(entityManager, entidadeAtual);
                entityManager.find(entidadeAtual.getClass(), (Object)entidadeAtual.getId());
                entidadeAtual.setDateHourLogicExclusion(new Date());
                entityManager.merge((Object)entidadeAtual);
            }
        }
    }
}

