/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.communication;

import br.com.jarch.core.annotation.JArchIgnoreMigrate;
import br.com.jarch.core.annotation.JArchNoCloneId;
import br.com.jarch.core.crud.communication.CommunicationAttachEntity;
import br.com.jarch.core.crud.communication.ICommunication;
import br.com.jarch.core.crud.communication.ICommunicationAttach;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import br.com.jarch.core.jpa.converter.LocalDateJpaConverter;
import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import br.com.jarch.util.StringUtils;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;

@Table(name="tb_comunicacaomensagem")
@Entity
@SequenceGenerator(name="ComunicacaoMensagemIdSequence", sequenceName="sq_idcomunicacaomensagem", allocationSize=1)
@JArchIgnoreMigrate
public class CommunicationEntity
extends CrudMultiTenantEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ComunicacaoMensagemIdSequence")
    @Column(name="id_comunicacaomensagem")
    private Long id;
    @Column(name="tp_comunicacaomensagem", nullable=false)
    private Integer type = 0;
    @Column(name="cd_comunicacaomensagem", nullable=false)
    private Long code;
    @Column(name="ds_titulo", nullable=false, length=500)
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String title;
    @Column(name="mm_corpo", nullable=false, length=4000)
    @Size(max=4000, message="{message.maxSizeExceeded}")
    private @Size(max=4000, message="{message.maxSizeExceeded}") String body;
    @Column(name="ee_link", length=500)
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String link;
    @Column(name="cd_remetente")
    @AttributeOverride(name="from", column=@Column(name="cd_remetente"))
    private Long from;
    @Column(name="cd_destinatario")
    private Long to;
    @Convert(converter=LocalDateTimeJpaConverter.class)
    @Column(name="dh_inclusao", nullable=false)
    private LocalDateTime inclusion;
    @Convert(converter=LocalDateTimeJpaConverter.class)
    @Column(name="dh_leitura")
    private LocalDateTime reading;
    @Column(name="mm_outrasinformacoes")
    private String others;
    @Column(name="sn_permiteexclusao", length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean allowsExclusion;
    @Column(name="sn_arquivado", length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean filed;
    @Column(name="dh_expiracao")
    @Convert(converter=LocalDateJpaConverter.class)
    private LocalDate expiration;
    @OneToMany(mappedBy="communication", orphanRemoval=true, cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, targetEntity=CommunicationAttachEntity.class)
    @JArchNoCloneId
    private Set<CommunicationAttachEntity> attachs = new HashSet<CommunicationAttachEntity>();

    public CommunicationEntity() {
    }

    public CommunicationEntity(ICommunication communication) {
        this.inclusion = LocalDateTime.now();
        this.filed = false;
        this.allowsExclusion = true;
        this.id = communication.getId();
        this.type = communication.getType();
        this.code = communication.getCode();
        this.title = communication.getTitle();
        this.body = communication.getBody();
        this.from = communication.getFrom();
        this.to = communication.getTo();
        this.link = communication.getLink();
        this.allowsExclusion = communication.getAllowsExclusion();
        this.expiration = communication.getExpiration();
        this.attachs = new HashSet<CommunicationAttachEntity>();
        for (ICommunicationAttach iCommunicationAttach : communication.getAttachs()) {
            CommunicationAttachEntity attachEntity = new CommunicationAttachEntity();
            attachEntity.setCommunication(this);
            attachEntity.setBinary(iCommunicationAttach.getBinary());
            attachEntity.setFileName(iCommunicationAttach.getFileName());
            this.attachs.add(attachEntity);
        }
    }

    public CommunicationEntity(Long id, Integer type, Long code, String title, String body, Long from, Long to, String link) {
        this.id = id;
        this.type = type;
        this.code = code;
        this.title = title;
        this.body = body;
        this.from = from;
        this.to = to;
        this.link = link;
    }

    public CommunicationEntity(Long id, String title) {
        this.id = id;
        this.title = title;
    }

    public CommunicationEntity(Long id, String title, LocalDateTime inclusion) {
        this.id = id;
        this.title = title;
        this.inclusion = inclusion;
    }

    public CommunicationEntity(Long id, LocalDateTime inclusion, String title) {
        this.id = id;
        this.inclusion = inclusion;
        this.title = title;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Long getFrom() {
        return this.from;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public Long getTo() {
        return this.to;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    public String getLink() {
        if (StringUtils.isNullOrEmpty((String)this.link) && this.id != null) {
            return "../communication/communicationList.jsf?id=" + this.id;
        }
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public LocalDateTime getReading() {
        return this.reading;
    }

    public void setReading(LocalDateTime reading) {
        this.reading = reading;
    }

    public String getOthers() {
        return this.others;
    }

    public void setOthers(String others) {
        this.others = others;
    }

    public LocalDateTime getInclusion() {
        return this.inclusion;
    }

    public void setInclusion(LocalDateTime inclusion) {
        this.inclusion = inclusion;
    }

    public Boolean getAllowsExclusion() {
        return this.allowsExclusion == null || this.allowsExclusion != false;
    }

    public void setAllowsExclusion(Boolean allowsExclusion) {
        this.allowsExclusion = allowsExclusion;
    }

    public Boolean getFiled() {
        return this.filed;
    }

    public void setFiled(Boolean filed) {
        this.filed = filed;
    }

    public Set<CommunicationAttachEntity> getAttachs() {
        return this.attachs;
    }

    public void setAttachs(Set<CommunicationAttachEntity> attachs) {
        this.attachs = attachs;
    }

    public LocalDate getExpiration() {
        return this.expiration;
    }

    public void setExpiration(LocalDate expiration) {
        this.expiration = expiration;
    }
}

