/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.cdi.extension;

import br.com.jarch.util.LogUtils;
import jakarta.ejb.Startup;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

public class StartupBeanExtension
implements Extension {
    private final Set<Bean<?>> startupBeans = new LinkedHashSet();

    <X> void processBean(@Observes ProcessBean<X> event) {
        if (event.getAnnotated().isAnnotationPresent(Startup.class) && event.getAnnotated().isAnnotationPresent(ApplicationScoped.class)) {
            this.startupBeans.add(event.getBean());
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        for (Bean<?> bean : this.startupBeans) {
            LogUtils.generate((String)("CDI = " + bean.getName()));
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
    }
}

