/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchOrderBy"})
public class OrderByProcessor
extends AbstractProcessor {
    private final List<Completion> listaAtributos = new ArrayList<Completion>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            for (Element element : roundEnv.getElementsAnnotatedWith(JArchOrderBy.class)) {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                JArchOrderBy jArchOrderBy = element.getAnnotation(JArchOrderBy.class);
                if (jArchOrderBy.ignoreProcessor()) continue;
                TypeElement classeElement = (TypeElement)element;
                this.listaAtributos.clear();
                for (JArchOrderByField jArchOrderByField : jArchOrderBy.fields()) {
                    if (jArchOrderByField.ignoreProcessor()) continue;
                    boolean achou = false;
                    for (Element element2 : classeElement.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.FIELD || !element2.getSimpleName().contentEquals(jArchOrderByField.value())) continue;
                        this.listaAtributos.add(Completions.of(jArchOrderByField.value()));
                        achou = true;
                        break;
                    }
                    TypeElement superClass = this.processingEnv.getElementUtils().getTypeElement(((TypeElement)element).getSuperclass().toString());
                    for (Element element3 : superClass.getEnclosedElements()) {
                        if (element3.getKind() != ElementKind.FIELD || !element3.getSimpleName().contentEquals(jArchOrderByField.value())) continue;
                        this.listaAtributos.add(Completions.of(jArchOrderByField.value()));
                        achou = true;
                        break;
                    }
                    if (achou || ProcessorUtils.existsField(classeElement, jArchOrderByField.value())) continue;
                    ProcessorUtils.messageError("JARCH ERROR: Atributo " + String.valueOf(jArchOrderByField) + " n\u00e3o localizado na anota\u00e7\u00e3o @JArchOrderByField da classe " + classeElement.getQualifiedName().toString(), element);
                }
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return this.listaAtributos;
    }
}

