/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import jakarta.faces.convert.FacesConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"jakarta.faces.convert.FacesConverter"})
public class FacesConverterProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            for (Element element : roundEnv.getElementsAnnotatedWith(FacesConverter.class)) {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : annotationMirrors) {
                    String attributeValue = "";
                    String attributeForClass = "";
                    Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                        String key = entry.getKey().getSimpleName().toString();
                        Object value = entry.getValue().getValue();
                        switch (key) {
                            case "value": {
                                attributeValue = (String)value;
                                break;
                            }
                            case "forClass": {
                                TypeMirror typeMirror = (TypeMirror)value;
                                attributeForClass = typeMirror.toString();
                            }
                        }
                    }
                    if (!attributeValue.isEmpty() || !attributeForClass.isEmpty()) continue;
                    ProcessorUtils.messageError("JARCH ERROR: @FacesConverter sem defini\u00e7\u00e3o para os atributos value e forClass", element);
                }
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

