/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.faces.view.ViewScoped;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"jakarta.faces.bean.ViewScoped", "jakarta.faces.bean.RequestScoped", "jakarta.faces.bean.SessionScoped", "jakarta.faces.bean.ApplicationScoped"})
public class JsfNoCdiProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getRootElements().stream().filter(e -> e.getAnnotation(RequestScoped.class) != null || e.getAnnotation(ViewScoped.class) != null || e.getAnnotation(SessionScoped.class) != null || e.getAnnotation(ApplicationScoped.class) != null).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.advertencia((Element)element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void advertencia(Element element) {
        TypeElement classeElement = (TypeElement)element;
        ProcessorUtils.messageWarning(this.getClass().getSimpleName() + ": JARCH WARNING: Utilize o escopo do CDI no lugar do JSF na classe " + classeElement.getQualifiedName().toString(), element);
    }
}

