/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.UnicodeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public final class UpdateBundle {
    private final Element element;
    private final JArchGenerateCrud generateCrud;
    private File fileBundle;

    public UpdateBundle(Element element, JArchGenerateCrud generateCrud) {
        this.element = element;
        this.generateCrud = generateCrud;
        this.configure(element, generateCrud.nameSubPackage());
    }

    public static void update(Element element, JArchGenerateCrud generateCrud) {
        new UpdateBundle(element, generateCrud).update();
    }

    private void update() {
        try {
            if (!ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileBundle)) {
                return;
            }
            ArrayList<String> listaAdicaoBundle = new ArrayList<String>();
            ArrayList<String> listaAtual = new ArrayList<String>();
            try (BufferedReader leitor = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileBundle), StandardCharsets.UTF_8));){
                String line;
                while ((line = leitor.readLine()) != null) {
                    listaAtual.add(line);
                }
            }
            ArrayList<String> listaBundleArch = new ArrayList<String>();
            InputStream resourceBundle = this.getClass().getResourceAsStream(File.separator + "bundle" + File.separator + "bundleJArch_" + Locale.getDefault().getLanguage() + ".properties");
            if (resourceBundle != null) {
                try (BufferedReader leitor = new BufferedReader(new InputStreamReader(resourceBundle, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = leitor.readLine()) != null) {
                        listaBundleArch.add(line);
                    }
                }
            }
            ArrayList<String> listaUnificada = new ArrayList<String>();
            listaUnificada.addAll(listaAtual);
            listaUnificada.addAll(listaBundleArch);
            this.addKeyValue(this.generateCrud.master().name(), ProcessorUtils.getListFieldForm(this.generateCrud.master().fields()), listaAdicaoBundle, listaUnificada);
            Arrays.stream(this.generateCrud.master().details()).forEach(detail -> {
                this.addKeyValue(detail.name(), ProcessorUtils.getListFieldForm(detail.fields()), listaAdicaoBundle, listaUnificada);
                Arrays.stream(detail.subDetails()).forEach(subDetail -> this.addKeyValue(subDetail.name(), ProcessorUtils.getListFieldForm(subDetail.fields()), listaAdicaoBundle, listaUnificada));
            });
            if (listaAdicaoBundle.isEmpty()) {
                return;
            }
            listaAtual.addAll(listaAdicaoBundle);
            FileUtils.save((File)this.fileBundle, listaAtual.stream().filter(l -> !l.trim().isEmpty()).map(UnicodeUtils::convertSpecialCharacter).distinct().collect(Collectors.toList()));
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.fileBundle.getAbsoluteFile()), this.element);
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }

    private void addKeyValue(String name, List<FieldForm> fieldForms, List<String> listaAdicaoBundle, List<String> listaUnificada) {
        String chaveMestre = "label." + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(name);
        if (listaUnificada.stream().noneMatch(l -> l.contains(chaveMestre + "=") || l.contains(chaveMestre + " "))) {
            listaAdicaoBundle.add(chaveMestre + "=" + name);
        }
        for (FieldForm c : fieldForms) {
            if (!listaUnificada.stream().noneMatch(l -> l.contains(c.getBundleCodigoJava() + "=") || l.contains(c.getBundleCodigoJava() + " "))) continue;
            listaAdicaoBundle.add(c.getBundleCodigoJava() + "=" + c.getDescricao());
        }
    }

    private void configure(Element element, String nameSubPackage) {
        File folder = new File(ProcessorUtils.getPathBundle(element, nameSubPackage));
        this.fileBundle = new File(folder.getAbsolutePath() + File.separator + "bundle_pt_BR.properties");
        if (!this.fileBundle.exists()) {
            if (folder.getAbsolutePath().contains("-web")) {
                folder = new File(ProcessorUtils.getPathBundle(element, nameSubPackage).replace("-web", "-client"));
            } else if (folder.getAbsolutePath().contains("-client")) {
                folder = new File(ProcessorUtils.getPathBundle(element, nameSubPackage).replace("-client", "-web"));
            }
            this.fileBundle = new File(folder.getAbsolutePath() + File.separator + "bundle_pt_BR.properties");
        }
    }
}

