/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.core.model.type.ActionCrudType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public final class SystemTestGenerate {
    private File fileTest;
    private File filePage;
    private String namePackage;
    private String nome;
    private String nomeSemCaracterEspecial;
    private String nomeSemCaracterEspecialMinusculo;
    private final List<FieldForm> listFieldFormMaster;
    private final Element element;
    private final JArchGenerateCrud generateCrud;

    public SystemTestGenerate(Element element, JArchGenerateCrud generateCrud) {
        this.generateCrud = generateCrud;
        this.element = element;
        this.listFieldFormMaster = ProcessorUtils.getListFieldForm(generateCrud.master().fields());
        this.configure(element, generateCrud.master().name(), generateCrud.nameSubPackage());
    }

    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new SystemTestGenerate(element, generateCrud).create();
    }

    private void create() {
        this.saveTest();
        this.savePage();
    }

    private void saveTest() {
        if (this.fileTest.exists()) {
            return;
        }
        StringBuilder sbSystemTest = new StringBuilder();
        ProcessorUtils.addCode(sbSystemTest, "package " + this.namePackage + ";");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "import br.com.jarch.test.BrowseFactory;");
        ProcessorUtils.addCode(sbSystemTest, "import br.com.jarch.test.TestUtils;");
        ProcessorUtils.addCode(sbSystemTest, "import br.com.jarch.test.system.CrudSystemTest;");
        ProcessorUtils.addCode(sbSystemTest, "import org.junit.jupiter.api.AfterAll;");
        ProcessorUtils.addCode(sbSystemTest, "import org.junit.jupiter.api.BeforeAll;");
        ProcessorUtils.addCode(sbSystemTest, "import org.openqa.selenium.WebDriver;");
        ProcessorUtils.addCode(sbSystemTest, "import org.openqa.selenium.support.PageFactory;");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "public class " + this.nomeSemCaracterEspecial + "SystemTest extends CrudSystemTest<" + this.nomeSemCaracterEspecial + "Page> {");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "\tprivate static final WebDriver driver;");
        ProcessorUtils.addCode(sbSystemTest, "\tprivate static final " + this.nomeSemCaracterEspecial + "Page " + this.nomeSemCaracterEspecialMinusculo + "Page;");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "\tstatic {");
        ProcessorUtils.addCode(sbSystemTest, "\t\tdriver = BrowseFactory.getFirefoxDriver();");
        ProcessorUtils.addCode(sbSystemTest, "\t\t" + this.nomeSemCaracterEspecialMinusculo + "Page = PageFactory.initElements(driver, " + this.nomeSemCaracterEspecial + "Page.class);");
        ProcessorUtils.addCode(sbSystemTest, "\t}");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "\t@Override");
        ProcessorUtils.addCode(sbSystemTest, "\tpublic " + this.nomeSemCaracterEspecial + "Page getPage() {");
        ProcessorUtils.addCode(sbSystemTest, "\t\treturn " + this.nomeSemCaracterEspecialMinusculo + "Page;");
        ProcessorUtils.addCode(sbSystemTest, "\t}");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "\t@BeforeAll");
        ProcessorUtils.addCode(sbSystemTest, "\tpublic static void beforeAll() {");
        ProcessorUtils.addCode(sbSystemTest, "\t\tTestUtils.login(driver, \"" + this.getUrlApplication() + "/paginas/login/login.jsf?multiTenantId=1&systemTest=S\", \"login\", \"senha\");");
        ProcessorUtils.addCode(sbSystemTest, "\t}");
        ProcessorUtils.addLineBlank(sbSystemTest);
        ProcessorUtils.addCode(sbSystemTest, "\t@AfterAll");
        ProcessorUtils.addCode(sbSystemTest, "\tpublic static void afterClass() {");
        ProcessorUtils.addCode(sbSystemTest, "\t\tTestUtils.logout(driver);");
        ProcessorUtils.addCode(sbSystemTest, "\t}");
        ProcessorUtils.addCode(sbSystemTest, "}");
        try {
            FileUtils.save((File)this.fileTest, (String)sbSystemTest.toString());
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.fileTest.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    private void savePage() {
        if (this.filePage.exists()) {
            return;
        }
        StringBuilder sbPage = new StringBuilder();
        ProcessorUtils.addCode(sbPage, "package " + this.namePackage + ";");
        ProcessorUtils.addLineBlank(sbPage);
        this.addImportsPage(sbPage);
        ProcessorUtils.addLineBlank(sbPage);
        ProcessorUtils.addCode(sbPage, "public class " + this.nomeSemCaracterEspecial + "Page extends CrudPage {");
        ProcessorUtils.addLineBlank(sbPage);
        this.addMethodConstruct(sbPage);
        this.addInjectWebComponentFilter(sbPage);
        this.addInjectWebComponentData(sbPage);
        this.addInjectWebComponentTabDetail(sbPage);
        this.addInjectWebComponentTabSubDetail(sbPage);
        this.addMethodGetFolderXhtml(sbPage);
        this.addMethodGetPageList(sbPage);
        this.addMethodGetPageData(sbPage);
        this.addMethodActionInsert(sbPage);
        this.addMethodActionClone(sbPage);
        this.addMethodActionChange(sbPage);
        this.addMethodActionConsult(sbPage);
        this.addMethodActionDelete(sbPage);
        ProcessorUtils.addCode(sbPage, "}");
        try {
            FileUtils.save((File)this.filePage, (String)sbPage.toString());
            ProcessorUtils.messageNote("Create Page Class ==> " + String.valueOf(this.filePage.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    private void addMethodConstruct(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\tpublic " + this.nomeSemCaracterEspecial + "Page(WebDriver driver) {");
        ProcessorUtils.addCode(sbPage, "\t\tsuper(driver);");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodActionDelete(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tpublic void actionDelete() {");
        ProcessorUtils.addCode(sbPage, "\t\tgoDeleteDataInsertAndDataChange(" + this.getWebElementFilterString() + ", FieldType." + this.getWebElementFilterFieldForm().getTipo().name() + (this.generateCrud == null ? "" : ", true") + ");");
        ProcessorUtils.addCode(sbPage, "\t}");
    }

    private void addMethodActionConsult(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tpublic void actionConsult() {");
        this.addCodeGoPageListFilterChange(sbPage);
        ProcessorUtils.addCode(sbPage, "\t\tclickListActionConsult();");
        ProcessorUtils.addCode(sbPage, "\t\twaitForPageData();");
        if (this.generateCrud != null) {
            ProcessorUtils.addCode(sbPage, "\t\tscrollBottomPage();");
        }
        ProcessorUtils.addCode(sbPage, "\t\tclickMasterReturn();");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodActionChange(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tpublic void actionChange() {");
        this.addCodeGoPageListFilterClone(sbPage);
        ProcessorUtils.addCode(sbPage, "\t\tclickListActionChange();");
        this.addClickClearSendkeysChange(sbPage);
        if (this.generateCrud != null) {
            ProcessorUtils.addCode(sbPage, "\t\tscrollBottomPage();");
        }
        ProcessorUtils.addCode(sbPage, "\t\tclickMasterSave();");
        ProcessorUtils.addCode(sbPage, "\t\twaitForMessageSuccess();");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodActionClone(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tpublic void actionClone() {");
        this.addCodeGoPageListFilterInsert(sbPage);
        ProcessorUtils.addCode(sbPage, "\t\tclickListActionClone();");
        this.addClickClearSendkeysClone(sbPage);
        if (this.generateCrud != null) {
            ProcessorUtils.addCode(sbPage, "\t\tscrollBottomPage();");
        }
        ProcessorUtils.addCode(sbPage, "\t\tclickMasterSave();");
        ProcessorUtils.addCode(sbPage, "\t\twaitForMessageSuccess();");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodActionInsert(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tpublic void actionInsert() {");
        ProcessorUtils.addCode(sbPage, "\t\tgoPageListFromUrl();");
        ProcessorUtils.addCode(sbPage, "\t\tclickListActionInsert();");
        this.addClickClearSendkeysInsert(sbPage);
        if (this.generateCrud != null) {
            ProcessorUtils.addCode(sbPage, "\t\tscrollBottomPage();");
        }
        ProcessorUtils.addCode(sbPage, "\t\tclickMasterSave();");
        ProcessorUtils.addCode(sbPage, "\t\twaitForMessageSuccess();");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodGetPageData(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tprotected String getPageData() {");
        ProcessorUtils.addCode(sbPage, "\t\treturn \"" + this.nomeSemCaracterEspecialMinusculo + "Data.jsf\";");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodGetFolderXhtml(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tprotected String getFolderXhtml() {");
        ProcessorUtils.addCode(sbPage, "\t\treturn \"" + this.nomeSemCaracterEspecialMinusculo.toLowerCase() + "\";");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addMethodGetPageList(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "\t@Override");
        ProcessorUtils.addCode(sbPage, "\tprotected String getPageList() {");
        ProcessorUtils.addCode(sbPage, "\t\treturn \"" + this.nomeSemCaracterEspecialMinusculo + "List.jsf\";");
        ProcessorUtils.addCode(sbPage, "\t}");
        ProcessorUtils.addLineBlank(sbPage);
    }

    private void addImportsPage(StringBuilder sbPage) {
        ProcessorUtils.addCode(sbPage, "import br.com.jarch.test.page.CrudPage;");
        ProcessorUtils.addCode(sbPage, "import br.com.jarch.core.type.FieldType;");
        ProcessorUtils.addCode(sbPage, "import org.openqa.selenium.WebDriver;");
        ProcessorUtils.addCode(sbPage, "import org.openqa.selenium.WebElement;");
        ProcessorUtils.addCode(sbPage, "import org.openqa.selenium.support.FindBy;");
        ProcessorUtils.addCode(sbPage, "import org.openqa.selenium.support.How;");
        this.listFieldFormMaster.stream().filter(f -> f.getTipo().isEnum()).forEach(f -> ProcessorUtils.addCode(sbPage, "import " + this.namePackage.replace("test", "client").concat(".").concat(f.getAtributoPrimeiroLetraMaiusculo().concat("Type;"))));
    }

    private void addCodeGoPageListFilterInsert(StringBuilder sbPage) {
        FieldForm fieldForm = this.getWebElementFilterFieldForm();
        ProcessorUtils.addCode(sbPage, "\t\tgoPageListAndFilter(" + this.getWebElementFilterString() + ", FieldType." + fieldForm.getTipo().name() + ".getValueInsertTest());");
    }

    private void addCodeGoPageListFilterClone(StringBuilder sbPage) {
        FieldForm fieldForm = this.getWebElementFilterFieldForm();
        ProcessorUtils.addCode(sbPage, "\t\tgoPageListAndFilter(" + this.getWebElementFilterString() + ", FieldType." + fieldForm.getTipo().name() + ".getValueCloneTest());");
    }

    private void addCodeGoPageListFilterChange(StringBuilder sbPage) {
        FieldForm fieldForm = this.getWebElementFilterFieldForm();
        ProcessorUtils.addCode(sbPage, "\t\tgoPageListAndFilter(" + this.getWebElementFilterString() + ", FieldType." + fieldForm.getTipo().name() + ".getValueChangeTest());");
    }

    private FieldForm getWebElementFilterFieldForm() {
        return this.listFieldFormMaster.stream().filter(f -> !f.getSearch().isEmpty()).findFirst().get();
    }

    private String getWebElementFilterString() {
        return "webElement" + this.nomeSemCaracterEspecial + this.getWebElementFilterFieldForm().getAtributoPrimeiroLetraMaiusculo() + "FilterSearch";
    }

    private void addInjectWebComponentFilter(StringBuilder sbSystemTest) {
        this.listFieldFormMaster.stream().filter(f -> !f.getSearch().isEmpty()).forEach(fieldForm -> {
            ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.XPATH, xpath = \"//input[contains(@id, 'filterSearch" + fieldForm.getAtributo() + "')]\")");
            ProcessorUtils.addCode(sbSystemTest, "\tprivate WebElement webElement" + this.nomeSemCaracterEspecial + fieldForm.getAtributoPrimeiroLetraMaiusculo() + "FilterSearch;");
            ProcessorUtils.addLineBlank(sbSystemTest);
        });
    }

    private void addInjectWebComponentDataListFormField(StringBuilder sbSystemTest, String name, String dataDetail, List<FieldForm> fieldForms) {
        fieldForms.stream().filter(FieldForm::isObrigatorio).forEach(fieldForm -> {
            if (fieldForm.getTipo().isEnum() || fieldForm.getTipo().equals((Object)FieldType.BOOLEAN)) {
                ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.XPATH, xpath = \"//div[contains(@id, '" + fieldForm.getGenerateId(name, dataDetail) + "')]\")");
                ProcessorUtils.addCode(sbSystemTest, "\tprivate WebElement webElement" + fieldForm.getGenerateId(name, dataDetail).substring(2) + ";");
                ProcessorUtils.addLineBlank(sbSystemTest);
            } else {
                if (fieldForm.getTipo().equals((Object)FieldType.ADDRESS)) {
                    ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.CSS, css = \"div[id *= '" + fieldForm.getGenerateId(name, dataDetail) + "'] input[id *= 'zipCode']\")");
                } else if (fieldForm.getTipo().equals((Object)FieldType.MEMO_RICH)) {
                    ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.CSS, css = \"div[id *= '" + fieldForm.getGenerateId(name, dataDetail) + "'] .ql-editor\")");
                } else {
                    ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.XPATH, xpath = \"//input[contains(@id, '" + fieldForm.getGenerateId(name, dataDetail) + (fieldForm.getTipo().isAddress() ? ":zipCode" : "") + "')]\")");
                }
                ProcessorUtils.addCode(sbSystemTest, "\tprivate WebElement webElement" + fieldForm.getGenerateId(name, dataDetail).substring(2) + ";");
                ProcessorUtils.addLineBlank(sbSystemTest);
            }
        });
    }

    private void addInjectWebComponentTabDetail(StringBuilder sbSystemTest) {
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> {
            ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.XPATH, xpath = \"//a[contains(@href, 'tab" + ProcessorUtils.getNameWithoutCharEspecialCapitalize(detail.name()) + "')]/span/input\")");
            ProcessorUtils.addCode(sbSystemTest, "\tprivate WebElement webElementInsert" + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail.name()) + ";");
            ProcessorUtils.addLineBlank(sbSystemTest);
        });
    }

    private void addInjectWebComponentTabSubDetail(StringBuilder sbSystemTest) {
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> Arrays.stream(detail.subDetails()).forEach(subDetail -> {
            ProcessorUtils.addCode(sbSystemTest, "\t@FindBy(how = How.XPATH, xpath = \"//a[contains(@href, 'tab" + ProcessorUtils.getNameWithoutCharEspecialCapitalize(subDetail.name()) + "')]/input\")");
            ProcessorUtils.addCode(sbSystemTest, "\tprivate WebElement webElementInsert" + ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(subDetail.name()) + ";");
            ProcessorUtils.addLineBlank(sbSystemTest);
        }));
    }

    private void addInjectWebComponentData(StringBuilder sbSystemTest) {
        this.addInjectWebComponentDataListFormField(sbSystemTest, this.nomeSemCaracterEspecial, "", this.listFieldFormMaster);
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> this.addInjectWebComponentDataListFormField(sbSystemTest, this.nomeSemCaracterEspecial, ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail.name()), ProcessorUtils.getListFieldForm(detail.fields())));
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> Arrays.stream(detail.subDetails()).forEach(subDetail -> this.addInjectWebComponentDataListFormField(sbSystemTest, this.nomeSemCaracterEspecial, ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(subDetail.name()), ProcessorUtils.getListFieldForm(subDetail.fields()))));
    }

    private void addClickClearSendkeysInsert(StringBuilder sbSystemTest) {
        this.listFieldFormMaster.forEach(fieldForm -> this.addCodeFillWebComponentInsert(sbSystemTest, this.nome, (FieldForm)fieldForm));
        for (JArchGenerateCrud.Detail detail : Arrays.stream(this.generateCrud.master().details()).collect(Collectors.toList())) {
            String nomeSemCaracterEspecialDetailStartLowerCase = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(detail.name());
            String nomeSemCaracterEspecialDetailCapitalize = ProcessorUtils.getNameWithoutCharEspecialCapitalize(detail.name());
            ProcessorUtils.addCode(sbSystemTest, "\t\tscrollTo(webElementInsert" + nomeSemCaracterEspecialDetailStartLowerCase + ");");
            ProcessorUtils.addCode(sbSystemTest, "\t\tclickDetailActionInsert(\"tab" + nomeSemCaracterEspecialDetailCapitalize + "\");");
            ProcessorUtils.getListFieldForm(detail.fields()).forEach(fieldForm -> this.addCodeFillWebComponentInsert(sbSystemTest, nomeSemCaracterEspecialDetailStartLowerCase, (FieldForm)fieldForm));
            for (JArchGenerateCrud.SubDetail subDetail : Arrays.stream(detail.subDetails()).collect(Collectors.toList())) {
                String nomeSemCaracterEspecialSubDetailStartLowerCase = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(subDetail.name());
                String nomeSemCaracterEspecialSubDetailCapitalize = ProcessorUtils.getNameWithoutCharEspecialCapitalize(subDetail.name());
                ProcessorUtils.addCode(sbSystemTest, "\t\tscrollTo(webElementInsert" + nomeSemCaracterEspecialSubDetailStartLowerCase + ");");
                ProcessorUtils.addCode(sbSystemTest, "\t\tclickDetailActionInsert(\"tab" + nomeSemCaracterEspecialSubDetailCapitalize + "\");");
                ProcessorUtils.getListFieldForm(subDetail.fields()).forEach(fieldForm -> this.addCodeFillWebComponentInsert(sbSystemTest, nomeSemCaracterEspecialSubDetailStartLowerCase, (FieldForm)fieldForm));
                ProcessorUtils.addCode(sbSystemTest, "\t\tclickDetailSave();");
            }
            ProcessorUtils.addCode(sbSystemTest, "\t\tclickDetailSave();");
        }
    }

    private void addClickClearSendkeysClone(StringBuilder sbSystemTest) {
        this.listFieldFormMaster.forEach(fieldForm -> this.addCodeFillWebComponentClone(sbSystemTest, this.nome, (FieldForm)fieldForm));
    }

    private void addClickClearSendkeysChange(StringBuilder sbSystemTest) {
        this.listFieldFormMaster.forEach(fieldForm -> this.addCodeFillWebComponentChange(sbSystemTest, this.nome, (FieldForm)fieldForm));
    }

    private void configure(Element element, String name, String nameSubPackage) {
        this.nome = name;
        this.nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        this.nomeSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(name);
        File folder = new File(ProcessorUtils.getPathTest(element, nameSubPackage).replace("-client", "-web").replace(File.separator + "client" + File.separator, File.separator + "test" + File.separator));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.fileTest = new File(folder.getAbsolutePath() + File.separator + this.nomeSemCaracterEspecial + "SystemTest.java");
        this.filePage = new File(folder.getAbsolutePath() + File.separator + this.nomeSemCaracterEspecial + "Page.java");
        this.namePackage = ProcessorUtils.getPackage(element, nameSubPackage).replace(".client.", ".test.");
    }

    private String getUrlApplication() {
        String context = this.filePage.getAbsolutePath();
        context = context.contains("-web") ? context.substring(0, context.indexOf("-web")) : (context.contains("-client") ? context.substring(0, context.indexOf("-client")) : "");
        if (!context.isEmpty()) {
            context = context.substring(context.lastIndexOf(File.separator) + 1);
        }
        if (context.isEmpty()) {
            context = "myapp";
        }
        context = context.replace("\\", "/");
        return "http://localhost:8080/" + context;
    }

    private void addCodeFillWebComponentInsert(StringBuilder sbSystemTest, String name, FieldForm fieldForm) {
        this.addCodeFillWebComponent(sbSystemTest, name, fieldForm, ActionCrudType.INSERT);
    }

    private void addCodeFillWebComponentClone(StringBuilder sbSystemTest, String name, FieldForm fieldForm) {
        this.addCodeFillWebComponent(sbSystemTest, name, fieldForm, ActionCrudType.CLONE);
    }

    private void addCodeFillWebComponentChange(StringBuilder sbSystemTest, String name, FieldForm fieldForm) {
        this.addCodeFillWebComponent(sbSystemTest, name, fieldForm, ActionCrudType.CHANGE);
    }

    private void addCodeFillWebComponent(StringBuilder sbSystemTest, String name, FieldForm fieldForm, ActionCrudType actionCrudType) {
        if (!fieldForm.isObrigatorio()) {
            return;
        }
        String nameNoCharEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        String action = actionCrudType.name().substring(0, 1).concat(actionCrudType.name().substring(1).toLowerCase());
        if (fieldForm.getTipo().isEnum()) {
            ProcessorUtils.addCode(sbSystemTest, "\t\tclickSelect(webElement" + nameNoCharEspecial + fieldForm.getAtributoPrimeiroLetraMaiusculo() + ", " + fieldForm.getAtributoPrimeiroLetraMaiusculo() + "Type.SAMPLE" + (actionCrudType.isInsert() || actionCrudType.isChange() ? "1" : "2") + ".name());");
        } else if (fieldForm.getTipo().equals((Object)FieldType.BOOLEAN)) {
            ProcessorUtils.addCode(sbSystemTest, "\t\tclick(webElement" + nameNoCharEspecial + fieldForm.getAtributoPrimeiroLetraMaiusculo() + ");");
        } else if (FieldType.BINARY.equals((Object)fieldForm.getTipo())) {
            ProcessorUtils.addCode(sbSystemTest, "\t\tfileUploadPdfFake(webElement" + nameNoCharEspecial + fieldForm.getAtributoPrimeiroLetraMaiusculo() + ");");
        } else {
            ProcessorUtils.addCode(sbSystemTest, "\t\tclickClearSendKeys(webElement" + nameNoCharEspecial + fieldForm.getAtributoPrimeiroLetraMaiusculo() + ", FieldType." + fieldForm.getTipo().name() + ".getValue" + action + "Test());");
        }
        if (fieldForm.getTipo() == FieldType.ADDRESS) {
            ProcessorUtils.addCode(sbSystemTest, "\t\twaitForAjaxProcess();");
        }
    }
}

