/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.annotation.JArchJpaRepository;
import javax.lang.model.element.Element;

public class JpaRepositoryCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new JpaRepositoryCodeGenerate(element, generateCrud.master().name(), generateCrud.nameSubPackage()).generate();
    }

    public static void generate(Element element, String useCase, String nameSubPackage) {
        new JpaRepositoryCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    private JpaRepositoryCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.JPA_REPOSITORY;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArch" + CodeType.JPA_REPOSITORY.getSuffixName() + ";");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.crud.jparepository.Crud" + CodeType.JPA_REPOSITORY.getSuffixName() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@" + JArchJpaRepository.class.getSimpleName());
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " extends Crud" + CodeType.JPA_REPOSITORY.getSuffixName() + "<" + this.getNameEntity() + "> implements " + this.getNameRepository() + " {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

