/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.ByteUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class FinalizacaoVersionamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private RadioButton radioButtonIndividual;
    @FXML
    private RadioButton radioButtonPacote;
    @FXML
    private Button buttonInicioDesenvolvimento;
    @FXML
    private Label labelPacoteSelecionado;
    private VersionamentoEntity versionamento;
    private File pacoteSelecionado;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
        this.radioButtonIndividual.setOnMouseClicked(event -> this.atualizaCombo());
        this.radioButtonPacote.setOnMouseClicked(event -> this.atualizaCombo());
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                byte[] streamArquivo;
                FinalizacaoVersionamentoController.this.desabilitaComponentes();
                PublicacaoType publicacaoType = null;
                if (FinalizacaoVersionamentoController.this.radioButtonIndividual.isSelected()) {
                    publicacaoType = PublicacaoType.INDIVIDUAL;
                } else if (FinalizacaoVersionamentoController.this.radioButtonPacote.isSelected()) {
                    publicacaoType = PublicacaoType.PACOTE;
                }
                FinalizacaoVersionamentoController.this.versionamento = (VersionamentoEntity)FinalizacaoVersionamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                String nomeArquivoOriginal = FinalizacaoVersionamentoController.this.pacoteSelecionado == null ? null : FinalizacaoVersionamentoController.this.pacoteSelecionado.getName();
                byte[] byArray = streamArquivo = FinalizacaoVersionamentoController.this.pacoteSelecionado == null ? null : ByteUtils.toByteArray((File)FinalizacaoVersionamentoController.this.pacoteSelecionado);
                if (FinalizacaoVersionamentoController.this.versionamento == null) {
                    throw new EmpacotamentoException("Selecione a BRANCH/PACOTE");
                }
                String servidorSvn = FinalizacaoVersionamentoController.this.getConfiguracaoSingleton().getServidorSvn();
                String loginSvn = FinalizacaoVersionamentoController.this.getConfiguracaoSingleton().getLogin();
                String senhaSvn = FinalizacaoVersionamentoController.this.getConfiguracaoSingleton().getSenha();
                String tag = RemoteFactory.getInstance().getProcessamento().geraNumeracaoTag(servidorSvn, loginSvn, senhaSvn, publicacaoType, FinalizacaoVersionamentoController.this.versionamento.getId());
                FinalizacaoVersionamentoController.this.versionamento.setTag(tag);
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                FinalizacaoVersionamentoController.this.startProcessLog();
                Platform.runLater(() -> FinalizacaoVersionamentoController.this.clearLog());
                FinalizacaoVersionamentoController.this.criaTaskAtualizacaoLabel();
                ArrayList log = new ArrayList();
                FinalizacaoVersionamentoController.this.getVersionamentoSvn().fimVersionamento(FinalizacaoVersionamentoController.this.getConfiguracaoSingleton().getServidorSvn(), FinalizacaoVersionamentoController.this.getConfiguracaoSingleton().getLogin(), senhaSvn, publicacaoType, FinalizacaoVersionamentoController.this.versionamento, null, log, FinalizacaoVersionamentoController.this.getOutputStream());
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosFimVersionamento(publicacaoType, FinalizacaoVersionamentoController.this.versionamento.getId(), FinalizacaoVersionamentoController.this.versionamento.getTag(), nomeArquivoOriginal, streamArquivo);
                Platform.runLater(() -> {
                    String branch = StringUtils.isNullOrEmpty((String)FinalizacaoVersionamentoController.this.versionamento.getNumeroSol()) ? FinalizacaoVersionamentoController.this.versionamento.getVersao() : FinalizacaoVersionamentoController.this.versionamento.getNumeroSol();
                    String dados = "###########################################\n- SISTEMA: " + FinalizacaoVersionamentoController.this.versionamento.getSistemaEntity().getSistema() + "\n- BRANCH: " + branch + "\n- SVN: " + FinalizacaoVersionamentoController.this.versionamento.getSistemaEntity().getProjetoSvn() + "\n- VERSIONADO COM SUCESSO ###\n###########################################\n";
                    log.add(dados);
                    FinalizacaoVersionamentoController.this.updateLogWebView(String.join((CharSequence)"\n", log));
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(dados);
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                });
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    FinalizacaoVersionamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(FinalizacaoVersionamentoController.this.anchorPane, this.getException().getMessage());
                    FinalizacaoVersionamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    FinalizacaoVersionamentoController.this.endProcessLog();
                    String mensagem = "Processamento Conclu\u00eddo com Sucesso";
                    MensagemView.getInstancia().mostraSucesso(FinalizacaoVersionamentoController.this.anchorPane, mensagem);
                    FinalizacaoVersionamentoController.this.habilitaComponentes();
                    FinalizacaoVersionamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    public void selecionarPacoteAction(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Resource File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Pacote JAVA", new String[]{"*.war", "*.jar", "*.ear"}), new FileChooser.ExtensionFilter("Pacote Delphi", new String[]{"*.exe", "*.rar", "*.zip", "*.tar"}), new FileChooser.ExtensionFilter("Todos Arquivos", new String[]{"*.*"})});
        this.pacoteSelecionado = fileChooser.showOpenDialog((Window)this.getStage());
        if (this.pacoteSelecionado != null) {
            this.labelPacoteSelecionado.setText(this.pacoteSelecionado.getAbsolutePath());
        }
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        if (this.radioButtonIndividual.isSelected()) {
            this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaIndividualFimVersionamento().stream().sorted(OrdenacaoLista.versionamentoComparator).collect(Collectors.toList()));
        } else if (this.radioButtonPacote.isSelected()) {
            this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaPacoteFimVersionamento());
        }
        this.comboBoxPlanejamento.setValue(null);
    }
}

